/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.service.location.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.kernel.service.location.internal.InternalWsResource;
import com.ibm.ws.kernel.service.location.internal.LocalDirectoryResource;
import com.ibm.ws.kernel.service.location.internal.SymbolicRootResource;
import com.ibm.ws.kernel.service.location.internal.WsLocationAdminImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.MalformedLocationException;
import com.ibm.wsspi.kernel.service.location.WsResource;
import com.ibm.wsspi.kernel.service.utils.OsgiPropertyUtils;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SymbolRegistry {
    static final TraceComponent tc = Tr.register(SymbolRegistry.class, (String)"locationService", (String)"com.ibm.ws.kernel.service.location.internal.resources.LocServiceMessages");
    static final Pattern SYMBOL_DEF = Pattern.compile("\\$\\{([^\\$\\(\\)]*?)\\}");
    private static final SymbolRegistry instance = new SymbolRegistry();
    static final int RECURSE_LIMIT = 10;
    private static final String EVENT_ADDED = "ADDED ${";
    private static final String EVENT_REPLACED = "REPLACED ${";
    private static final String EVENT_ADDED_MIDDLE = "}=";
    private final ConcurrentHashMap<String, SymRegEntry> stringToEntry = new ConcurrentHashMap();
    private final ConcurrentSkipListSet<RootRegEntry> rootPaths = new ConcurrentSkipListSet();
    static final long serialVersionUID = -7025838233203271862L;

    @Trivial
    public static SymbolRegistry getRegistry() {
        return instance;
    }

    public boolean addResourceSymbol(String symbol, InternalWsResource value) {
        SymRegEntry entry = new SymRegEntry(EntryType.RESOURCE, symbol, value);
        SymRegEntry prev = this.stringToEntry.putIfAbsent(symbol, entry);
        if (prev == null && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)instance, (TraceComponent)tc, (String)(EVENT_ADDED + symbol + EVENT_ADDED_MIDDLE + value), (Object[])new Object[0]);
        }
        return prev == null;
    }

    public synchronized boolean addRootSymbol(String symbol, LocalDirectoryResource value) {
        RootRegEntry entry = new RootRegEntry(symbol, value);
        SymRegEntry prev = this.stringToEntry.putIfAbsent(symbol, entry);
        if (prev == null) {
            if (value instanceof SymbolicRootResource) {
                this.rootPaths.add(entry);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)instance, (TraceComponent)tc, (String)(EVENT_ADDED + symbol + EVENT_ADDED_MIDDLE + value), (Object[])new Object[0]);
            }
            return true;
        }
        return false;
    }

    public boolean addStringSymbol(String symbol, String value) {
        SymRegEntry entry = new SymRegEntry(EntryType.STRING, symbol, value);
        SymRegEntry prev = this.stringToEntry.putIfAbsent(symbol, entry);
        if (prev == null && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)instance, (TraceComponent)tc, (String)(EVENT_ADDED + symbol + EVENT_ADDED_MIDDLE + value), (Object[])new Object[0]);
        }
        return prev == null;
    }

    public void replaceStringSymbol(String symbol, String value) {
        SymRegEntry entry = new SymRegEntry(EntryType.STRING, symbol, value);
        SymRegEntry prev = this.stringToEntry.put(symbol, entry);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            if (prev == null) {
                Tr.event((Object)instance, (TraceComponent)tc, (String)(EVENT_ADDED + symbol + EVENT_ADDED_MIDDLE + value), (Object[])new Object[0]);
            } else {
                Tr.event((Object)instance, (TraceComponent)tc, (String)(EVENT_REPLACED + symbol + EVENT_ADDED_MIDDLE + value), (Object[])new Object[0]);
            }
        }
    }

    public synchronized void removeSymbol(String symbol) {
        SymRegEntry entry = this.stringToEntry.remove(symbol);
        if (entry != null && entry.type == EntryType.ROOT) {
            this.rootPaths.remove(entry);
        }
    }

    public void clear() {
        this.stringToEntry.clear();
        this.rootPaths.clear();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)instance, (TraceComponent)tc, (String)"Symbol registry cleared", (Object[])new Object[0]);
        }
    }

    InternalWsResource resolveSymbolicResource(String symbolicPath) {
        if (symbolicPath == null) {
            throw new NullPointerException("Path must be non-null");
        }
        return this.resolveSymbols(symbolicPath, symbolicPath, 0);
    }

    String resolveSymbolicString(String symbolicPath) {
        if (symbolicPath == null) {
            throw new NullPointerException("Path must be non-null");
        }
        return this.resolveStringSymbols(symbolicPath, symbolicPath, true, 0, true);
    }

    String resolveRawSymbolicString(String string) {
        if (string == null) {
            throw new NullPointerException("String must be non-null");
        }
        return this.resolveStringSymbols(string, string, true, 0, false);
    }

    SymbolicRootResource findRoot(String normalPath) {
        for (RootRegEntry entry : this.rootPaths) {
            if (normalPath.length() < entry.path.length() || !normalPath.startsWith(entry.path)) continue;
            return (SymbolicRootResource)entry.value;
        }
        return null;
    }

    private InternalWsResource resolveSymbols(String originalPath, String path, int recurse) {
        if (recurse > 10) {
            throw new IllegalStateException("Exceeded recursion limit (orig=" + originalPath + ",path=" + path + ")");
        }
        Matcher m = SYMBOL_DEF.matcher(path);
        if (m.find()) {
            String symbol = m.group(1);
            String fullMatch = m.group();
            SymRegEntry entry = this.stringToEntry.get(symbol);
            if (entry != null) {
                if (path.equals(fullMatch)) {
                    switch (entry.type) {
                        case RESOURCE: 
                        case ROOT: {
                            return (InternalWsResource)entry.value;
                        }
                        case STRING: {
                            return this.resolveSymbols(originalPath, (String)entry.value, recurse + 1);
                        }
                    }
                } else {
                    int start = m.start();
                    int end = m.end();
                    String relativePath = null;
                    switch (entry.type) {
                        case RESOURCE: 
                        case ROOT: {
                            WsResource ar = (WsResource)entry.value;
                            if (ar.isType(WsResource.Type.FILE) && end != path.length()) {
                                throw new MalformedLocationException("Can not resolve additional path parameters against file resource");
                            }
                            relativePath = this.getRelativePath(originalPath, path, start, end, recurse);
                            return (InternalWsResource)ar.resolveRelative(relativePath);
                        }
                        case STRING: {
                            String value = (String)entry.value;
                            StringBuilder sb = new StringBuilder(start + value.length() + (path.length() - end));
                            sb.append(path.substring(0, start));
                            sb.append(entry.value);
                            sb.append(path.substring(end));
                            return this.resolveSymbols(originalPath, sb.toString(), recurse + 1);
                        }
                    }
                }
            } else {
                String value = OsgiPropertyUtils.getProperty(symbol, null);
                if (value != null) {
                    int start = m.start();
                    int end = m.end();
                    StringBuilder sb = new StringBuilder(start + value.length() + (path.length() - end));
                    sb.append(path.substring(0, start));
                    sb.append(value);
                    sb.append(path.substring(end));
                    String newPath = sb.toString();
                    return WsLocationAdminImpl.getInstance().resolveResource(newPath);
                }
            }
        }
        throw new MalformedLocationException("Unable to resolve symbolic path (path=" + path + ")");
    }

    private String getRelativePath(String originalPath, String path, int start, int end, int recurse) {
        if (path.length() < end) {
            throw new MalformedLocationException("Invalid symbolic path: end of symbol is beyond length of path (orig=" + originalPath + ",path=" + path + ")");
        }
        if (path.length() <= end + 1) {
            return "";
        }
        String relativePath = this.resolveStringSymbols(originalPath, path.substring(end + 1), false, recurse, true);
        return relativePath;
    }

    private String resolveStringSymbols(String originalPath, String path, boolean includeRoots, int recurse, boolean pathNormalize) {
        Matcher m;
        if (recurse > 10) {
            throw new IllegalStateException("Exceeded recursion limit (orig=" + originalPath + ",path=" + path + ")");
        }
        if (pathNormalize) {
            path = PathUtils.normalize(path);
        }
        if ((m = SYMBOL_DEF.matcher(path)).find()) {
            String symbol = m.group(1);
            String fullMatch = m.group();
            SymRegEntry entry = this.stringToEntry.get(symbol);
            if (entry != null) {
                switch (entry.type) {
                    default: {
                        if (includeRoots) {
                            String value = ((InternalWsResource)entry.value).getNormalizedPath();
                            if (path.equals(symbol)) {
                                return value;
                            }
                            return this.replaceAndResolveString(originalPath, path, includeRoots, recurse, m, value, pathNormalize);
                        }
                        throw new MalformedLocationException("Reference to a symbolic root in the path of another symbol (path=" + path + ",origPath=" + originalPath + ")");
                    }
                    case STRING: 
                }
                if (path.equals(fullMatch)) {
                    return this.resolveStringSymbols(originalPath, (String)entry.value, includeRoots, recurse + 1, pathNormalize);
                }
                String value = (String)entry.value;
                return this.replaceAndResolveString(originalPath, path, includeRoots, recurse, m, value, pathNormalize);
            }
            String value = OsgiPropertyUtils.getProperty(symbol, null);
            if (value != null) {
                return this.replaceAndResolveString(originalPath, path, includeRoots, recurse, m, value, pathNormalize);
            }
            if (symbol.startsWith("env.") && (value = System.getenv(symbol.substring(4))) != null) {
                return this.replaceAndResolveString(originalPath, path, includeRoots, recurse, m, value, pathNormalize);
            }
        }
        return path;
    }

    private String replaceAndResolveString(String originalPath, String path, boolean includeRoots, int recurse, Matcher m, String value, boolean pathNormalize) {
        int start = m.start();
        int end = m.end();
        StringBuilder sb = new StringBuilder(start + value.length() + (path.length() - end));
        sb.append(path.substring(0, start));
        sb.append(value);
        sb.append(path.substring(end));
        return this.resolveStringSymbols(originalPath, sb.toString(), includeRoots, recurse + 1, pathNormalize);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class RootRegEntry
    extends SymRegEntry
    implements Comparable<RootRegEntry> {
        final String path;
        static final long serialVersionUID = 8332597479601603445L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        RootRegEntry(String s, LocalDirectoryResource v) {
            super(EntryType.ROOT, s, v);
            this.path = v.getNormalizedPath() == null ? v.toRepositoryPath() : v.getNormalizedPath();
        }

        @Override
        @Trivial
        public int compareTo(RootRegEntry o) {
            if (this == o) {
                return 0;
            }
            if (this.path.length() == o.path.length()) {
                return this.path.compareTo(o.path);
            }
            return this.path.length() > o.path.length() ? -1 : 1;
        }

        public String toString() {
            return this.path.length() + "-" + this.path;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.service.location.internal.SymbolRegistry$RootRegEntry", RootRegEntry.class, (String)"locationService", (String)"com.ibm.ws.kernel.service.location.internal.resources.LocServiceMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class SymRegEntry {
        final EntryType type;
        final String symbol;
        final Object value;
        static final long serialVersionUID = -1459881695269609558L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        SymRegEntry(EntryType t, String s, Object v) {
            this.type = t;
            this.symbol = s;
            this.value = v;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.service.location.internal.SymbolRegistry$SymRegEntry", SymRegEntry.class, (String)"locationService", (String)"com.ibm.ws.kernel.service.location.internal.resources.LocServiceMessages");
        }
    }

    static enum EntryType {
        ROOT,
        RESOURCE,
        STRING;

    }
}

