/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.service.util;

import com.ibm.lang.management.OperatingSystemMXBean;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.service.util.AvailableProcessorsListener;
import com.ibm.ws.kernel.service.util.JavaInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.checkpoint.spi.CheckpointHook;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CpuInfo {
    private static final TraceComponent tc = Tr.register(CpuInfo.class, null, (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
    private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){
        static final long serialVersionUID = -5930997719516040648L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName("Liberty-kernel-CpuInfo");
            t.setDaemon(true);
            return t;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.service.util.CpuInfo$1", 1.class, null, (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
        }
    });
    private static final CpuInfo INSTANCE = new CpuInfo();
    private final AtomicInteger AVAILABLE_PROCESSORS_INTEGER = new AtomicInteger(-1);
    private final AtomicInteger AVAILABLE_PROCESSORS_FLOAT = new AtomicInteger(-1);
    private final CPUCount cpuCount;
    private CpuInfoAccessor osmx;
    private final int cpuNSFactor;
    private long lastProcessCPUTime = 0L;
    private double lastProcessCpuUsage = -1.0;
    private long lastSystemTimeMillis = -1L;
    private final IntervalTask activeTask = new IntervalTask();
    private static final long INTERVAL = 10L;
    private static final int CHECKPOINT_CPUS = 4;
    private static Collection<AvailableProcessorsListener> listeners = Collections.synchronizedCollection(new HashSet());
    private static long lastChecked = System.currentTimeMillis();
    private static final long CATCH_UP_INTERVAL = 30000L;
    static final long serialVersionUID = -6431782939697073077L;

    private CpuInfo() {
        executor.scheduleAtFixedRate(this.activeTask, 10L, 10L, TimeUnit.MINUTES);
        this.cpuCount = new CPUCount();
        int runtimeAvailableProcessors = Runtime.getRuntime().availableProcessors();
        float fileSystemAvailableProcessors = CpuInfo.getAvailableProcessorsFromFilesystemFloat();
        if (fileSystemAvailableProcessors <= 0.0f || fileSystemAvailableProcessors > (float)runtimeAvailableProcessors) {
            this.AVAILABLE_PROCESSORS_INTEGER.set(runtimeAvailableProcessors);
            this.AVAILABLE_PROCESSORS_FLOAT.set(runtimeAvailableProcessors * 100);
        } else {
            this.AVAILABLE_PROCESSORS_INTEGER.set(CpuInfo.roundUpToNextInt(fileSystemAvailableProcessors));
            this.AVAILABLE_PROCESSORS_FLOAT.set((int)(fileSystemAvailableProcessors * 100.0f));
        }
        CheckpointPhase phase = CheckpointPhase.getPhase();
        if (phase != CheckpointPhase.INACTIVE) {
            phase.addMultiThreadedHook((CheckpointHook)this.activeTask);
            if (this.AVAILABLE_PROCESSORS_INTEGER.get() > 4) {
                this.AVAILABLE_PROCESSORS_INTEGER.set(4);
                this.AVAILABLE_PROCESSORS_FLOAT.set(400);
            }
        }
        int nsFactor = 1;
        if (JavaInfo.isSystemClassAvailable("com.ibm.security.auth.module.Krb5LoginModule")) {
            int majorVersion = JavaInfo.majorVersion();
            int minorVersion = JavaInfo.minorVersion();
            int serviceRelease = JavaInfo.serviceRelease();
            if (majorVersion == 8 && minorVersion == 0 && serviceRelease < 5) {
                nsFactor = 100;
            }
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"IBM Java level check", (Object[])new Object[]{"majorVersion: " + majorVersion + ", minorVersion: " + minorVersion + ", serviceRelease: " + serviceRelease + ", cpuNSFactor: " + nsFactor});
            }
        }
        this.cpuNSFactor = nsFactor;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized double getSystemCPU() {
        double cpuUsage = -1.0;
        try {
            if (this.osmx == null) {
                this.osmx = CpuInfo.createCpuInfoAccessor();
            }
            cpuUsage = this.osmx.getSystemCpuLoad();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.kernel.service.util.CpuInfo", (String)"142", (Object)this, (Object[])new Object[0]);
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getSystemCPU");
        }
        if (cpuUsage >= 0.0 && (cpuUsage *= 100.0) > 100.0) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"getSystemCPU error", (Object[])new Object[]{"system CPU out-of-range: " + cpuUsage});
            }
            cpuUsage = -1.0;
        }
        return cpuUsage;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized double getProcessCPU() {
        long currentTimeMs = System.currentTimeMillis();
        if (currentTimeMs - this.lastSystemTimeMillis < 500L) {
            return this.lastProcessCpuUsage;
        }
        double cpuUsage = -1.0;
        long processCpuTime = -1L;
        try {
            if (this.osmx == null) {
                this.osmx = CpuInfo.createCpuInfoAccessor();
            }
            processCpuTime = this.osmx.getProcessCpuTime();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.kernel.service.util.CpuInfo", (String)"174", (Object)this, (Object[])new Object[0]);
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getProcessCPU");
        }
        if (processCpuTime != -1L) {
            long d1 = (currentTimeMs - this.lastSystemTimeMillis) * 1000000L;
            long d2 = processCpuTime - this.lastProcessCPUTime;
            cpuUsage = (double)d2 / (double)d1;
            cpuUsage = cpuUsage / ((double)this.AVAILABLE_PROCESSORS_FLOAT.floatValue() / 100.0) * (double)this.cpuNSFactor * 100.0;
            this.lastSystemTimeMillis = currentTimeMs;
            this.lastProcessCPUTime = processCpuTime;
        }
        if (cpuUsage > 100.0 && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"getProcessCPU anomaly", (Object[])new Object[]{"process CPU out-of-range: " + cpuUsage});
        }
        this.lastProcessCpuUsage = cpuUsage;
        return cpuUsage;
    }

    /*
     * WARNING - void declaration
     */
    private static float getAvailableProcessorsFromFilesystemFloat() {
        float availableProcessorsFloat;
        block10: {
            boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
            availableProcessorsFloat = -1.0f;
            String periodFileLocation = File.separator + "sys" + File.separator + "fs" + File.separator + "cgroup" + File.separator + "cpu" + File.separator + "cpu.cfs_period_us";
            String quotaFileLocation = File.separator + "sys" + File.separator + "fs" + File.separator + "cgroup" + File.separator + "cpu" + File.separator + "cpu.cfs_quota_us";
            File cfsPeriod = new File(periodFileLocation);
            File cfsQuota = new File(quotaFileLocation);
            if (cfsPeriod.exists() && cfsQuota.exists()) {
                try {
                    String quotaContents = CpuInfo.readFile(cfsQuota);
                    float quotaFloat = Float.parseFloat(quotaContents);
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("quotaFloat = " + quotaFloat), (Object[])new Object[0]);
                    }
                    if (!(quotaFloat >= 0.0f)) break block10;
                    String periodContents = CpuInfo.readFile(cfsPeriod);
                    float periodFloat = Float.parseFloat(periodContents);
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("periodFloat = " + periodFloat), (Object[])new Object[0]);
                    }
                    if (periodFloat != 0.0f) {
                        availableProcessorsFloat = quotaFloat / periodFloat;
                        availableProcessorsFloat = CpuInfo.roundToTwoDecimalPlaces(availableProcessorsFloat);
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Calculated availableProcessors: " + availableProcessorsFloat + ". period=" + periodFloat + ", quota=" + quotaFloat), (Object[])new Object[0]);
                        }
                    }
                }
                catch (Throwable quotaContents) {
                    FFDCFilter.processException((Throwable)quotaContents, (String)"com.ibm.ws.kernel.service.util.CpuInfo", (String)"232", null, (Object[])new Object[0]);
                    if (isTraceOn && tc.isDebugEnabled()) {
                        void e;
                        Tr.debug((TraceComponent)tc, (String)("Caught exception: " + e.getMessage() + ". Using number of processors reported by java"), (Object[])new Object[0]);
                    }
                    availableProcessorsFloat = -1.0f;
                }
            } else if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Files " + quotaFileLocation + " : " + cfsQuota.exists()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("Files " + periodFileLocation + " : " + cfsPeriod.exists()), (Object[])new Object[0]);
            }
        }
        return availableProcessorsFloat;
    }

    private static String readFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        BufferedReader buf = new BufferedReader(new InputStreamReader((InputStream)is, StandardCharsets.UTF_8));
        String line = buf.readLine();
        StringBuilder sb = new StringBuilder();
        while (line != null) {
            sb.append(line).append("\n");
            line = buf.readLine();
        }
        buf.close();
        ((InputStream)is).close();
        return sb.toString();
    }

    private static float roundToTwoDecimalPlaces(float f) {
        BigDecimal bd = new BigDecimal(f);
        bd = bd.setScale(2, RoundingMode.DOWN);
        return bd.floatValue();
    }

    private static int roundUpToNextInt(float f) {
        BigDecimal bd = new BigDecimal(f);
        bd = bd.setScale(0, RoundingMode.UP);
        return bd.intValue();
    }

    public static CPUCount getAvailableProcessors() {
        return CpuInfo.INSTANCE.cpuCount;
    }

    public static double getJavaCpuUsage() {
        return INSTANCE.getProcessCPU();
    }

    public static double getSystemCpuUsage() {
        return INSTANCE.getSystemCPU();
    }

    public static void addAvailableProcessorsListener(AvailableProcessorsListener listener) {
        listeners.add(listener);
    }

    public static void removeAvailableProcessorsListener(AvailableProcessorsListener listener) {
        listeners.remove(listener);
    }

    public static CpuInfoAccessor createCpuInfoAccessor() {
        java.lang.management.OperatingSystemMXBean mbean = ManagementFactory.getOperatingSystemMXBean();
        if (mbean == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Returning NullCpuInfoAccessor", (Object[])new Object[0]);
            }
            return new NullCpuInfoAccessor();
        }
        try {
            if (JavaInfo.isSystemClassAvailable("com.ibm.lang.management.OperatingSystemMXBean")) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Returning IBMJavaCpuInfoAccessor", (Object[])new Object[0]);
                }
                return new IBMJavaCpuInfoAccessor(mbean);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Returning ModernJavaCpuInfoAccessor", (Object[])new Object[0]);
            }
            return new ModernJavaCpuInfoAccessor(mbean);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            FFDCFilter.processException((Throwable)noClassDefFoundError, (String)"com.ibm.ws.kernel.service.util.CpuInfo", (String)"330", null, (Object[])new Object[0]);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Returning StandardAPICpuInfoAccessor", (Object[])new Object[0]);
            }
            return new StandardAPICpuInfoAccessor(mbean);
        }
    }

    @Trivial
    public class CPUCount {
        public int get() {
            return CpuInfo.this.AVAILABLE_PROCESSORS_INTEGER.get();
        }

        public String toString() {
            return Integer.toString(CpuInfo.this.AVAILABLE_PROCESSORS_INTEGER.get());
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    class IntervalTask
    implements Runnable,
    CheckpointHook {
        static final long serialVersionUID = 4010085875471929164L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        IntervalTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void prepare() {
            CpuInfo cpuInfo = CpuInfo.this;
            synchronized (cpuInfo) {
                try {
                    if (CpuInfo.this.osmx == null) {
                        CpuInfo.this.osmx = CpuInfo.createCpuInfoAccessor();
                    }
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.kernel.service.util.CpuInfo$IntervalTask", (String)"439", (Object)this, (Object[])new Object[0]);
                    FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"prepare()");
                    throw new RuntimeException("e.getMessage()", (Throwable)e);
                }
            }
        }

        public void restore() {
            this.run();
        }

        @Override
        public void run() {
            int newAvailableProcessorsFloat;
            int newAvailableProcessorsInt;
            long current = System.currentTimeMillis();
            if (current - lastChecked < 30000L) {
                lastChecked = current;
                return;
            }
            int runtimeAvailableProcessors = Runtime.getRuntime().availableProcessors();
            float fileSystemAvailableProcessors = CpuInfo.getAvailableProcessorsFromFilesystemFloat();
            if (fileSystemAvailableProcessors <= 0.0f || fileSystemAvailableProcessors > (float)runtimeAvailableProcessors) {
                newAvailableProcessorsInt = runtimeAvailableProcessors;
                newAvailableProcessorsFloat = runtimeAvailableProcessors * 100;
            } else {
                newAvailableProcessorsInt = CpuInfo.roundUpToNextInt(fileSystemAvailableProcessors);
                newAvailableProcessorsFloat = (int)(fileSystemAvailableProcessors * 100.0f);
            }
            int currentNumberOfProcessorsInt = CpuInfo.this.AVAILABLE_PROCESSORS_INTEGER.get();
            int currentNumberOfProcessorsFloat = CpuInfo.this.AVAILABLE_PROCESSORS_FLOAT.get();
            if (currentNumberOfProcessorsFloat != newAvailableProcessorsFloat) {
                CpuInfo.this.AVAILABLE_PROCESSORS_FLOAT.set(newAvailableProcessorsFloat);
            }
            if (currentNumberOfProcessorsInt != newAvailableProcessorsInt && CpuInfo.this.AVAILABLE_PROCESSORS_INTEGER.compareAndSet(currentNumberOfProcessorsInt, newAvailableProcessorsInt)) {
                this.notifyListeners(newAvailableProcessorsInt);
            }
            lastChecked = System.currentTimeMillis();
        }

        /*
         * WARNING - void declaration
         */
        public void notifyListeners(int processors) {
            ArrayList listenersCopy = new ArrayList(listeners);
            for (AvailableProcessorsListener listener : listenersCopy) {
                try {
                    listener.setAvailableProcessors(processors);
                }
                catch (Throwable throwable) {
                    void t;
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.kernel.service.util.CpuInfo$IntervalTask", (String)"500", (Object)this, (Object[])new Object[]{processors});
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Caught exception: " + t.getMessage() + "."), (Object[])new Object[0]);
                    }
                    FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"notifyListeners");
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.service.util.CpuInfo$IntervalTask", IntervalTask.class, null, (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class StandardAPICpuInfoAccessor
    implements CpuInfoAccessor {
        private final ObjectName objectName;
        private final MBeanServer mBeanServer;
        static final long serialVersionUID = 1064874384498110215L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public StandardAPICpuInfoAccessor(java.lang.management.OperatingSystemMXBean jvmMbean) {
            this.objectName = jvmMbean.getObjectName();
            this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        }

        @Override
        public long getProcessCpuTime() {
            try {
                return (Long)this.mBeanServer.getAttribute(this.objectName, "ProcessCpuTime");
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.kernel.service.util.CpuInfo$StandardAPICpuInfoAccessor", (String)"406", (Object)this, (Object[])new Object[0]);
                return -1L;
            }
        }

        @Override
        public double getSystemCpuLoad() {
            try {
                return (Double)this.mBeanServer.getAttribute(this.objectName, "SystemCpuLoad");
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.kernel.service.util.CpuInfo$StandardAPICpuInfoAccessor", (String)"415", (Object)this, (Object[])new Object[0]);
                return -1.0;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.service.util.CpuInfo$StandardAPICpuInfoAccessor", StandardAPICpuInfoAccessor.class, null, (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ModernJavaCpuInfoAccessor
    implements CpuInfoAccessor {
        private final com.sun.management.OperatingSystemMXBean mbean;
        static final long serialVersionUID = 6891878823332654349L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ModernJavaCpuInfoAccessor(java.lang.management.OperatingSystemMXBean jvmMbean) {
            this.mbean = (com.sun.management.OperatingSystemMXBean)jvmMbean;
        }

        @Override
        public long getProcessCpuTime() {
            return this.mbean.getProcessCpuTime();
        }

        @Override
        public double getSystemCpuLoad() {
            return this.mbean.getSystemCpuLoad();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.service.util.CpuInfo$ModernJavaCpuInfoAccessor", ModernJavaCpuInfoAccessor.class, null, (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class IBMJavaCpuInfoAccessor
    implements CpuInfoAccessor {
        private final OperatingSystemMXBean mbean;
        static final long serialVersionUID = 3828959572572075942L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public IBMJavaCpuInfoAccessor(java.lang.management.OperatingSystemMXBean jvmMbean) {
            this.mbean = (OperatingSystemMXBean)jvmMbean;
        }

        @Override
        public long getProcessCpuTime() {
            return this.mbean.getProcessCpuTime();
        }

        @Override
        public double getSystemCpuLoad() {
            return this.mbean.getSystemCpuLoad();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.service.util.CpuInfo$IBMJavaCpuInfoAccessor", IBMJavaCpuInfoAccessor.class, null, (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class NullCpuInfoAccessor
    implements CpuInfoAccessor {
        static final long serialVersionUID = -7098881151618064483L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private NullCpuInfoAccessor() {
        }

        @Override
        public long getProcessCpuTime() {
            return -1L;
        }

        @Override
        public double getSystemCpuLoad() {
            return -1.0;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.service.util.CpuInfo$NullCpuInfoAccessor", NullCpuInfoAccessor.class, null, (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
        }
    }

    private static interface CpuInfoAccessor {
        public long getProcessCpuTime();

        public double getSystemCpuLoad();
    }
}

