/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.json.xml;

import com.ibm.json.xml.internal.JSONSAXHandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XMLToJSONTransformer {
    private static String className = "com.ibm.json.xml.transform.XMLToJSONTransformer";
    private static Logger logger = Logger.getLogger(className, null);

    public static void transform(InputStream XMLStream, OutputStream JSONStream) throws SAXException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "transform(InputStream, OutputStream)");
        }
        XMLToJSONTransformer.transform(XMLStream, JSONStream, false);
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "transform(InputStream, OutputStream)");
        }
    }

    public static void transform(InputStream XMLStream, OutputStream JSONStream, boolean verbose) throws SAXException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "transform(InputStream, OutputStream)");
        }
        if (XMLStream == null) {
            throw new NullPointerException("XMLStream cannot be null");
        }
        if (JSONStream == null) {
            throw new NullPointerException("JSONStream cannot be null");
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, className, "transform", "Fetching a SAX parser for use with JSONSAXHandler");
        }
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser sParser = factory.newSAXParser();
            XMLReader parser = sParser.getXMLReader();
            JSONSAXHandler jsonHandler = new JSONSAXHandler(JSONStream, verbose);
            parser.setContentHandler((ContentHandler)jsonHandler);
            parser.setErrorHandler((ErrorHandler)jsonHandler);
            InputSource source = new InputSource(new BufferedInputStream(XMLStream));
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, className, "transform", "Parsing the XML content to JSON");
            }
            source.setEncoding("UTF-8");
            parser.parse(source);
            jsonHandler.flushBuffer();
        }
        catch (ParserConfigurationException pce) {
            throw new SAXException("Could not get a parser: " + pce.toString());
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "transform(InputStream, OutputStream)");
        }
    }

    public static String transform(InputStream xmlStream) throws SAXException, IOException {
        return XMLToJSONTransformer.transform(xmlStream, false);
    }

    public static String transform(InputStream xmlStream, boolean verbose) throws SAXException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "transform(InputStream, boolean)");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String result = null;
        try {
            XMLToJSONTransformer.transform(xmlStream, baos, verbose);
            result = baos.toString("UTF-8");
            baos.close();
        }
        catch (UnsupportedEncodingException uec) {
            IOException iox = new IOException(uec.toString());
            iox.initCause(uec);
            throw iox;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "transform(InputStream, boolean)");
        }
        return result;
    }

    public static String transform(File xmlFile, boolean verbose) throws SAXException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "transform(InputStream, boolean)");
        }
        FileInputStream fis = new FileInputStream(xmlFile);
        String result = null;
        result = XMLToJSONTransformer.transform((InputStream)fis, verbose);
        fis.close();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "transform(InputStream, boolean)");
        }
        return result;
    }

    public static String transform(File xmlFile) throws SAXException, IOException {
        return XMLToJSONTransformer.transform(xmlFile, false);
    }
}

