/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.restfulWS.providers;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import io.openliberty.restfulWS.client.security.LtpaHandler;
import io.openliberty.restfulWS.client.security.OAuthHandler;
import io.openliberty.restfulWS.client.security.SamlPropagationHandler;
import jakarta.annotation.Priority;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import java.io.IOException;

@Priority(value=999)
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class ClientConfigFilter
implements ClientRequestFilter {
    private static final TraceComponent tc = Tr.register(ClientConfigFilter.class, (String)"RESTfulWS", (String)"io.openliberty.org.jboss.resteasy.common.nls.RESTfulWSServer");
    static final long serialVersionUID = 5439815594812716821L;

    @ManualTrace
    public void filter(ClientRequestContext crc) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"filter", (Object[])new Object[]{crc});
        }
        if (ClientConfigFilter.isTrue(crc.getProperty("com.ibm.ws.jaxrs.client.ltpa.handler"))) {
            LtpaHandler.configClientLtpaHandler(crc);
        }
        if (ClientConfigFilter.isTrue(crc.getProperty("com.ibm.ws.jaxrs.client.mpjwt.sendToken"))) {
            OAuthHandler.handleMpJwtToken(crc);
        }
        if (ClientConfigFilter.isTrue(crc.getProperty("com.ibm.ws.jaxrs.client.oidc.sendJwtToken"))) {
            OAuthHandler.handleJwtToken(crc);
        }
        if (ClientConfigFilter.isTrue(crc.getProperty("com.ibm.ws.jaxrs.client.oauth.sendToken"))) {
            OAuthHandler.handleOAuthToken(crc);
        }
        if (ClientConfigFilter.isTrue(crc.getProperty("com.ibm.ws.jaxrs.client.saml.sendToken"))) {
            SamlPropagationHandler.configClientSAMLHandler(crc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"filter");
        }
    }

    private static boolean isTrue(Object o) {
        return Boolean.TRUE.equals(o) || "true".equals(o);
    }
}

