/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.lang.reflect.Proxy;
import org.jboss.resteasy.core.ResourceLocatorInvoker;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.registry.RootNode;
import org.jboss.resteasy.specimpl.ResteasyUriInfo;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.ResourceInvoker;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.metadata.ResourceBuilder;
import org.jboss.resteasy.spi.metadata.ResourceClass;
import org.jboss.resteasy.spi.metadata.ResourceLocator;
import org.jboss.resteasy.spi.metadata.ResourceMethod;
import org.jboss.resteasy.spi.statistics.StatisticsController;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class LocatorRegistry {
    protected RootNode root = new RootNode();
    protected ResteasyProviderFactory providerFactory;
    protected StatisticsController statisticsController;
    static final long serialVersionUID = -1987829194819077348L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public LocatorRegistry(Class<?> clazz, ResteasyProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
        this.statisticsController = providerFactory.getStatisticsController();
        ResourceBuilder resourceBuilder = providerFactory.getResourceBuilder();
        if (Proxy.isProxyClass(clazz)) {
            for (Class<?> intf : clazz.getInterfaces()) {
                ResourceClass resourceClass = resourceBuilder.getLocatorFromAnnotations(intf);
                this.register(resourceClass);
            }
        } else {
            ResourceClass resourceClass = resourceBuilder.getLocatorFromAnnotations(clazz);
            this.register(resourceClass);
        }
    }

    public void register(ResourceClass resourceClass) {
        for (ResourceMethod resourceMethod : resourceClass.getResourceMethods()) {
            this.processMethod(resourceMethod);
        }
        for (ResourceLocator resourceLocator : resourceClass.getResourceLocators()) {
            this.processMethod(resourceLocator);
        }
    }

    protected void processMethod(ResourceLocator method) {
        String fullpath = method.getFullpath() == null ? "" : method.getFullpath();
        InjectorFactory injectorFactory = this.providerFactory.getInjectorFactory();
        if (method instanceof ResourceMethod) {
            ResourceMethodInvoker invoker = new ResourceMethodInvoker((ResourceMethod)method, injectorFactory, null, this.providerFactory);
            this.root.addInvoker(fullpath, invoker);
            this.statisticsController.register(invoker);
        } else {
            ResourceLocatorInvoker locator = new ResourceLocatorInvoker(null, injectorFactory, this.providerFactory, method);
            this.root.addInvoker(fullpath, locator);
        }
    }

    public ResourceInvoker getResourceInvoker(HttpRequest request) {
        String currentUri = ((ResteasyUriInfo)request.getUri()).getEncodedMatchedPaths().get(0);
        int startAt = currentUri.length();
        return this.root.match(request, startAt);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.core.LocatorRegistry", LocatorRegistry.class, null, null);
    }
}

