/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.interceptors;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;

@PreMatching
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class CorsFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    protected boolean allowCredentials = true;
    protected String allowedMethods;
    protected String allowedHeaders;
    protected String exposedHeaders;
    protected int corsMaxAge = -1;
    protected Set<String> allowedOrigins = new HashSet<String>();
    static final long serialVersionUID = -611235461209464859L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public Set<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public boolean isAllowCredentials() {
        return this.allowCredentials;
    }

    public void setAllowCredentials(boolean allowCredentials) {
        this.allowCredentials = allowCredentials;
    }

    public String getAllowedMethods() {
        return this.allowedMethods;
    }

    public void setAllowedMethods(String allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    public String getAllowedHeaders() {
        return this.allowedHeaders;
    }

    public void setAllowedHeaders(String allowedHeaders) {
        this.allowedHeaders = allowedHeaders;
    }

    public int getCorsMaxAge() {
        return this.corsMaxAge;
    }

    public void setCorsMaxAge(int corsMaxAge) {
        this.corsMaxAge = corsMaxAge;
    }

    public String getExposedHeaders() {
        return this.exposedHeaders;
    }

    public void setExposedHeaders(String exposedHeaders) {
        this.exposedHeaders = exposedHeaders;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String origin = requestContext.getHeaderString("Origin");
        if (origin == null) {
            return;
        }
        if (requestContext.getMethod().equalsIgnoreCase("OPTIONS")) {
            this.preflight(origin, requestContext);
        } else {
            this.checkOrigin(requestContext, origin);
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        String origin = requestContext.getHeaderString("Origin");
        if (origin == null || requestContext.getMethod().equalsIgnoreCase("OPTIONS") || requestContext.getProperty("cors.failure") != null) {
            return;
        }
        responseContext.getHeaders().putSingle((Object)"Access-Control-Allow-Origin", (Object)origin);
        responseContext.getHeaders().putSingle((Object)"Vary", (Object)"Origin");
        if (this.isAllowCredentials()) {
            responseContext.getHeaders().putSingle((Object)"Access-Control-Allow-Credentials", (Object)"true");
        }
        if (this.getExposedHeaders() != null) {
            responseContext.getHeaders().putSingle((Object)"Access-Control-Expose-Headers", (Object)this.getExposedHeaders());
        }
    }

    protected void preflight(String origin, ContainerRequestContext requestContext) throws IOException {
        String allowHeaders;
        String requestMethods;
        this.checkOrigin(requestContext, origin);
        Response.ResponseBuilder builder = Response.ok();
        builder.header("Access-Control-Allow-Origin", (Object)origin);
        builder.header("Vary", (Object)"Origin");
        if (this.isAllowCredentials()) {
            builder.header("Access-Control-Allow-Credentials", (Object)"true");
        }
        if ((requestMethods = requestContext.getHeaderString("Access-Control-Request-Method")) != null) {
            if (this.getAllowedMethods() != null) {
                requestMethods = this.getAllowedMethods();
            }
            builder.header("Access-Control-Allow-Methods", (Object)requestMethods);
        }
        if ((allowHeaders = requestContext.getHeaderString("Access-Control-Request-Headers")) != null) {
            if (this.getAllowedHeaders() != null) {
                allowHeaders = this.getAllowedHeaders();
            }
            builder.header("Access-Control-Allow-Headers", (Object)allowHeaders);
        }
        if (this.getCorsMaxAge() > -1) {
            builder.header("Access-Control-Max-Age", (Object)this.getCorsMaxAge());
        }
        requestContext.abortWith(builder.build());
    }

    protected void checkOrigin(ContainerRequestContext requestContext, String origin) {
        if (!this.getAllowedOrigins().contains("*") && !this.getAllowedOrigins().contains(origin)) {
            requestContext.setProperty("cors.failure", (Object)true);
            throw new ForbiddenException(Messages.MESSAGES.originNotAllowed(origin));
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.interceptors.CorsFilter", CorsFilter.class, null, null);
    }
}

