/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.ws.rs.ext.ParamConverter;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.jboss.resteasy.core.StringParameterInjector;
import org.jboss.resteasy.plugins.providers.MultiValuedAbstractParamConverter;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class MultiValuedArrayParamConverter
extends MultiValuedAbstractParamConverter
implements ParamConverter<Object> {
    private Class<?> rawType;
    static final long serialVersionUID = 2464069859702885112L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public MultiValuedArrayParamConverter(StringParameterInjector stringParameterInjector, String separator, Class<?> rawType) {
        super(stringParameterInjector, separator);
        this.rawType = rawType;
    }

    public String toString(Object value) {
        if (value == null) {
            return null;
        }
        if (!value.getClass().isArray()) {
            throw new RuntimeException(Messages.MESSAGES.expectedArray(value.getClass().getName()));
        }
        Object[] values = new Object[Array.getLength(value)];
        if (values.length == 0) {
            return "";
        }
        if (this.rawType.getComponentType().isPrimitive()) {
            this.copyPrimitiveArray(values, value);
        } else {
            values = (Object[])value;
        }
        return this.stringify(Arrays.asList(values));
    }

    public Object fromString(String param) {
        String[] elements = param.split(this.separator);
        Object array = Array.newInstance(this.rawType.getComponentType(), elements.length);
        try {
            for (int i = 0; i < elements.length; ++i) {
                Array.set(array, i, this.stringParameterInjector.extractValue(elements[i]));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.MESSAGES.errorCreatingArray(param));
        }
        return array;
    }

    private void copyPrimitiveArray(Object[] objectArray, Object primitiveArray) {
        int primitiveArrayLength = Array.getLength(primitiveArray);
        for (int i = 0; i < primitiveArrayLength; ++i) {
            objectArray[i] = Array.get(primitiveArray, i);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.providers.MultiValuedArrayParamConverter", MultiValuedArrayParamConverter.class, null, null);
    }
}

