/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.servlet;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.plugins.server.servlet.HttpServletResponseHeaders;
import org.jboss.resteasy.spi.AsyncOutputStream;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class HttpServletResponseWrapper
implements HttpResponse {
    protected HttpServletResponse response;
    protected int status = 200;
    protected MultivaluedMap<String, Object> outputHeaders;
    protected ResteasyProviderFactory factory;
    protected OutputStream outputStream = new DeferredOutputStream();
    protected volatile boolean suppressExceptionDuringChunkedTransfer = true;
    protected HttpServletRequest request;
    protected Map<Class<?>, Object> contextDataMap;
    static final long serialVersionUID = 2556160139528105213L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Override
    public void setSuppressExceptionDuringChunkedTransfer(boolean suppressExceptionDuringChunkedTransfer) {
        this.suppressExceptionDuringChunkedTransfer = suppressExceptionDuringChunkedTransfer;
    }

    @Override
    public boolean suppressExceptionDuringChunkedTransfer() {
        return this.suppressExceptionDuringChunkedTransfer;
    }

    public HttpServletResponseWrapper(HttpServletResponse response, HttpServletRequest request, ResteasyProviderFactory factory) {
        this.response = response;
        this.request = request;
        this.outputHeaders = new HttpServletResponseHeaders(response, factory);
        this.factory = factory;
        this.contextDataMap = ResteasyContext.getContextDataMap();
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
        this.response.setStatus(status);
    }

    @Override
    public MultivaluedMap<String, Object> getOutputHeaders() {
        return this.outputHeaders;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    @Override
    public void setOutputStream(OutputStream os) {
        this.outputStream = os;
    }

    @Override
    public void addNewCookie(NewCookie cookie) {
        this.outputHeaders.add((Object)"Set-Cookie", (Object)cookie);
    }

    @Override
    public void sendError(int status) throws IOException {
        this.response.sendError(status);
    }

    @Override
    public void sendError(int status, String message) throws IOException {
        this.response.sendError(status, message);
    }

    @Override
    public boolean isCommitted() {
        return this.response.isCommitted();
    }

    @Override
    public void reset() {
        this.response.reset();
        this.outputHeaders = new HttpServletResponseHeaders(this.response, this.factory);
    }

    @Override
    public void flushBuffer() throws IOException {
        this.response.flushBuffer();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.server.servlet.HttpServletResponseWrapper", HttpServletResponseWrapper.class, null, null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    protected class DeferredOutputStream
    extends AsyncOutputStream
    implements WriteListener {
        private boolean asyncRegistered;
        private Queue<AsyncOperation> asyncQueue;
        private AsyncOperation lastAsyncOperation;
        private boolean asyncListenerCalled;
        static final long serialVersionUID = -9187275866270265294L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        protected DeferredOutputStream() {
        }

        @Override
        public void write(int i) throws IOException {
            HttpServletResponseWrapper.this.response.getOutputStream().write(i);
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            HttpServletResponseWrapper.this.response.getOutputStream().write(bytes);
        }

        @Override
        public void write(byte[] bytes, int i, int i1) throws IOException {
            HttpServletResponseWrapper.this.response.getOutputStream().write(bytes, i, i1);
        }

        @Override
        public void flush() throws IOException {
            HttpServletResponseWrapper.this.response.getOutputStream().flush();
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public CompletionStage<Void> asyncFlush() {
            FlushOperation op = new FlushOperation(this);
            this.queue(op);
            return op.future;
        }

        @Override
        public CompletionStage<Void> asyncWrite(byte[] bytes, int offset, int length) {
            WriteOperation op = new WriteOperation(this, bytes, offset, length);
            this.queue(op);
            return op.future;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void queue(AsyncOperation op) {
            HttpRequest resteasyRequest = (HttpRequest)HttpServletResponseWrapper.this.contextDataMap.get(HttpRequest.class);
            if (HttpServletResponseWrapper.this.request.isAsyncStarted() && !resteasyRequest.getAsyncContext().isOnInitialRequest()) {
                DeferredOutputStream deferredOutputStream = this;
                synchronized (deferredOutputStream) {
                    ServletOutputStream os;
                    try {
                        os = HttpServletResponseWrapper.this.response.getOutputStream();
                    }
                    catch (IOException e) {
                        op.future.completeExceptionally(e);
                        return;
                    }
                    if (!this.asyncRegistered) {
                        this.asyncRegistered = true;
                        this.addToQueue(op);
                        os.setWriteListener((WriteListener)this);
                    } else if (this.asyncListenerCalled && os.isReady()) {
                        this.addToQueue(op);
                        this.flushQueue(os);
                    } else {
                        this.addToQueue(op);
                    }
                }
            }
            op.work(null);
        }

        private void flushQueue(ServletOutputStream sos) {
            if (this.lastAsyncOperation != null) {
                this.lastAsyncOperation.future.complete(null);
                this.lastAsyncOperation = null;
            }
            while (!this.asyncQueue.isEmpty() && sos.isReady()) {
                this.lastAsyncOperation = this.asyncQueue.poll();
                this.lastAsyncOperation.work(sos);
            }
        }

        private synchronized void addToQueue(AsyncOperation op) {
            if (this.asyncQueue == null) {
                this.asyncQueue = new ConcurrentLinkedQueue<AsyncOperation>();
            }
            this.asyncQueue.add(op);
        }

        public synchronized void onWritePossible() throws IOException {
            this.asyncListenerCalled = true;
            this.flushQueue(HttpServletResponseWrapper.this.response.getOutputStream());
        }

        public synchronized void onError(Throwable t) {
            this.asyncListenerCalled = true;
            if (this.lastAsyncOperation != null) {
                this.lastAsyncOperation.future.completeExceptionally(t);
                this.lastAsyncOperation = null;
            }
            while (!this.asyncQueue.isEmpty()) {
                AsyncOperation op = this.asyncQueue.poll();
                if (op.future.isDone()) continue;
                op.future.completeExceptionally(t);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.server.servlet.HttpServletResponseWrapper$DeferredOutputStream", DeferredOutputStream.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    public class FlushOperation
    extends AsyncOperation {
        static final long serialVersionUID = 3258732752147180921L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public FlushOperation(OutputStream os) {
            super(os);
        }

        @Override
        protected void doWork(ServletOutputStream sos) {
            try {
                this.stream.flush();
                if (sos == null || sos.isReady()) {
                    this.future.complete(null);
                }
            }
            catch (IOException e) {
                this.future.completeExceptionally(e);
            }
        }

        public String toString() {
            return "[flush]";
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.server.servlet.HttpServletResponseWrapper$FlushOperation", FlushOperation.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    public class WriteOperation
    extends AsyncOperation {
        private byte[] bytes;
        private int offset;
        private int length;
        static final long serialVersionUID = 8689833088515783582L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public WriteOperation(OutputStream stream, byte[] bytes, int offset, int length) {
            super(stream);
            this.bytes = bytes;
            this.offset = offset;
            this.length = length;
        }

        @Override
        protected void doWork(ServletOutputStream sos) {
            try {
                this.stream.write(this.bytes, this.offset, this.length);
                if (sos == null || sos.isReady()) {
                    this.future.complete(null);
                }
            }
            catch (IOException e) {
                this.future.completeExceptionally(e);
            }
        }

        public String toString() {
            return "[write: " + new String(this.bytes) + "]";
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.server.servlet.HttpServletResponseWrapper$WriteOperation", WriteOperation.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    public abstract class AsyncOperation {
        CompletableFuture<Void> future = new CompletableFuture();
        OutputStream stream;
        static final long serialVersionUID = 2889374796947192596L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public AsyncOperation(OutputStream stream) {
            this.stream = stream;
        }

        public void work(ServletOutputStream sos) {
            try (ResteasyContext.CloseableContext c = ResteasyContext.addCloseableContextDataLevel(HttpServletResponseWrapper.this.contextDataMap);){
                this.doWork(sos);
            }
        }

        protected abstract void doWork(ServletOutputStream var1);

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.server.servlet.HttpServletResponseWrapper$AsyncOperation", AsyncOperation.class, null, null);
        }
    }
}

