/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsonsupport.internal;

import com.ibm.websphere.jsonsupport.JSON;
import com.ibm.websphere.jsonsupport.JSONMarshallException;
import com.ibm.websphere.jsonsupport.JSONSettings;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class JSONJacksonImpl
implements JSON {
    private final ObjectMapper mapper = new ObjectMapper();

    public JSONJacksonImpl() {
        this(null);
    }

    public JSONJacksonImpl(JSONSettings settings) {
        if (settings == null) {
            return;
        }
        JSONSettings.Include inclusion = settings.getInclusion();
        if (inclusion == JSONSettings.Include.ALWAYS) {
            this.mapper.getSerializationConfig().setSerializationInclusion(JsonSerialize.Inclusion.ALWAYS);
        } else if (inclusion == JSONSettings.Include.NON_NULL) {
            this.mapper.getSerializationConfig().setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        }
    }

    @Override
    public String stringify(Object o) throws JSONMarshallException {
        try {
            return this.mapper.writeValueAsString(o);
        }
        catch (JsonMappingException e) {
            throw new JSONMarshallException("Unable to parse non-well-formed content", e);
        }
        catch (JsonGenerationException e) {
            throw new JSONMarshallException("Error during JSON writing", e);
        }
        catch (IOException e) {
            throw new JSONMarshallException("I/O exception of some sort has occurred", e);
        }
    }

    @Override
    public byte[] asBytes(Object o) throws JSONMarshallException {
        try {
            return this.stringify(o).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new JSONMarshallException("Encountered a JVM without UTF-8 support, this should never happen", e);
        }
    }

    @Override
    public <T> T parse(String in, Class<? extends T> type) throws JSONMarshallException {
        try {
            return this.mapper.readValue(in, type);
        }
        catch (JsonParseException e) {
            throw new JSONMarshallException("Unable to parse non-well-formed content", e);
        }
        catch (JsonMappingException e) {
            throw new JSONMarshallException("Fatal problems occurred while mapping content", e);
        }
        catch (IOException e) {
            throw new JSONMarshallException("I/O exception of some sort has occurred", e);
        }
    }

    @Override
    public <T> T parse(byte[] in, Class<? extends T> type) throws JSONMarshallException {
        try {
            return this.mapper.readValue(in, 0, in.length, type);
        }
        catch (JsonParseException e) {
            throw new JSONMarshallException("Unable to parse non-well-formed content", e);
        }
        catch (JsonMappingException e) {
            throw new JSONMarshallException("Fatal problems occurred while mapping content", e);
        }
        catch (IOException e) {
            throw new JSONMarshallException("I/O exception of some sort has occurred", e);
        }
    }

    @Override
    @FFDCIgnore(value={FileNotFoundException.class})
    public <T> T parse(File in, Class<? extends T> type) throws IOException, JSONMarshallException {
        try {
            return this.mapper.readValue(in, type);
        }
        catch (JsonParseException e) {
            throw new JSONMarshallException("Unable to parse non-well-formed content", e);
        }
        catch (JsonMappingException e) {
            throw new JSONMarshallException("Fatal problems occurred while mapping content", e);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw new JSONMarshallException("I/O exception of some sort has occurred", e);
        }
    }

    @Override
    public void serializeToFile(File out, Object pojo) throws JSONMarshallException {
        try {
            this.mapper.writeValue(out, pojo);
        }
        catch (JsonMappingException e) {
            throw new JSONMarshallException("Unable to parse non-well-formed content", e);
        }
        catch (JsonGenerationException e) {
            throw new JSONMarshallException("Error during JSON writing", e);
        }
        catch (IOException e) {
            throw new JSONMarshallException("I/O exception of some sort has occurred", e);
        }
    }

    @Override
    public void serializeToWriter(Writer out, Object pojo) throws JSONMarshallException {
        try {
            this.mapper.writeValue(out, pojo);
        }
        catch (JsonMappingException e) {
            throw new JSONMarshallException("Unable to parse non-well-formed content", e);
        }
        catch (JsonGenerationException e) {
            throw new JSONMarshallException("Error during JSON writing", e);
        }
        catch (IOException e) {
            throw new JSONMarshallException("I/O exception of some sort has occurred", e);
        }
    }
}

