/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwt.config;

import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jwt.config.JwtConfig;
import com.ibm.ws.security.jwt.utils.JwtUtils;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={JwtConfigUtil.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, name="jwtConfigUtil", property={"service.vendor=IBM"})
public class JwtConfigUtil {
    private static final String KEY_JWT_SERVICE = "jwtComponent";
    private static ConcurrentServiceReferenceMap<String, JwtConfig> jwtServiceRef;
    static final long serialVersionUID = 2736372316184204506L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static synchronized void setJwtService(ConcurrentServiceReferenceMap<String, JwtConfig> jwtServiceRefMap) {
        jwtServiceRef = jwtServiceRefMap;
    }

    public static synchronized ConcurrentServiceReferenceMap<String, JwtConfig> getJwtService() {
        return jwtServiceRef;
    }

    @Sensitive
    public static String processProtectedString(Map<String, Object> props, String cfgKey) {
        Object o = props.get(cfgKey);
        String secret = o != null ? (o instanceof SerializableProtectedString ? new String(((SerializableProtectedString)o).getChars()) : (String)o) : null;
        secret = PasswordUtil.passwordDecode(secret);
        return secret;
    }

    public static String getSignatureAlgorithm(String configId, Map<String, Object> props, String sigAlgAttrName) {
        String defaultSignatureAlgorithm = "RS256";
        String signatureAlgorithm = JwtUtils.trimIt((String)props.get(sigAlgAttrName));
        if (signatureAlgorithm == null) {
            signatureAlgorithm = defaultSignatureAlgorithm;
        }
        return signatureAlgorithm;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.jwt.config.JwtConfigUtil", JwtConfigUtil.class, null, null);
        jwtServiceRef = new ConcurrentServiceReferenceMap(KEY_JWT_SERVICE);
    }
}

