/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwt.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.jwt.Claims;
import com.ibm.websphere.security.jwt.JwtException;
import com.ibm.websphere.security.jwt.JwtToken;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jwt.config.JwtConfig;
import com.ibm.ws.security.jwt.internal.BuilderImpl;
import com.ibm.ws.security.jwt.utils.JwtCreator;
import com.ibm.ws.security.jwt.utils.JwtData;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TokenImpl
implements JwtToken {
    Claims claims;
    Map<String, Object> header;
    String compact;
    static final long serialVersionUID = 2169149513440985995L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - void declaration
     */
    public TokenImpl(BuilderImpl jwtBuilder, JwtConfig config) throws JwtException {
        try {
            this.createToken(jwtBuilder, config);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.jwt.internal.TokenImpl", (String)"32", (Object)this, (Object[])new Object[]{jwtBuilder, config});
            throw new JwtException(e.getMessage(), (Throwable)e);
        }
    }

    private void createToken(BuilderImpl jwtBuilder, JwtConfig config) throws Exception {
        JwtData jwtData = new JwtData(jwtBuilder, config, "Json Web Token");
        JwtCreator.JwtResult result = JwtCreator.createJwt(jwtData, jwtBuilder.getClaims());
        this.compact = result.getCompact();
        this.header = result.getHeader();
        this.claims = result.getClaims();
    }

    @Override
    public Claims getClaims() {
        return this.claims;
    }

    @Override
    public String getHeader(String name) {
        String value = null;
        if (this.header != null && this.header.get(name) != null) {
            value = (String)this.header.get(name);
        }
        return value;
    }

    @Override
    public String compact() {
        return this.compact;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.jwt.internal.TokenImpl", TokenImpl.class, (String)"JWTBUILDER", (String)"com.ibm.ws.security.jwt.internal.resources.JWTMessages");
    }
}

