/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.classsource.specification.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Factory;
import com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_MappedJar;
import com.ibm.ws.annocache.classsource.specification.ClassSource_Specification_Direct;
import com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification;
import com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.annocache.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.annocache.classsource.ClassSource_Exception;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class ClassSourceImpl_Specification_Direct
extends ClassSourceImpl_Specification
implements ClassSource_Specification_Direct {
    public static final String CLASS_NAME;
    protected String modulePath;
    protected String appLibRootPath;
    protected List<String> appLibPaths;
    protected List<String> manifestPaths;
    static final long serialVersionUID = 7543493998235795955L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected ClassSourceImpl_Specification_Direct(ClassSourceImpl_Factory factory, String appName, String modName, String modCatName) {
        super(factory, appName, modName, modCatName);
    }

    @Override
    public String getModulePath() {
        return this.modulePath;
    }

    @Override
    public void setModulePath(String modulePath) {
        this.modulePath = modulePath;
    }

    @Override
    public String getAppLibRootPath() {
        return this.appLibRootPath;
    }

    @Override
    public void setAppLibRootPath(String appLibRootPath) {
        this.appLibRootPath = appLibRootPath;
        this.appLibPaths = new ArrayList<String>();
        this.selectJars(this.appLibRootPath, this.appLibPaths);
    }

    @Override
    public List<String> getAppLibPaths() {
        return this.appLibPaths;
    }

    @Override
    public void addAppLibPath(String appLibPath) {
        if (this.appLibPaths == null) {
            this.appLibPaths = new ArrayList<String>();
        }
        this.appLibPaths.add(appLibPath);
    }

    @Override
    public void addAppLibPaths(List<String> appLibPaths) {
        if (this.appLibPaths == null) {
            this.appLibPaths = new ArrayList<String>();
        }
        this.appLibPaths.addAll(appLibPaths);
    }

    @Override
    public List<String> getManifestPaths() {
        return this.manifestPaths;
    }

    @Override
    public void addManifestPath(String manifestPath) {
        if (this.manifestPaths == null) {
            this.manifestPaths = new ArrayList<String>();
        }
        this.manifestPaths.add(manifestPath);
    }

    @Override
    public void addManifestPaths(List<String> manifestPaths) {
        if (this.manifestPaths == null) {
            this.manifestPaths = new ArrayList<String>();
        }
        this.manifestPaths.addAll(manifestPaths);
    }

    @Override
    public abstract void addInternalClassSources(ClassSource_Aggregate var1) throws ClassSource_Exception;

    @Override
    public void addExternalClassSources(ClassSource_Aggregate rootClassSource) throws ClassSource_Exception {
        List<String> useManifestPaths;
        List<String> useAppLibPaths = this.getAppLibPaths();
        if (useAppLibPaths != null) {
            for (String nextAppLibPath : useAppLibPaths) {
                ClassSourceImpl_MappedJar classSourceImpl_MappedJar = this.addJarClassSource(rootClassSource, nextAppLibPath, nextAppLibPath, ClassSource_Aggregate.ScanPolicy.EXTERNAL);
            }
        }
        if ((useManifestPaths = this.getManifestPaths()) != null) {
            for (String nextManifestPath : useManifestPaths) {
                ClassSourceImpl_MappedJar classSourceImpl_MappedJar = this.addJarClassSource(rootClassSource, nextManifestPath, nextManifestPath, ClassSource_Aggregate.ScanPolicy.EXTERNAL);
            }
        }
    }

    public void selectJars(String targetPath, List<String> jarPaths) {
        if (targetPath == null) {
            return;
        }
        if (!targetPath.endsWith("/")) {
            throw new IllegalArgumentException("Path [ " + targetPath + " ] must have a trailing '/'.");
        }
        File targetDir = new File(targetPath);
        if (!UtilImpl_FileUtils.exists(targetDir)) {
            return;
        }
        File[] targetFiles = UtilImpl_FileUtils.listFiles(targetDir);
        if (targetFiles != null) {
            for (File nextTargetFile : targetFiles) {
                String nextTargetName = nextTargetFile.getName();
                if (!nextTargetName.toUpperCase().endsWith(".JAR")) continue;
                String nextTargetPath = targetPath + nextTargetName;
                jarPaths.add(nextTargetPath);
            }
        }
    }

    @Override
    @Trivial
    public void logInternal(Logger useLogger) {
        String methodName = "logInternal";
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  Module Internals:");
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "    Module path [ " + this.getModulePath() + " ]");
    }

    @Override
    @Trivial
    public void logExternal(Logger useLogger) {
        List<String> useManifestJarPaths;
        String methodName = "logExternal";
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  Module Externals:");
        String useAppLibPath = this.getAppLibRootPath();
        if (useAppLibPath == null) {
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "    Application library path [ Null ]");
        } else {
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "    Application library path [ " + useAppLibPath + " ]");
        }
        List<String> useLibraryJarPaths = this.getAppLibPaths();
        if (useLibraryJarPaths != null) {
            for (String nextJarPath : useLibraryJarPaths) {
                useLogger.logp(Level.FINER, CLASS_NAME, methodName, "    Application library jar [ " + nextJarPath + " ]");
            }
        }
        if ((useManifestJarPaths = this.getManifestPaths()) != null) {
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "    Manifest jars");
            for (String nextJarPath : useManifestJarPaths) {
                useLogger.logp(Level.FINER, CLASS_NAME, methodName, "      Manifest jar [ " + nextJarPath + " ]");
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification_Direct", ClassSourceImpl_Specification_Direct.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        CLASS_NAME = ClassSourceImpl_Specification_Direct.class.getSimpleName();
    }
}

