/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.targets.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.annocache.jandex.internal.SparseClassInfo;
import com.ibm.ws.annocache.jandex.internal.SparseIndex;
import com.ibm.ws.annocache.service.internal.AnnotationCacheServiceImpl_Logging;
import com.ibm.ws.annocache.targets.TargetsTable;
import com.ibm.ws.annocache.targets.internal.AnnotationTargetsImpl_Factory;
import com.ibm.ws.annocache.targets.internal.TargetsTableAnnotationsImpl;
import com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl;
import com.ibm.ws.annocache.targets.internal.TargetsTableTimeStampImpl;
import com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl;
import com.ibm.ws.annocache.targets.internal.TargetsVisitorJandexConverterImpl;
import com.ibm.ws.annocache.targets.internal.TargetsVisitorSparseJandexConverterImpl;
import com.ibm.ws.annocache.util.internal.UtilImpl_BidirectionalMap;
import com.ibm.ws.annocache.util.internal.UtilImpl_IdentityStringSet;
import com.ibm.ws.annocache.util.internal.UtilImpl_InternMap;
import com.ibm.ws.annocache.util.internal.UtilImpl_NonInternSet;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.anno.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.annocache.classsource.ClassSource;
import com.ibm.wsspi.annocache.classsource.ClassSource_Exception;
import com.ibm.wsspi.annocache.classsource.ClassSource_Streamer;
import com.ibm.wsspi.annocache.targets.AnnotationTargets_Exception;
import com.ibm.wsspi.annocache.targets.AnnotationTargets_Targets;
import com.ibm.wsspi.annocache.util.Util_BidirectionalMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.Index;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class TargetsTableImpl
implements TargetsTable {
    protected static final Logger logger = AnnotationCacheServiceImpl_Logging.ANNO_LOGGER;
    protected static final Logger stateLogger = AnnotationCacheServiceImpl_Logging.ANNO_STATE_LOGGER;
    public static final String CLASS_NAME = TargetsTableImpl.class.getSimpleName();
    protected final String hashText;
    public static final boolean DO_USE_JANDEX_FORMAT = true;
    public static final boolean DO_NOT_USE_JANDEX_FORMAT = false;
    protected final AnnotationTargetsImpl_Factory factory;
    protected final UtilImpl_InternMap classNameInternMap;
    protected final UtilImpl_InternMap fieldNameInternMap;
    protected final UtilImpl_InternMap methodSignatureInternMap;
    protected final String classSourceName;
    protected boolean usedJandex;
    protected final TargetsTableTimeStampImpl stampTable;
    protected final TargetsTableClassesImpl classTable;
    protected final TargetsTableAnnotationsImpl annotationTable;
    private final boolean useJandexFormat;
    private Index jandexIndex;
    static final long serialVersionUID = -1414306235419507683L;

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getHashText() {
        return this.hashText;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetsTableImpl(TargetsTableImpl sourceData, UtilImpl_InternMap classNameInternMap, UtilImpl_InternMap fieldNameInternMap, UtilImpl_InternMap methodSignatureInternMap) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "<init>", new Object[]{sourceData, classNameInternMap, fieldNameInternMap, methodSignatureInternMap});
        }
        String methodName = "<init>";
        this.hashText = this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
        this.factory = sourceData.getFactory();
        this.classNameInternMap = classNameInternMap;
        this.fieldNameInternMap = fieldNameInternMap;
        this.methodSignatureInternMap = methodSignatureInternMap;
        this.classSourceName = sourceData.getClassSourceName();
        this.usedJandex = sourceData.getUsedJandex();
        this.useJandexFormat = sourceData.getUseJandexFormat();
        this.jandexIndex = sourceData.getJandexIndex();
        this.stampTable = new TargetsTableTimeStampImpl(this.classSourceName, sourceData.getStamp());
        this.classTable = new TargetsTableClassesImpl(sourceData.getClassTable(), classNameInternMap, this.classSourceName);
        this.annotationTable = new TargetsTableAnnotationsImpl(sourceData.getAnnotationTable(), classNameInternMap);
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] [ {1} ]", new Object[]{this.hashText, this.classSourceName});
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] from [ {1} ]", new Object[]{this.hashText, sourceData.getHashText()});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetsTableImpl(AnnotationTargetsImpl_Factory factory, String classSourceName, boolean useJandexFormat) {
        this(factory, factory.createClassNameInternMap(), factory.createFieldNameInternMap(), factory.createMethodSignatureInternMap(), classSourceName, useJandexFormat);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "<init>", new Object[]{factory, classSourceName, useJandexFormat});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetsTableImpl(AnnotationTargetsImpl_Factory factory, UtilImpl_InternMap classNameInternMap, UtilImpl_InternMap fieldNameInternMap, UtilImpl_InternMap methodSignatureInternMap, String classSourceName, boolean useJandexFormat) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "<init>", new Object[]{factory, classNameInternMap, fieldNameInternMap, methodSignatureInternMap, classSourceName, useJandexFormat});
        }
        String methodName = "<init>";
        this.hashText = this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
        this.factory = factory;
        this.classNameInternMap = classNameInternMap;
        this.fieldNameInternMap = fieldNameInternMap;
        this.methodSignatureInternMap = methodSignatureInternMap;
        this.classSourceName = classSourceName;
        this.usedJandex = false;
        this.useJandexFormat = useJandexFormat;
        this.jandexIndex = null;
        this.stampTable = new TargetsTableTimeStampImpl(classSourceName);
        this.classTable = new TargetsTableClassesImpl(factory.getUtilFactory(), classNameInternMap, classSourceName);
        this.annotationTable = new TargetsTableAnnotationsImpl(factory.getUtilFactory(), classNameInternMap);
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] [ {1} ]", new Object[]{this.hashText, this.classSourceName});
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] [ {1} ]", new Object[]{this.hashText, this.stampTable.getHashText()});
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] [ {1} ]", new Object[]{this.hashText, this.classTable.getHashText()});
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] [ {1} ]", new Object[]{this.hashText, this.annotationTable.getHashText()});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "<init>", this);
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected AnnotationTargetsImpl_Factory getFactory() {
        return this.factory;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Set<String> createIdentityStringSet() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "createIdentityStringSet", new Object[0]);
        }
        UtilImpl_IdentityStringSet utilImpl_IdentityStringSet = this.getFactory().getUtilFactory().createIdentityStringSet();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            utilImpl_IdentityStringSet = utilImpl_IdentityStringSet;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "createIdentityStringSet", utilImpl_IdentityStringSet);
        }
        return utilImpl_IdentityStringSet;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Set<String> createIdentityStringSet(int size) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "createIdentityStringSet", new Object[]{size});
        }
        Set<String> set = this.getFactory().getUtilFactory().createIdentityStringSet(size);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "createIdentityStringSet", set);
        }
        return set;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Set<String> i_dupClassNames(Set<String> initialElements) {
        return this.getFactory().getUtilFactory().createIdentityStringSet(initialElements);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected UtilImpl_InternMap getClassNameInternMap() {
        return this.classNameInternMap;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Set<String> uninternClassNames(Set<String> i_classNames) {
        if (i_classNames == null) {
            return null;
        }
        if (i_classNames.isEmpty()) {
            return Collections.emptySet();
        }
        return new UtilImpl_NonInternSet(this.getClassNameInternMap(), i_classNames);
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String internClassName(String className) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "internClassName", new Object[]{className});
        }
        String string = this.getClassNameInternMap().intern(className);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "internClassName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String internClassName(String className, boolean doForce) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "internClassName", new Object[]{className, doForce});
        }
        String string = this.getClassNameInternMap().intern(className, doForce);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "internClassName", string);
        }
        return string;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected UtilImpl_InternMap getFieldNameInternMap() {
        return this.fieldNameInternMap;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Set<String> uninternFieldNames(Set<String> i_fieldNames) {
        if (i_fieldNames == null) {
            return null;
        }
        if (i_fieldNames.isEmpty()) {
            return Collections.emptySet();
        }
        return new UtilImpl_NonInternSet(this.getFieldNameInternMap(), i_fieldNames);
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String internFieldName(String fieldName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "internFieldName", new Object[]{fieldName});
        }
        String string = this.getFieldNameInternMap().intern(fieldName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "internFieldName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String internFieldName(String fieldName, boolean doForce) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "internFieldName", new Object[]{fieldName, doForce});
        }
        String string = this.getFieldNameInternMap().intern(fieldName, doForce);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "internFieldName", string);
        }
        return string;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected UtilImpl_InternMap getMethodSignatureInternMap() {
        return this.methodSignatureInternMap;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String internMethodSignature(String methodSignature) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "internMethodSignature", new Object[]{methodSignature});
        }
        String string = this.getMethodSignatureInternMap().intern(methodSignature);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "internMethodSignature", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String internMethodSignature(String methodSignature, boolean doForce) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "internMethodSignature", new Object[]{methodSignature, doForce});
        }
        String string = this.getMethodSignatureInternMap().intern(methodSignature, doForce);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "internMethodSignature", string);
        }
        return string;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getClassSourceName() {
        return this.classSourceName;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean getUsedJandex() {
        return this.usedJandex;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void setUsedJandex(boolean usedJandex) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "setUsedJandex", new Object[]{usedJandex});
        }
        this.usedJandex = usedJandex;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "setUsedJandex");
        }
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetsTableTimeStampImpl getStampTable() {
        return this.stampTable;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String setName(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "setName", new Object[]{name});
        }
        String string = this.getStampTable().setName(name);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "setName", string);
        }
        return string;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getName() {
        return this.getStampTable().getName();
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String setStamp(String stamp) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "setStamp", new Object[]{stamp});
        }
        String string = this.getStampTable().setStamp(stamp);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "setStamp", string);
        }
        return string;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getStamp() {
        return this.getStampTable().getStamp();
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetsTableClassesImpl getClassTable() {
        return this.classTable;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getPackageNames() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "getPackageNames", new Object[0]);
        }
        Set<String> set = this.getClassTable().getPackageNames();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "getPackageNames", set);
        }
        return set;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> i_getPackageNames() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_getPackageNames", new Object[0]);
        }
        Set<String> set = this.getClassTable().i_getPackageNames();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_getPackageNames", set);
        }
        return set;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean containsPackageName(String packageName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "containsPackageName", new Object[]{packageName});
        }
        boolean bl = this.getClassTable().containsPackageName(packageName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "containsPackageName", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean i_containsPackageName(String i_packageName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_containsPackageName", new Object[]{i_packageName});
        }
        boolean bl = this.getClassTable().i_containsPackageName(i_packageName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_containsPackageName", bl);
        }
        return bl;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getClassNames() {
        return this.getClassTable().getClassNames();
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> i_getClassNames() {
        return this.getClassTable().i_getClassNames();
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean containsClassName(String className) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "containsClassName", new Object[]{className});
        }
        boolean bl = this.getClassTable().containsClassName(className);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "containsClassName", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean i_containsClassName(String i_className) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_containsClassName", new Object[]{i_className});
        }
        boolean bl = this.getClassTable().i_containsClassName(i_className);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_containsClassName", bl);
        }
        return bl;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Map<String, String> i_getSuperclassNameMap() {
        return this.getClassTable().i_getSuperclassNames();
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getSuperclassName(String subclassName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "getSuperclassName", new Object[]{subclassName});
        }
        String string = this.getClassTable().getSuperclassName(subclassName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "getSuperclassName", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String i_getSuperclassName(String i_subclassName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_getSuperclassName", new Object[]{i_subclassName});
        }
        String string = this.getClassTable().i_getSuperclassName(i_subclassName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_getSuperclassName", string);
        }
        return string;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Map<String, String[]> i_getInterfaceNamesMap() {
        return this.getClassTable().i_getInterfaceNames();
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String[] getInterfaceNames(String classOrInterfaceName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "getInterfaceNames", new Object[]{classOrInterfaceName});
        }
        String[] stringArray = this.getClassTable().getInterfaceNames(classOrInterfaceName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            stringArray = stringArray;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "getInterfaceNames", stringArray);
        }
        return stringArray;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String[] i_getInterfaceNames(String i_classOrInterfaceName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_getInterfaceNames", new Object[]{i_classOrInterfaceName});
        }
        String[] stringArray = this.getClassTable().i_getInterfaceNames(i_classOrInterfaceName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            stringArray = stringArray;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_getInterfaceNames", stringArray);
        }
        return stringArray;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetsTableAnnotationsImpl getAnnotationTable() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "getAnnotationTable", new Object[0]);
        }
        TargetsTableAnnotationsImpl targetsTableAnnotationsImpl = this.annotationTable;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            targetsTableAnnotationsImpl = targetsTableAnnotationsImpl;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "getAnnotationTable", targetsTableAnnotationsImpl);
        }
        return targetsTableAnnotationsImpl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public UtilImpl_BidirectionalMap i_getAnnotations(AnnotationTargets_Targets.AnnotationCategory category) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_getAnnotations", new Object[]{category});
        }
        UtilImpl_BidirectionalMap utilImpl_BidirectionalMap = this.getAnnotationTable().i_getAnnotations(category);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            utilImpl_BidirectionalMap = utilImpl_BidirectionalMap;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_getAnnotations", utilImpl_BidirectionalMap);
        }
        return utilImpl_BidirectionalMap;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Util_BidirectionalMap i_getPackageAnnotations() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_getPackageAnnotations", new Object[0]);
        }
        UtilImpl_BidirectionalMap utilImpl_BidirectionalMap = this.getAnnotationTable().i_getPackageAnnotations();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            utilImpl_BidirectionalMap = utilImpl_BidirectionalMap;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_getPackageAnnotations", utilImpl_BidirectionalMap);
        }
        return utilImpl_BidirectionalMap;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Util_BidirectionalMap i_getClassAnnotations() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_getClassAnnotations", new Object[0]);
        }
        UtilImpl_BidirectionalMap utilImpl_BidirectionalMap = this.getAnnotationTable().i_getClassAnnotations();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            utilImpl_BidirectionalMap = utilImpl_BidirectionalMap;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_getClassAnnotations", utilImpl_BidirectionalMap);
        }
        return utilImpl_BidirectionalMap;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Util_BidirectionalMap i_getFieldAnnotations() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_getFieldAnnotations", new Object[0]);
        }
        UtilImpl_BidirectionalMap utilImpl_BidirectionalMap = this.getAnnotationTable().i_getFieldAnnotations();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            utilImpl_BidirectionalMap = utilImpl_BidirectionalMap;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_getFieldAnnotations", utilImpl_BidirectionalMap);
        }
        return utilImpl_BidirectionalMap;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Util_BidirectionalMap i_getMethodAnnotations() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_getMethodAnnotations", new Object[0]);
        }
        UtilImpl_BidirectionalMap utilImpl_BidirectionalMap = this.getAnnotationTable().i_getMethodAnnotations();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            utilImpl_BidirectionalMap = utilImpl_BidirectionalMap;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_getMethodAnnotations", utilImpl_BidirectionalMap);
        }
        return utilImpl_BidirectionalMap;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> i_getAnnotatedTargets(AnnotationTargets_Targets.AnnotationCategory category) {
        return this.getAnnotationTable().i_getAnnotatedTargets(category);
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> i_getAnnotatedTargets(AnnotationTargets_Targets.AnnotationCategory category, String i_annotationName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_getAnnotatedTargets", new Object[]{category, i_annotationName});
        }
        Set<String> set = this.getAnnotationTable().i_getAnnotatedTargets(category, i_annotationName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_getAnnotatedTargets", set);
        }
        return set;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> i_getAnnotationNames(AnnotationTargets_Targets.AnnotationCategory category) {
        return this.getAnnotationTable().i_getAnnotationNames(category);
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> i_getAnnotations(AnnotationTargets_Targets.AnnotationCategory category, String i_classOrPackageName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_getAnnotations", new Object[]{category, i_classOrPackageName});
        }
        Set<String> set = this.getAnnotationTable().i_getAnnotations(category, i_classOrPackageName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_getAnnotations", set);
        }
        return set;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getAnnotatedTargets(AnnotationTargets_Targets.AnnotationCategory category) {
        return this.getAnnotationTable().getAnnotatedTargets(category);
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getAnnotatedTargets(AnnotationTargets_Targets.AnnotationCategory category, String annotationName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "getAnnotatedTargets", new Object[]{category, annotationName});
        }
        Set<String> set = this.getAnnotationTable().getAnnotatedTargets(category, annotationName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "getAnnotatedTargets", set);
        }
        return set;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getAnnotations(AnnotationTargets_Targets.AnnotationCategory category) {
        return this.getAnnotationTable().getAnnotations(category);
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getAnnotations(AnnotationTargets_Targets.AnnotationCategory category, String classOrPackageName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "getAnnotations", new Object[]{category, classOrPackageName});
        }
        Set<String> set = this.getAnnotationTable().getAnnotations(category, classOrPackageName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "getAnnotations", set);
        }
        return set;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getPackagesWithAnnotations() {
        return this.getAnnotationTable().getPackagesWithAnnotations();
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> i_getPackagesWithAnnotations() {
        return this.getAnnotationTable().i_getPackagesWithAnnotations();
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getPackagesWithAnnotation(String annotationName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "getPackagesWithAnnotation", new Object[]{annotationName});
        }
        Set<String> set = this.getAnnotationTable().getPackagesWithAnnotation(annotationName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "getPackagesWithAnnotation", set);
        }
        return set;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> i_getPackagesWithAnnotation(String i_annotationName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_getPackagesWithAnnotation", new Object[]{i_annotationName});
        }
        Set<String> set = this.getAnnotationTable().i_getPackagesWithAnnotation(i_annotationName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_getPackagesWithAnnotation", set);
        }
        return set;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getPackageAnnotations() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "getPackageAnnotations", new Object[0]);
        }
        Set<String> set = this.getAnnotationTable().getPackageAnnotations();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "getPackageAnnotations", set);
        }
        return set;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> i_getPackageAnnotationNames() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_getPackageAnnotationNames", new Object[0]);
        }
        Set<String> set = this.getAnnotationTable().i_getPackageAnnotationNames();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_getPackageAnnotationNames", set);
        }
        return set;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getPackageAnnotations(String packageName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "getPackageAnnotations", new Object[]{packageName});
        }
        Set<String> set = this.getAnnotationTable().getPackageAnnotations(packageName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "getPackageAnnotations", set);
        }
        return set;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> i_getPackageAnnotations(String i_packageName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_getPackageAnnotations", new Object[]{i_packageName});
        }
        Set<String> set = this.getAnnotationTable().i_getPackageAnnotations(i_packageName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_getPackageAnnotations", set);
        }
        return set;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getClassesWithClassAnnotations() {
        return this.getAnnotationTable().getClassesWithClassAnnotations();
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> i_getClassesWithClassAnnotations() {
        return this.getAnnotationTable().i_getClassesWithClassAnnotations();
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getClassesWithClassAnnotation(String annotationName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "getClassesWithClassAnnotation", new Object[]{annotationName});
        }
        Set<String> set = this.getAnnotationTable().getClassesWithClassAnnotation(annotationName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "getClassesWithClassAnnotation", set);
        }
        return set;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> i_getClassesWithClassAnnotation(String i_annotationName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_getClassesWithClassAnnotation", new Object[]{i_annotationName});
        }
        Set<String> set = this.getAnnotationTable().i_getClassesWithClassAnnotation(i_annotationName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_getClassesWithClassAnnotation", set);
        }
        return set;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getClassAnnotations() {
        return this.getAnnotationTable().getClassAnnotations();
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> i_getClassAnnotationNames() {
        return this.getAnnotationTable().i_getClassAnnotationNames();
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getClassAnnotations(String className) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "getClassAnnotations", new Object[]{className});
        }
        Set<String> set = this.getAnnotationTable().getClassAnnotations(className);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "getClassAnnotations", set);
        }
        return set;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> i_getClassAnnotations(String i_className) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_getClassAnnotations", new Object[]{i_className});
        }
        Set<String> set = this.getAnnotationTable().i_getClassAnnotations(i_className);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_getClassAnnotations", set);
        }
        return set;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getClassesWithFieldAnnotations() {
        return this.getAnnotationTable().getClassesWithFieldAnnotations();
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> i_getClassesWithFieldAnnotations() {
        return this.getAnnotationTable().i_getClassesWithFieldAnnotations();
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getClassesWithFieldAnnotation(String annotationName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "getClassesWithFieldAnnotation", new Object[]{annotationName});
        }
        Set<String> set = this.getAnnotationTable().getClassesWithFieldAnnotation(annotationName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "getClassesWithFieldAnnotation", set);
        }
        return set;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> i_getClassesWithFieldAnnotation(String i_annotationName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_getClassesWithFieldAnnotation", new Object[]{i_annotationName});
        }
        Set<String> set = this.getAnnotationTable().i_getClassesWithFieldAnnotation(i_annotationName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_getClassesWithFieldAnnotation", set);
        }
        return set;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getFieldAnnotations() {
        return this.getAnnotationTable().getFieldAnnotations();
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> i_getFieldAnnotationNames() {
        return this.getAnnotationTable().i_getFieldAnnotationNames();
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getFieldAnnotations(String className) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "getFieldAnnotations", new Object[]{className});
        }
        Set<String> set = this.getAnnotationTable().getFieldAnnotations(className);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "getFieldAnnotations", set);
        }
        return set;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> i_getFieldAnnotations(String i_className) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_getFieldAnnotations", new Object[]{i_className});
        }
        Set<String> set = this.getAnnotationTable().i_getFieldAnnotations(i_className);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_getFieldAnnotations", set);
        }
        return set;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getClassesWithMethodAnnotations() {
        return this.getAnnotationTable().getClassesWithMethodAnnotations();
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> i_getClassesWithMethodAnnotations() {
        return this.getAnnotationTable().i_getClassesWithMethodAnnotations();
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getClassesWithMethodAnnotation(String annotationName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "getClassesWithMethodAnnotation", new Object[]{annotationName});
        }
        Set<String> set = this.getAnnotationTable().getClassesWithMethodAnnotation(annotationName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "getClassesWithMethodAnnotation", set);
        }
        return set;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> i_getClassesWithMethodAnnotation(String i_annotationName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_getClassesWithMethodAnnotation", new Object[]{i_annotationName});
        }
        Set<String> set = this.getAnnotationTable().i_getClassesWithMethodAnnotation(i_annotationName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_getClassesWithMethodAnnotation", set);
        }
        return set;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getMethodAnnotations() {
        return this.getAnnotationTable().getMethodAnnotations();
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> i_getMethodAnnotationNames() {
        return this.getAnnotationTable().i_getMethodAnnotationNames();
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getMethodAnnotations(String className) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "getMethodAnnotations", new Object[]{className});
        }
        Set<String> set = this.getAnnotationTable().getMethodAnnotations(className);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "getMethodAnnotations", set);
        }
        return set;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> i_getMethodAnnotations(String i_className) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_getMethodAnnotations", new Object[]{i_className});
        }
        Set<String> set = this.getAnnotationTable().i_getMethodAnnotations(i_className);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "i_getMethodAnnotations", set);
        }
        return set;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int countAnnotations() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "countAnnotations", new Object[0]);
        }
        int n = this.getPackageAnnotations().size() + this.getClassAnnotations().size() + this.getFieldAnnotations().size() + this.getMethodAnnotations().size();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "countAnnotations", n);
        }
        return n;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void logState() {
        if (stateLogger.isLoggable(Level.FINER)) {
            this.log(stateLogger);
        }
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void log(Logger useLogger) {
        String methodName = "log";
        if (!useLogger.isLoggable(Level.FINER)) {
            return;
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "BEGIN STATE [ {0} ]", this.getHashText());
        this.getClassTable().log(useLogger);
        this.getAnnotationTable().log(useLogger);
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "END STATE [ {0} ]", this.getHashText());
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void scanInternal(ClassSource classSource) throws AnnotationTargets_Exception {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "scanInternal", new Object[]{classSource});
        }
        this.scanInternal(classSource, TargetsVisitorClassImpl.DONT_RECORD_NEW_RESOLVED, TargetsVisitorClassImpl.DONT_RECORD_RESOLVED, TargetsVisitorClassImpl.DONT_RECORD_NEW_UNRESOLVED, TargetsVisitorClassImpl.DONT_RECORD_UNRESOLVED, TargetsVisitorClassImpl.SELECT_ALL_ANNOTATIONS);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "scanInternal");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void scanInternal(final ClassSource classSource, final Set<String> i_newResolvedClassNames, final Set<String> i_resolvedClassNames, final Set<String> i_newUnresolvedClassNames, final Set<String> i_unresolvedClassNames, final Set<String> i_selectAnnotationClassNames) throws AnnotationTargets_Exception {
        String methodName = "scanInternal";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER [ {1} ]", new Object[]{this.getHashText(), classSource});
        }
        try {
            this.openClassSource(classSource);
            ClassSource_Streamer useStreamer = new ClassSource_Streamer(){
                private final TargetsVisitorClassImpl visitor;
                private final TargetsVisitorJandexConverterImpl jandexConverter;
                private final TargetsVisitorSparseJandexConverterImpl sparseJandexConverter;
                static final long serialVersionUID = 5699583734914794195L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;
                {
                    this.visitor = new TargetsVisitorClassImpl(TargetsTableImpl.this, classSource.getCanonicalName(), i_newResolvedClassNames, i_resolvedClassNames, i_newUnresolvedClassNames, i_unresolvedClassNames, i_selectAnnotationClassNames, false);
                    this.jandexConverter = new TargetsVisitorJandexConverterImpl(TargetsTableImpl.this);
                    this.sparseJandexConverter = new TargetsVisitorSparseJandexConverterImpl(TargetsTableImpl.this);
                }

                @Override
                public boolean doProcess(String className) {
                    return true;
                }

                @Override
                public boolean process(String i_className, InputStream inputStream) throws ClassSource_Exception {
                    return TargetsTableImpl.this.apply(this.visitor, i_className, inputStream);
                }

                @Override
                public boolean supportsJandex() {
                    return true;
                }

                @Override
                public boolean createJandex() {
                    return TargetsTableImpl.this.getUseJandexFormat();
                }

                @Override
                public void storeJandex(Object useJandexIndex) {
                    TargetsTableImpl.this.setJandexIndex((Index)useJandexIndex);
                }

                @Override
                public void processJandex() {
                    TargetsTableImpl.this.setUsedJandex(true);
                }

                @Override
                public boolean processJandex(Object jandexClassInfo) throws ClassSource_Exception {
                    return this.jandexConverter.convertClassInfo(TargetsTableImpl.this.classSourceName, jandexClassInfo);
                }

                @Override
                public boolean processSparseJandex(Object jandexClassInfo) throws ClassSource_Exception {
                    return this.sparseJandexConverter.convertClassInfo(TargetsTableImpl.this.classSourceName, jandexClassInfo);
                }

                @Override
                public boolean doProcess(String className, ClassSource_Aggregate.ScanPolicy scanPolicy) {
                    return false;
                }

                @Override
                public boolean process(String sourceName, String className, InputStream inputStream, ClassSource_Aggregate.ScanPolicy scanPolicy) throws com.ibm.wsspi.anno.classsource.ClassSource_Exception {
                    return false;
                }

                @Override
                public boolean process(String sourceName, Object jandexClassInfo, ClassSource_Aggregate.ScanPolicy scanPolicy) throws com.ibm.wsspi.anno.classsource.ClassSource_Exception {
                    return false;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.internal.TargetsTableImpl$1", 1.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
                }
            };
            try {
                classSource.process(useStreamer);
            }
            catch (ClassSource_Exception classSource_Exception) {
                void e;
                FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.annocache.targets.internal.TargetsTableImpl", (String)"899", (Object)this, (Object[])new Object[]{classSource, i_newResolvedClassNames, i_resolvedClassNames, i_newUnresolvedClassNames, i_unresolvedClassNames, i_selectAnnotationClassNames});
                throw this.getFactory().wrapIntoAnnotationTargetsException(logger, CLASS_NAME, methodName, "Failed to scan class source", (Throwable)e);
            }
        }
        finally {
            this.closeClassSource(classSource);
        }
        this.logState();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] RETURN", this.getHashText());
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String printString(Set<String> values) {
        if (values.isEmpty()) {
            return "{ }";
        }
        if (values.size() == 1) {
            Iterator<String> iterator = values.iterator();
            if (iterator.hasNext()) {
                String value = iterator.next();
                return "{ " + value + " }";
            }
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("{ ");
        boolean first = true;
        for (String value : values) {
            if (!first) {
                builder.append(", ");
            } else {
                first = false;
            }
            builder.append(value);
        }
        builder.append(" }");
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void scanExternal(ClassSource classSource, Set<String> i_resolvedClassNames, Set<String> i_unresolvedClassNames) throws AnnotationTargets_Exception {
        String methodName = "scanExternal";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] [ {1} ] ENTER Resolved [ {2} ] Unresolved [ {3} ]", new Object[]{this.getHashText(), classSource.getCanonicalName(), i_resolvedClassNames.size(), i_unresolvedClassNames.size()});
        }
        if (i_unresolvedClassNames.isEmpty()) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] [ {1} ] RETURN Immedate; Empty Unresolved", new Object[]{this.getHashText(), classSource.getCanonicalName()});
            }
            return;
        }
        boolean didOpen = false;
        try {
            Set<String> i_nextUnresolvedClassNames = this.i_dupClassNames(i_unresolvedClassNames);
            while (!i_nextUnresolvedClassNames.isEmpty()) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] [ {1} ] Next Unresolved [ {2} ]", new Object[]{this.getHashText(), classSource.getName(), this.printString(i_nextUnresolvedClassNames)});
                Set<String> i_newResolvedClassNames = this.createIdentityStringSet();
                Set<String> i_newUnresolvedClassNames = this.createIdentityStringSet();
                if (!didOpen) {
                    this.openClassSource(classSource);
                    didOpen = true;
                }
                final Logger innerLogger = logger;
                final TargetsVisitorClassImpl visitor = new TargetsVisitorClassImpl(this, classSource.getName(), i_newResolvedClassNames, i_resolvedClassNames, i_newUnresolvedClassNames, i_unresolvedClassNames, TargetsVisitorClassImpl.SELECT_NO_ANNOTATIONS, false);
                ClassSource_Streamer useStreamer = new ClassSource_Streamer(){
                    static final long serialVersionUID = -7707594143191650018L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public boolean doProcess(String className) {
                        return true;
                    }

                    @Override
                    public boolean process(String i_className, InputStream inputStream) throws ClassSource_Exception {
                        String interMethodName = "scanExternal.process";
                        if (innerLogger.isLoggable(Level.FINER)) {
                            innerLogger.logp(Level.FINER, CLASS_NAME, interMethodName, "Class [ {0} ]", i_className);
                        }
                        return TargetsTableImpl.this.apply(visitor, i_className, inputStream);
                    }

                    @Override
                    public boolean supportsJandex() {
                        return false;
                    }

                    @Override
                    public boolean createJandex() {
                        return false;
                    }

                    @Override
                    public void storeJandex(Object useJandexIndex) {
                        throw new UnsupportedOperationException("External scans do not use Jandex");
                    }

                    @Override
                    public void processJandex() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean processJandex(Object jandexClassInfo) throws ClassSource_Exception {
                        throw new UnsupportedOperationException("External scans do not use Jandex");
                    }

                    @Override
                    public boolean processSparseJandex(Object jandexClassInfo) throws ClassSource_Exception {
                        throw new UnsupportedOperationException("External scans do not use Jandex");
                    }

                    @Override
                    public boolean doProcess(String className, ClassSource_Aggregate.ScanPolicy scanPolicy) {
                        return false;
                    }

                    @Override
                    public boolean process(String sourceName, String className, InputStream inputStream, ClassSource_Aggregate.ScanPolicy scanPolicy) throws com.ibm.wsspi.anno.classsource.ClassSource_Exception {
                        return false;
                    }

                    @Override
                    public boolean process(String sourceName, Object jandexClassInfo, ClassSource_Aggregate.ScanPolicy scanPolicy) throws com.ibm.wsspi.anno.classsource.ClassSource_Exception {
                        return false;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.internal.TargetsTableImpl$2", 2.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
                    }
                };
                try {
                    classSource.processSpecific(useStreamer, i_nextUnresolvedClassNames);
                }
                catch (ClassSource_Exception classSource_Exception) {
                    void e;
                    FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.annocache.targets.internal.TargetsTableImpl", (String)"1076", (Object)this, (Object[])new Object[]{classSource, i_resolvedClassNames, i_unresolvedClassNames});
                    throw this.getFactory().wrapIntoAnnotationTargetsException(logger, CLASS_NAME, methodName, "Failed to scan class source", (Throwable)e);
                }
                i_nextUnresolvedClassNames.clear();
                i_nextUnresolvedClassNames.addAll(i_newUnresolvedClassNames);
            }
        }
        finally {
            if (didOpen) {
                this.closeClassSource(classSource);
            }
        }
        this.logState();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] [ {1} ] RETURN Resolved [ {2} ] Unresolved [ {3} ]", new Object[]{this.getHashText(), classSource.getName(), i_resolvedClassNames.size(), i_unresolvedClassNames.size()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void scanSpecific(ClassSource classSource, Set<String> i_unresolvedClassNames, Set<String> i_resolvedClassNames, Set<String> i_specificAnnotationClassNames) throws AnnotationTargets_Exception {
        String methodName = "scanSpecific";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER [ {1} ]", new Object[]{this.getHashText(), classSource});
        }
        try {
            this.openClassSource(classSource);
            final TargetsVisitorClassImpl visitor = new TargetsVisitorClassImpl(this, classSource.getCanonicalName(), TargetsVisitorClassImpl.DONT_RECORD_NEW_UNRESOLVED, i_unresolvedClassNames, TargetsVisitorClassImpl.DONT_RECORD_NEW_RESOLVED, i_resolvedClassNames, i_specificAnnotationClassNames, false);
            Set<String> i_useUnresolvedClassNames = this.i_dupClassNames(i_unresolvedClassNames);
            ClassSource_Streamer streamer = new ClassSource_Streamer(){
                static final long serialVersionUID = -371512780004116181L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public boolean doProcess(String className) {
                    return true;
                }

                @Override
                public boolean process(String i_className, InputStream inputStream) throws ClassSource_Exception {
                    return TargetsTableImpl.this.apply(visitor, i_className, inputStream);
                }

                @Override
                public boolean supportsJandex() {
                    return false;
                }

                @Override
                public boolean createJandex() {
                    return false;
                }

                @Override
                public void storeJandex(Object useJandexIndex) {
                    throw new UnsupportedOperationException("Specific scans do not use Jandex");
                }

                @Override
                public void processJandex() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean processJandex(Object jandexClassInfo) throws ClassSource_Exception {
                    throw new UnsupportedOperationException("Specific scans do not use Jandex");
                }

                @Override
                public boolean processSparseJandex(Object jandexClassInfo) throws ClassSource_Exception {
                    throw new UnsupportedOperationException("Specific scans do not use Jandex");
                }

                @Override
                public boolean doProcess(String className, ClassSource_Aggregate.ScanPolicy scanPolicy) {
                    return false;
                }

                @Override
                public boolean process(String sourceName, String className, InputStream inputStream, ClassSource_Aggregate.ScanPolicy scanPolicy) throws com.ibm.wsspi.anno.classsource.ClassSource_Exception {
                    return false;
                }

                @Override
                public boolean process(String sourceName, Object jandexClassInfo, ClassSource_Aggregate.ScanPolicy scanPolicy) throws com.ibm.wsspi.anno.classsource.ClassSource_Exception {
                    return false;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.internal.TargetsTableImpl$3", 3.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
                }
            };
            try {
                classSource.processSpecific(streamer, i_useUnresolvedClassNames);
            }
            catch (ClassSource_Exception classSource_Exception) {
                void e;
                FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.annocache.targets.internal.TargetsTableImpl", (String)"1212", (Object)this, (Object[])new Object[]{classSource, i_unresolvedClassNames, i_resolvedClassNames, i_specificAnnotationClassNames});
                throw this.getFactory().wrapIntoAnnotationTargetsException(logger, CLASS_NAME, methodName, "Failed to scan class source", (Throwable)e);
            }
        }
        finally {
            this.closeClassSource(classSource);
        }
        this.logState();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] RETURN", this.getHashText());
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void openClassSource(ClassSource classSource) throws AnnotationTargets_Exception {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "openClassSource", new Object[]{classSource});
        }
        String methodName = "openClassSource";
        try {
            classSource.open();
        }
        catch (ClassSource_Exception classSource_Exception) {
            void e;
            FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.annocache.targets.internal.TargetsTableImpl", (String)"1238", (Object)this, (Object[])new Object[]{classSource});
            throw this.getFactory().wrapIntoAnnotationTargetsException(logger, CLASS_NAME, methodName, "Failed to open class source", (Throwable)e);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "openClassSource");
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void closeClassSource(ClassSource classSource) throws AnnotationTargets_Exception {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "closeClassSource", new Object[]{classSource});
        }
        String methodName = "closeClassSource";
        try {
            classSource.close();
        }
        catch (ClassSource_Exception classSource_Exception) {
            void e;
            FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.annocache.targets.internal.TargetsTableImpl", (String)"1252", (Object)this, (Object[])new Object[]{classSource});
            throw this.getFactory().wrapIntoAnnotationTargetsException(logger, CLASS_NAME, methodName, "Failed to close class source", (Throwable)e);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "closeClassSource");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={TargetsVisitorClassImpl.VisitEnded.class, ArrayIndexOutOfBoundsException.class})
    protected boolean apply(TargetsVisitorClassImpl visitor, String i_className, InputStream inputStream) {
        boolean failedScan;
        Object[] logParms;
        String methodName;
        block10: {
            methodName = "apply";
            if (logger.isLoggable(Level.FINER)) {
                logParms = new Object[]{this.getHashText(), i_className, null};
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER [ {1} ]", logParms);
            } else {
                logParms = null;
            }
            visitor.reset();
            visitor.setExternalName(i_className);
            try {
                ClassReader classReader = new ClassReader(inputStream);
                classReader.accept((ClassVisitor)visitor, 7);
                failedScan = false;
                if (logParms != null) {
                    logParms[2] = "Success";
                }
            }
            catch (IOException classReader) {
                void e;
                FFDCFilter.processException((Throwable)classReader, (String)"com.ibm.ws.annocache.targets.internal.TargetsTableImpl", (String)"1309", (Object)this, (Object[])new Object[]{visitor, i_className, inputStream});
                failedScan = true;
                logger.logp(Level.WARNING, CLASS_NAME, methodName, "[ {0} ] ANNO_TARGETS_FAILED_TO_CREATE_READER [ {1} ] ({2} : {3})", new Object[]{this.getHashText(), i_className, e, e.getMessage()});
                logger.logp(Level.WARNING, CLASS_NAME, methodName, "Failed to create reader", (Throwable)e);
            }
            catch (TargetsVisitorClassImpl.VisitEnded e) {
                failedScan = true;
                if (logParms != null) {
                    logParms[2] = "Halted: " + (Object)((Object)e.getEndCase());
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                failedScan = true;
                logger.logp(Level.WARNING, CLASS_NAME, methodName, "[ {0} ] ANNO_TARGETS_CORRUPT_CLASS [ {1} ] ({2} : {3})", new Object[]{this.getHashText(), i_className, e, e.getMessage()});
                logger.logp(Level.WARNING, CLASS_NAME, methodName, "Corrupt class", e);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.annocache.targets.internal.TargetsTableImpl", (String)"1334", (Object)this, (Object[])new Object[]{visitor, i_className, inputStream});
                failedScan = true;
                logger.logp(Level.WARNING, CLASS_NAME, methodName, "[ {0} ] ANNO_TARGETS_SCAN_EXCEPTION [ {1} ] ({2} : {3})", new Object[]{this.getHashText(), i_className, e, e.getMessage()});
                logger.logp(Level.WARNING, CLASS_NAME, methodName, "Scan exception", e);
                if (logParms == null) break block10;
                logParms[2] = "Exception: " + e.getMessage();
            }
        }
        if (logParms != null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] RETURN [ {1} ]: [ {2} ]", logParms);
        }
        return !failedScan;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void record(TargetsVisitorClassImpl.ClassData classData) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "record", new Object[]{classData});
        }
        String methodName = "record";
        if (this.getClassTable().record(classData)) {
            this.getAnnotationTable().record(classData);
        } else {
            logger.logp(Level.FINER, CLASS_NAME, methodName, " [ {0} ] Unexpected duplication of class or package [ {1} ]", new Object[]{this.getHashText(), classData.className});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "record");
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void restrictedAdd(TargetsTableImpl table, Set<String> i_allAddedClassNames, Set<String> i_allAddedPackageNames) {
        Set<String> i_newlyAddedPackageNames = this.createIdentityStringSet();
        Set<String> i_newlyAddedClassNames = this.createIdentityStringSet();
        this.getClassTable().restrictedAdd(table.getClassTable(), i_newlyAddedPackageNames, i_allAddedPackageNames, i_newlyAddedClassNames, i_allAddedClassNames);
        this.getAnnotationTable().restrictedAdd(table.getAnnotationTable(), i_newlyAddedPackageNames, i_newlyAddedClassNames);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean sameAs(TargetsTableImpl otherTable, boolean isCongruent) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "sameAs", new Object[]{otherTable, isCongruent});
        }
        if (otherTable == null) {
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "sameAs", bl);
            }
            return bl;
        }
        if (otherTable == this) {
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "sameAs", bl);
            }
            return bl;
        }
        boolean bl = this.getClassTable().sameAs(otherTable.getClassTable(), isCongruent) && this.getAnnotationTable().sameAs(otherTable.getAnnotationTable(), isCongruent);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "sameAs", bl);
        }
        return bl;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void updateClassNames(Set<String> i_allResolvedClassNames, Set<String> i_allUnresolvedClassNames) {
        Set<String> i_newlyResolvedClassNames = this.createIdentityStringSet();
        Set<String> i_newlyUnresolvedClassNames = this.createIdentityStringSet();
        this.getClassTable().updateClassNames(i_allResolvedClassNames, i_newlyResolvedClassNames, i_allUnresolvedClassNames, i_newlyUnresolvedClassNames);
        this.getAnnotationTable().updateClassNames(i_allResolvedClassNames, i_newlyResolvedClassNames, i_allUnresolvedClassNames, i_newlyUnresolvedClassNames);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean getUseJandexFormat() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "getUseJandexFormat", new Object[0]);
        }
        boolean bl = this.useJandexFormat;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "getUseJandexFormat", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setJandexIndex(Index jandexIndex) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "setJandexIndex", new Object[]{jandexIndex});
        }
        String methodName = "setJandexIndex";
        if (logger.isLoggable(Level.FINER)) {
            String sizeText = jandexIndex == null ? "***NULL***" : Integer.toString(jandexIndex.getKnownClasses().size());
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ " + this.getName() + " ] Classes [ " + sizeText + " ]");
        }
        this.jandexIndex = jandexIndex;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "setJandexIndex");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Index getJandexIndex() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "getJandexIndex", new Object[0]);
        }
        Index index = this.jandexIndex;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            index = index;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "getJandexIndex", index);
        }
        return index;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Index consumeJandexIndex() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "consumeJandexIndex", new Object[0]);
        }
        Index useJandexIndex = this.jandexIndex;
        this.jandexIndex = null;
        Index index = useJandexIndex;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            index = index;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "consumeJandexIndex", index);
        }
        return index;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void transfer(Index useIndex) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "transfer", new Object[]{useIndex});
        }
        TargetsVisitorJandexConverterImpl jandexConverter = new TargetsVisitorJandexConverterImpl(this);
        String useClassSourceName = this.classSourceName;
        for (ClassInfo jandexClassInfo : useIndex.getKnownClasses()) {
            jandexConverter.convertClassInfo(useClassSourceName, jandexClassInfo);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "transfer");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void transfer(SparseIndex sparseIndex) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "transfer", new Object[]{sparseIndex});
        }
        TargetsVisitorSparseJandexConverterImpl sparseJandexConverter = new TargetsVisitorSparseJandexConverterImpl(this);
        String useClassSourceName = this.classSourceName;
        for (SparseClassInfo sparseClassInfo : sparseIndex.getKnownClasses()) {
            sparseJandexConverter.convertClassInfo(useClassSourceName, sparseClassInfo);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableImpl", "transfer");
        }
    }
}

