/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.util.delta.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.annocache.util.delta.internal.UtilImpl_PrintLogger;
import com.ibm.ws.annocache.util.internal.UtilImpl_BidirectionalMap;
import com.ibm.ws.annocache.util.internal.UtilImpl_Factory;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.annocache.util.Util_BidirectionalMap;
import com.ibm.wsspi.annocache.util.Util_BidirectionalMapDelta;
import com.ibm.wsspi.annocache.util.Util_Factory;
import com.ibm.wsspi.annocache.util.Util_InternMap;
import com.ibm.wsspi.annocache.util.Util_PrintLogger;
import java.io.PrintWriter;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class UtilImpl_BidirectionalMapDelta
implements Util_BidirectionalMapDelta {
    public static final String CLASS_NAME;
    protected final String hashText;
    protected final UtilImpl_Factory factory;
    protected final String holderTag;
    protected final String heldTag;
    protected final UtilImpl_BidirectionalMap addedMap;
    protected final UtilImpl_BidirectionalMap removedMap;
    protected final UtilImpl_BidirectionalMap stillMap;
    static final long serialVersionUID = -346649313037177938L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Override
    public String getHashText() {
        return this.hashText;
    }

    public UtilImpl_BidirectionalMapDelta(Util_Factory factory, boolean recordAdded, boolean recordRemoved, boolean recordStill, Util_InternMap holderMap, Util_InternMap heldMap) {
        this.factory = (UtilImpl_Factory)factory;
        this.holderTag = holderMap.getName();
        this.heldTag = heldMap.getName();
        this.hashText = this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
        this.addedMap = recordAdded ? this.factory.createBidirectionalMap(this.holderTag, holderMap, this.heldTag, heldMap) : null;
        this.removedMap = recordRemoved ? this.factory.createBidirectionalMap(this.holderTag, holderMap, this.heldTag, heldMap) : null;
        this.stillMap = recordStill ? this.factory.createBidirectionalMap(this.holderTag, holderMap, this.heldTag, heldMap) : null;
    }

    @Override
    public UtilImpl_Factory getFactory() {
        return this.factory;
    }

    @Override
    public String getHolderTag() {
        return this.holderTag;
    }

    @Override
    public String getHeldTag() {
        return this.heldTag;
    }

    @Override
    public Util_BidirectionalMap getAddedMap() {
        return this.addedMap;
    }

    @Override
    public boolean isNullAdded() {
        return this.addedMap == null || this.addedMap.isEmpty();
    }

    @Override
    public UtilImpl_BidirectionalMap getRemovedMap() {
        return this.removedMap;
    }

    @Override
    public boolean isNullRemoved() {
        return this.removedMap == null || this.removedMap.isEmpty();
    }

    @Override
    public UtilImpl_BidirectionalMap getStillMap() {
        return this.stillMap;
    }

    @Override
    public boolean isNullStill() {
        return this.stillMap == null || this.stillMap.isEmpty();
    }

    @Override
    public boolean isNull() {
        return this.isNullAdded() && this.isNullRemoved();
    }

    @Override
    public boolean isNull(boolean ignoreRemoved) {
        return this.isNullAdded() && (ignoreRemoved || this.isNullRemoved());
    }

    @Override
    public void describe(String prefix, List<String> nonNull) {
        if (!this.isNullAdded()) {
            nonNull.add(prefix + " Added [ " + this.getAddedMap().getHolderSet().size() + " ]");
        }
        if (!this.isNullRemoved()) {
            nonNull.add(prefix + " Removed [ " + this.getRemovedMap().getHolderSet().size() + " ]");
        }
    }

    @Override
    public void subtract(Util_BidirectionalMap finalMap, Util_BidirectionalMap initialMap) {
        Util_InternMap finalHolderDomain = finalMap.getHolderInternMap();
        Util_InternMap finalHeldDomain = finalMap.getHeldInternMap();
        Util_InternMap initialHolderDomain = initialMap.getHolderInternMap();
        Util_InternMap initialHeldDomain = initialMap.getHeldInternMap();
        if (finalHolderDomain == initialHolderDomain) {
            finalHolderDomain = null;
            initialHolderDomain = null;
        }
        if (finalHeldDomain == initialHeldDomain) {
            finalHeldDomain = null;
            initialHeldDomain = null;
        }
        for (String i_finalHolderName : finalMap.getHolderSet()) {
            Set<String> i_finalHeld = finalMap.i_selectHeldOf(i_finalHolderName);
            String asInitial_i_finalHolderName = this.intern(i_finalHolderName, initialHolderDomain);
            Set<String> i_initialHeld = this.selectHeldOf(asInitial_i_finalHolderName, initialMap);
            if (i_initialHeld == null || i_initialHeld.isEmpty()) {
                if (this.addedMap == null) continue;
                for (String i_heldName : i_finalHeld) {
                    this.addedMap.i_record(i_finalHolderName, i_heldName);
                }
                continue;
            }
            for (String i_finalHeldName : i_finalHeld) {
                String asInitial_i_finalHeldName = this.intern(i_finalHeldName, initialHeldDomain);
                if (asInitial_i_finalHeldName != null && i_initialHeld.contains(asInitial_i_finalHeldName)) {
                    if (this.stillMap == null) continue;
                    this.stillMap.i_record(i_finalHolderName, i_finalHeldName);
                    continue;
                }
                if (this.addedMap == null) continue;
                this.addedMap.i_record(i_finalHolderName, i_finalHeldName);
            }
        }
        for (String i_initialHolderName : initialMap.getHolderSet()) {
            Set<String> i_initialHeld = initialMap.selectHeldOf(i_initialHolderName);
            String asFinal_i_initialHolderName = this.intern(i_initialHolderName, finalHolderDomain);
            Set<String> i_finalHeld = this.selectHeldOf(asFinal_i_initialHolderName, finalMap);
            if (i_finalHeld == null || i_finalHeld.isEmpty()) {
                if (this.removedMap == null) continue;
                for (String i_heldName : i_initialHeld) {
                    this.removedMap.i_record(i_initialHolderName, i_heldName);
                }
                continue;
            }
            for (String i_initialHeldName : i_initialHeld) {
                String asFinal_i_initialHeldName = this.intern(i_initialHeldName, finalHeldDomain);
                if (asFinal_i_initialHeldName != null && i_finalHeld.contains(asFinal_i_initialHeldName) || this.removedMap == null) continue;
                this.removedMap.i_record(i_initialHolderName, i_initialHeldName);
            }
        }
    }

    private String intern(String value, Util_InternMap internMap) {
        if (internMap == null) {
            return value;
        }
        return internMap.intern(value, false);
    }

    private Set<String> selectHeldOf(String i_holder, Util_BidirectionalMap biMap) {
        if (i_holder == null) {
            return null;
        }
        return biMap.selectHeldOf(i_holder);
    }

    @Override
    public void log(Logger useLogger) {
        if (!useLogger.isLoggable(Level.FINER)) {
            return;
        }
        this.log(new UtilImpl_PrintLogger(useLogger));
    }

    @Override
    public void log(PrintWriter writer) {
        this.log(new UtilImpl_PrintLogger(writer));
    }

    @Override
    public void log(Util_PrintLogger useLogger) {
        String methodName = "log";
        boolean nullAdded = this.isNullAdded();
        boolean nullRemoved = this.isNullRemoved();
        boolean nullStill = this.isNullStill();
        if (nullAdded && nullRemoved) {
            int numStill = nullStill ? 0 : this.getStillMap().getHolderSet().size();
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Mapping Delta: [ {0} ] Unchanged [ {1} ]", this.getHashText(), numStill);
        } else {
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Mapping Delta: BEGIN: [ {0} ]", this.getHashText());
            if (!nullAdded) {
                this.logAddedAnnotations(useLogger);
            }
            if (!nullRemoved) {
                this.logRemovedAnnotations(useLogger);
            }
            if (!nullStill) {
                this.logStillAnnotations(useLogger);
            }
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Mapping Delta: END: [ {0} ]", this.getHashText());
        }
    }

    public void logAddedAnnotations(Util_PrintLogger useLogger) {
        String methodName = "logAddedAnnotations";
        Util_BidirectionalMap useAddedMap = this.getAddedMap();
        if (useAddedMap == null) {
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Added Entries: ** NOT RECORDED **");
            return;
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Added Entries: BEGIN");
        this.logMap(useLogger, useAddedMap);
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Added Entries: END");
    }

    public void logRemovedAnnotations(Util_PrintLogger useLogger) {
        String methodName = "logRemovedAnnotations";
        UtilImpl_BidirectionalMap useRemovedMap = this.getRemovedMap();
        if (useRemovedMap == null) {
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Removed Entries: ** NOT RECORDED **");
            return;
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Removed Entries: BEGIN");
        this.logMap(useLogger, useRemovedMap);
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Removed Entries: END");
    }

    public void logStillAnnotations(Util_PrintLogger useLogger) {
        String methodName = "logStillAnnotations";
        UtilImpl_BidirectionalMap useStillMap = this.getStillMap();
        if (useStillMap == null) {
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Still Entries: [ ** NOT RECORDED ** ]");
            return;
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Still Entries: BEGIN");
        this.logMap(useLogger, useStillMap);
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Still Entries: END");
    }

    protected void logMap(Util_PrintLogger useLogger, Util_BidirectionalMap map) {
        String methodName = "logMap";
        Set<String> useHolderSet = map.getHolderSet();
        if (useHolderSet.isEmpty()) {
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  ** NONE **");
        } else {
            for (String i_holderName : map.getHolderSet()) {
                useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  [ {0} ]", i_holderName);
                for (String i_heldName : map.i_selectHeldOf(i_holderName)) {
                    useLogger.logp(Level.FINER, CLASS_NAME, methodName, "    [ {0} ]", i_heldName);
                }
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.util.delta.internal.UtilImpl_BidirectionalMapDelta", UtilImpl_BidirectionalMapDelta.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        CLASS_NAME = UtilImpl_BidirectionalMapDelta.class.getSimpleName();
    }
}

