/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.handler.soap;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.xml.soap.Node;
import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPHeader;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.ws.Binding;
import jakarta.xml.ws.handler.Handler;
import jakarta.xml.ws.handler.MessageContext;
import jakarta.xml.ws.handler.soap.SOAPHandler;
import jakarta.xml.ws.handler.soap.SOAPMessageContext;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.binding.soap.HeaderUtil;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.interceptor.SoapInterceptor;
import org.apache.cxf.binding.soap.interceptor.SoapPreProtocolOutInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJInInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJOutInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.interceptor.OutgoingChainInterceptor;
import org.apache.cxf.jaxws.handler.AbstractProtocolHandlerInterceptor;
import org.apache.cxf.jaxws.handler.HandlerChainInvoker;
import org.apache.cxf.jaxws.handler.soap.SOAPMessageContextImpl;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.transport.MessageObserver;
import org.w3c.dom.Element;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class SOAPHandlerInterceptor
extends AbstractProtocolHandlerInterceptor<SoapMessage>
implements SoapInterceptor {
    private static final SAAJOutInterceptor SAAJ_OUT;
    AbstractSoapInterceptor ending = new AbstractSoapInterceptor(SOAPHandlerInterceptor.class.getName() + ".ENDING", "user-protocol"){
        static final long serialVersionUID = 7854339064839231997L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public void handleMessage(@Sensitive SoapMessage message) throws Fault {
            SOAPHandlerInterceptor.this.handleMessageInternal(message);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor$1", 1.class, null, null);
        }
    };
    static final long serialVersionUID = 3322351078986513298L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public SOAPHandlerInterceptor(Binding binding) {
        super(binding, "pre-protocol-frontend");
    }

    public Set<URI> getRoles() {
        return new HashSet<URI>();
    }

    public Set<QName> getUnderstoodHeaders() {
        HashSet<QName> understood = new HashSet<QName>();
        for (Handler h : this.getBinding().getHandlerChain()) {
            Set headers;
            if (!(h instanceof SOAPHandler) || (headers = CastUtils.cast((Set)((SOAPHandler)h).getHeaders())) == null) continue;
            understood.addAll(headers);
        }
        return understood;
    }

    @Override
    public void handleMessage(@Sensitive SoapMessage message) {
        if (this.binding.getHandlerChain().isEmpty()) {
            return;
        }
        if (this.getInvoker(message).getProtocolHandlers().isEmpty()) {
            return;
        }
        this.checkUnderstoodHeaders(message);
        if (this.getInvoker(message).isOutbound()) {
            if (!SOAPHandlerInterceptor.chainAlreadyContainsSAAJ(message)) {
                SAAJ_OUT.handleMessage(message);
            }
            message.getInterceptorChain().add((Interceptor)this.ending);
        } else {
            boolean isFault = this.handleMessageInternal(message);
            SOAPMessage msg = (SOAPMessage)message.getContent(SOAPMessage.class);
            if (msg != null) {
                XMLStreamReader xmlReader = this.createXMLStreamReaderFromSOAPMessage(msg);
                message.setContent(XMLStreamReader.class, (Object)xmlReader);
                try {
                    SAAJInInterceptor.replaceHeaders((SOAPMessage)msg, (SoapMessage)message);
                }
                catch (SOAPException e) {
                    e.printStackTrace();
                }
            }
            if (isFault) {
                Endpoint ep = message.getExchange().getEndpoint();
                message.getInterceptorChain().abort();
                if (ep.getInFaultObserver() != null) {
                    ep.getInFaultObserver().onMessage((Message)message);
                }
            }
        }
    }

    private void checkUnderstoodHeaders(SoapMessage soapMessage) {
        Set paramHeaders = HeaderUtil.getHeaderQNameInOperationParam((SoapMessage)soapMessage);
        if (soapMessage.getHeaders().isEmpty() && paramHeaders.isEmpty()) {
            this.getUnderstoodHeaders();
        }
    }

    private boolean handleMessageInternal(SoapMessage message) {
        MessageContext context = this.createProtocolMessageContext(message);
        if (context == null) {
            return true;
        }
        HandlerChainInvoker invoker = this.getInvoker(message);
        invoker.setProtocolMessageContext(context);
        if (!invoker.invokeProtocolHandlers(this.isRequestor((Message)message), context)) {
            this.handleAbort(message, context);
        }
        if (this.isRequestor((Message)message) && invoker.getLogicalHandlers().isEmpty() && !this.isOutbound(message) && this.isMEPComlete(message)) {
            this.onCompletion(message);
        } else if (this.isOutbound(message) && this.isMEPComlete(message)) {
            this.onCompletion(message);
        }
        return false;
    }

    private void handleAbort(SoapMessage message, MessageContext context) {
        if (this.isRequestor((Message)message)) {
            if (this.getInvoker(message).isOutbound()) {
                message.getInterceptorChain().abort();
                MessageObserver observer = (MessageObserver)message.getExchange().get(MessageObserver.class);
                if (!message.getExchange().isOneWay() && observer != null) {
                    Endpoint e = message.getExchange().getEndpoint();
                    MessageImpl responseMsg = new MessageImpl();
                    responseMsg.setExchange(message.getExchange());
                    responseMsg = e.getBinding().createMessage((Message)responseMsg);
                    message.getExchange().setInMessage((Message)responseMsg);
                    SOAPMessage soapMessage = ((SOAPMessageContext)context).getMessage();
                    if (soapMessage != null) {
                        responseMsg.setContent(SOAPMessage.class, (Object)soapMessage);
                        XMLStreamReader xmlReader = this.createXMLStreamReaderFromSOAPMessage(soapMessage);
                        responseMsg.setContent(XMLStreamReader.class, (Object)xmlReader);
                    }
                    responseMsg.put((Object)"starting_at_interceptor_id", (Object)SOAPHandlerInterceptor.class.getName());
                    observer.onMessage((Message)responseMsg);
                }
            } else {
                this.onCompletion(message);
            }
        } else if (!this.getInvoker(message).isOutbound()) {
            message.getInterceptorChain().abort();
            Endpoint e = message.getExchange().getEndpoint();
            if (!message.getExchange().isOneWay()) {
                MessageImpl responseMsg = new MessageImpl();
                responseMsg.setExchange(message.getExchange());
                responseMsg = e.getBinding().createMessage((Message)responseMsg);
                message.getExchange().setOutMessage((Message)responseMsg);
                SOAPMessage soapMessage = ((SOAPMessageContext)context).getMessage();
                responseMsg.setContent(SOAPMessage.class, (Object)soapMessage);
                InterceptorChain chain = OutgoingChainInterceptor.getOutInterceptorChain((Exchange)message.getExchange());
                responseMsg.setInterceptorChain(chain);
                chain.doInterceptStartingAfter((Message)responseMsg, SoapPreProtocolOutInterceptor.class.getName());
            }
        }
    }

    @Override
    protected MessageContext createProtocolMessageContext(SoapMessage message) {
        SOAPMessageContextImpl sm = new SOAPMessageContextImpl((Message)message);
        Exchange exch = message.getExchange();
        this.setupBindingOperationInfo(exch, sm);
        SOAPMessage msg = sm.getMessage();
        if (msg != null) {
            try {
                ArrayList<SOAPElement> params = new ArrayList<SOAPElement>();
                message.put((Object)"jakarta.xml.ws.reference.parameters", params);
                SOAPHeader head = SAAJUtils.getHeader((SOAPMessage)msg);
                if (head != null) {
                    Iterator it = CastUtils.cast((Iterator)head.getChildElements());
                    while (it != null && it.hasNext()) {
                        SOAPElement el;
                        Node nd = (Node)it.next();
                        if (!(nd instanceof SOAPElement) || !(el = (SOAPElement)nd).hasAttributeNS("http://www.w3.org/2005/08/addressing", "IsReferenceParameter") || !"1".equals(el.getAttributeNS("http://www.w3.org/2005/08/addressing", "IsReferenceParameter")) && !Boolean.parseBoolean(el.getAttributeNS("http://www.w3.org/2005/08/addressing", "IsReferenceParameter"))) continue;
                        params.add(el);
                    }
                }
                if (this.isRequestor((Message)message) && msg.getSOAPPart().getEnvelope().getBody() != null && msg.getSOAPPart().getEnvelope().getBody().hasFault()) {
                    return null;
                }
            }
            catch (SOAPException e) {
                throw new Fault((Throwable)e);
            }
        }
        return sm;
    }

    private XMLStreamReader createXMLStreamReaderFromSOAPMessage(SOAPMessage soapMessage) {
        XMLStreamReader xmlReader = null;
        try {
            DOMSource bodySource = new DOMSource((org.w3c.dom.Node)soapMessage.getSOAPPart().getEnvelope().getBody());
            xmlReader = StaxUtils.createXMLStreamReader((Source)bodySource);
            xmlReader.nextTag();
            xmlReader.nextTag();
        }
        catch (SOAPException | XMLStreamException e) {
            e.printStackTrace();
        }
        return xmlReader;
    }

    public void handleFault(SoapMessage message) {
        if (this.binding.getHandlerChain().isEmpty()) {
            return;
        }
        if (this.getInvoker(message).getProtocolHandlers().isEmpty()) {
            return;
        }
        if (this.getInvoker(message).isOutbound() && !SOAPHandlerInterceptor.chainAlreadyContainsSAAJ(message)) {
            SAAJ_OUT.handleFault(message);
        }
    }

    @Override
    protected QName getOpQName(Exchange ex, Object data) {
        SOAPMessageContextImpl sm = (SOAPMessageContextImpl)data;
        try {
            org.w3c.dom.Node nd;
            SOAPMessage msg = sm.getMessage();
            if (msg == null) {
                return null;
            }
            SOAPBody body = SAAJUtils.getBody((SOAPMessage)msg);
            if (body == null) {
                return null;
            }
            for (nd = body.getFirstChild(); nd != null && !(nd instanceof Element); nd = nd.getNextSibling()) {
            }
            if (nd != null) {
                return new QName(nd.getNamespaceURI(), nd.getLocalName());
            }
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
        return null;
    }

    private static boolean chainAlreadyContainsSAAJ(SoapMessage message) {
        ListIterator listIterator = message.getInterceptorChain().getIterator();
        while (listIterator.hasNext()) {
            if (!(listIterator.next() instanceof SAAJOutInterceptor)) continue;
            return true;
        }
        return false;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor", SOAPHandlerInterceptor.class, null, null);
        SAAJ_OUT = new SAAJOutInterceptor();
    }
}

