/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.restfulWS.internal.ssl.component;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.ssl.SSLSupport;
import io.openliberty.restfulWS.client.ClientBuilderListener;
import jakarta.ws.rs.client.ClientBuilder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Optional;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(immediate=true, property={"service.vendor=IBM"}, service={ClientBuilderListener.class})
public class SslClientBuilderListener
implements ClientBuilderListener {
    private static JSSEHelper jsseHelper;
    static final long serialVersionUID = -6670022166357524943L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Reference(name="SSLSupportService", service=SSLSupport.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setSSLSupportService(SSLSupport service) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"registerSSLSupportService", (Object[])new Object[0]);
        }
        jsseHelper = service.getJSSEHelper();
    }

    protected void unsetSSLSupportService(SSLSupport service) {
        jsseHelper = null;
    }

    /*
     * WARNING - void declaration
     */
    public void building(ClientBuilder clientBuilder) {
        Object sslRef = clientBuilder.getConfiguration().getProperty("com.ibm.ws.jaxrs.client.ssl.config");
        try {
            SslClientBuilderListener.getSSLContext(SslClientBuilderListener.toRefString(sslRef)).ifPresent(arg_0 -> ((ClientBuilder)clientBuilder).sslContext(arg_0));
        }
        catch (SSLException sSLException) {
            void ex;
            FFDCFilter.processException((Throwable)sSLException, (String)"io.openliberty.restfulWS.internal.ssl.component.SslClientBuilderListener", (String)"63", (Object)this, (Object[])new Object[]{clientBuilder});
            throw new IllegalStateException((Throwable)ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    static Optional<SSLContext> getSSLContext(String sslRef) throws SSLException {
        if (jsseHelper == null) {
            return Optional.empty();
        }
        if (null == System.getSecurityManager()) {
            return Optional.of(jsseHelper.getSSLContext(sslRef, null, null));
        }
        try {
            return AccessController.doPrivileged(() -> Optional.of(jsseHelper.getSSLContext(sslRef, null, null)));
        }
        catch (PrivilegedActionException privilegedActionException) {
            void pae;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"io.openliberty.restfulWS.internal.ssl.component.SslClientBuilderListener", (String)"79", null, (Object[])new Object[]{sslRef});
            Throwable cause = pae.getCause();
            if (cause instanceof SSLException) {
                throw (SSLException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new SSLException((Exception)cause);
        }
    }

    static String toRefString(Object o) {
        if (o instanceof Supplier) {
            o = ((Supplier)o).get();
        }
        if (o instanceof String) {
            return (String)o;
        }
        return o == null ? null : o.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.restfulWS.internal.ssl.component.SslClientBuilderListener", SslClientBuilderListener.class, (String)"RESTfulWS", null);
    }
}

