/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.common.jwt.jws;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.security.common.jwt.JwtParsingUtils;
import io.openliberty.security.common.jwt.exceptions.EncodedSignatureEmptyException;
import io.openliberty.security.common.jwt.exceptions.JwtContextMissingJoseObjects;
import io.openliberty.security.common.jwt.exceptions.SignatureAlgorithmDoesNotMatchHeaderException;
import java.security.Key;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwx.JsonWebStructure;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JwsSignatureVerifier {
    private static final TraceComponent tc = Tr.register(JwsSignatureVerifier.class, null, null);
    private final Key key;
    private final String signatureAlgorithm;
    static final long serialVersionUID = 3899080861322448490L;

    private JwsSignatureVerifier(Builder builder) {
        this.key = builder.key;
        this.signatureAlgorithm = builder.signatureAlgorithm != null ? builder.signatureAlgorithm : "RS256";
    }

    public Key getKey() {
        return this.key;
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public JwtClaims validateJwsSignature(JwtContext jwtContext) throws EncodedSignatureEmptyException, SignatureAlgorithmDoesNotMatchHeaderException, InvalidJwtException, JwtContextMissingJoseObjects {
        JsonWebStructure jws = JwtParsingUtils.getJsonWebStructureFromJwtContext(jwtContext);
        return this.validateJwsSignature((JsonWebSignature)jws, jwtContext.getJwt());
    }

    JwtClaims validateJwsSignature(JsonWebSignature signature, String jwtString) throws EncodedSignatureEmptyException, SignatureAlgorithmDoesNotMatchHeaderException, InvalidJwtException {
        this.verifySignAlgOnly(signature);
        JwtConsumerBuilder builder = new JwtConsumerBuilder();
        builder.setSkipDefaultAudienceValidation();
        if ("none".equals(this.signatureAlgorithm)) {
            builder.setDisableRequireSignature().setSkipSignatureVerification();
        } else {
            builder.setVerificationKey(this.key).setRelaxVerificationKeyValidation();
        }
        JwtConsumer jwtConsumer = builder.build();
        JwtContext validatedJwtContext = jwtConsumer.process(jwtString);
        return validatedJwtContext.getJwtClaims();
    }

    void verifySignAlgOnly(JsonWebSignature signature) throws EncodedSignatureEmptyException, SignatureAlgorithmDoesNotMatchHeaderException {
        String algHeader = signature.getAlgorithmHeaderValue();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Signing algorithm from header: " + algHeader), (Object[])new Object[0]);
        }
        if ("none".equals(this.signatureAlgorithm)) {
            return;
        }
        if (signature.getEncodedSignature().isEmpty()) {
            throw new EncodedSignatureEmptyException();
        }
        if (!this.signatureAlgorithm.equals(algHeader)) {
            throw new SignatureAlgorithmDoesNotMatchHeaderException(this.signatureAlgorithm, algHeader);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class Builder {
        private Key key = null;
        private String signatureAlgorithm = null;
        static final long serialVersionUID = 1198500363156193866L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public Builder key(Key key) {
            this.key = key;
            return this;
        }

        public Builder signatureAlgorithm(String signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
            return this;
        }

        public JwsSignatureVerifier build() {
            return new JwsSignatureVerifier(this);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.security.common.jwt.jws.JwsSignatureVerifier$Builder", Builder.class, null, null);
        }
    }
}

