/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.opentracing.jaeger.adapter;

import com.ibm.ws.microprofile.opentracing.jaeger.adapter.Configuration;
import com.ibm.ws.microprofile.opentracing.jaeger.adapter.JaegerAdapterException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public abstract class JaegerAdapterFactory {
    private static final String JAEGER_CONFIGURATION_IMPL = "com.ibm.ws.microprofile.opentracing.jaeger.adapter.impl.ConfigurationImpl";
    private static final Class<?>[] JAEGER_CONFIGURATION_ARG_TYPES = new Class[]{String.class};
    private static final String JAEGER_REPORTER_CONFIGURATION_IMPL = "com.ibm.ws.microprofile.opentracing.jaeger.adapter.impl.ReporterConfigurationImpl";
    private static final Class<?>[] JAEGER_REPORTER_CONFIGURATION_ARG_TYPES = new Class[0];
    private static final String JAEGER_SENDER_CONFIGURATION_IMPL = "com.ibm.ws.microprofile.opentracing.jaeger.adapter.impl.SenderConfigurationImpl";
    private static final Class<?>[] JAEGER_SENDER_CONFIGURATION_ARG_TYPES = new Class[0];
    private static final String JAEGER_SAMPLER_CONFIGURATION_IMPL = "com.ibm.ws.microprofile.opentracing.jaeger.adapter.impl.SamplerConfigurationImpl";
    private static final Class<?>[] JAEGER_SAMPLER_CONFIGURATION_ARG_TYPES = new Class[0];
    private static final String JAEGER_CODEC_CONFIGURATION_IMPL = "com.ibm.ws.microprofile.opentracing.jaeger.adapter.impl.CodecConfigurationImpl";
    private static final Class<?>[] JAEGER_CODEC_CONFIGURATION_ARG_TYPES = new Class[0];

    protected abstract ClassLoader getClassLoader();

    protected static final <T> T getInstance(ClassLoader classloader, Class<T> interfaceClass, String implClassName, Class<?>[] parameterTypes, Object ... parameters) {
        Class<T> implClass = JaegerAdapterFactory.getImplClass(classloader, interfaceClass, implClassName);
        T instance = JaegerAdapterFactory.getInstance(implClass, parameterTypes, parameters);
        return instance;
    }

    protected static final <T> T getInstance(Class<T> implClass, Class<?>[] parameterTypes, Object[] parameters) {
        Constructor<T> xtor = JaegerAdapterFactory.getConstructor(implClass, parameterTypes);
        T instance = null;
        try {
            instance = xtor.newInstance(parameters);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new JaegerAdapterException(e);
        }
        return instance;
    }

    protected static final <T> Constructor<T> getConstructor(Class<T> implClass, Class<?> ... parameterTypes) {
        Constructor<T> xtor = null;
        try {
            xtor = implClass.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new JaegerAdapterException(e);
        }
        return xtor;
    }

    protected static final <T> Class<? extends T> getImplClass(ClassLoader classloader, Class<T> interfaceClass, String implClassName) {
        Class<?> implClass = null;
        try {
            implClass = classloader.loadClass(implClassName);
        }
        catch (ClassNotFoundException e) {
            throw new JaegerAdapterException(e);
        }
        return implClass;
    }

    public Configuration newConfiguration(String serviceName) {
        Configuration config = JaegerAdapterFactory.getInstance(this.getClassLoader(), Configuration.class, JAEGER_CONFIGURATION_IMPL, JAEGER_CONFIGURATION_ARG_TYPES, serviceName);
        return config;
    }

    public Configuration.ReporterConfiguration newReporterConfiguration() {
        Configuration.ReporterConfiguration config = JaegerAdapterFactory.getInstance(this.getClassLoader(), Configuration.ReporterConfiguration.class, JAEGER_REPORTER_CONFIGURATION_IMPL, JAEGER_REPORTER_CONFIGURATION_ARG_TYPES, new Object[0]);
        return config;
    }

    public Configuration.SenderConfiguration newSenderConfiguration() {
        Configuration.SenderConfiguration config = JaegerAdapterFactory.getInstance(this.getClassLoader(), Configuration.SenderConfiguration.class, JAEGER_SENDER_CONFIGURATION_IMPL, JAEGER_SENDER_CONFIGURATION_ARG_TYPES, new Object[0]);
        return config;
    }

    public Configuration.SamplerConfiguration newSamplerConfiguration() {
        Configuration.SamplerConfiguration config = JaegerAdapterFactory.getInstance(this.getClassLoader(), Configuration.SamplerConfiguration.class, JAEGER_SAMPLER_CONFIGURATION_IMPL, JAEGER_SAMPLER_CONFIGURATION_ARG_TYPES, new Object[0]);
        return config;
    }

    public Configuration.CodecConfiguration newCodecConfiguration() {
        Configuration.CodecConfiguration config = JaegerAdapterFactory.getInstance(this.getClassLoader(), Configuration.CodecConfiguration.class, JAEGER_CODEC_CONFIGURATION_IMPL, JAEGER_CODEC_CONFIGURATION_ARG_TYPES, new Object[0]);
        return config;
    }
}

