/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.servlet.filter;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.servlet.filter.ChainedResponse;
import com.ibm.websphere.servlet.request.ServletInputStreamAdapter;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.servlet.RequestUtils;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.util.FFDCWrapper;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class ChainedRequest
extends HttpServletRequestWrapper {
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.websphere.servlet.filter");
    private static final String CLASS_NAME = "com.ibm.websphere.servlet.filter.ChainedRequest";
    private ChainedResponse _resp;
    private HttpServletRequest _req;
    private ServletInputStream _in;
    private BufferedReader _reader;
    private Hashtable _parameters;
    private Hashtable _headers;
    private static TraceNLS nls = TraceNLS.getTraceNLS(ChainedRequest.class, (String)"com.ibm.ws.webcontainer.resources.Messages");
    private static boolean allowQueryParamWithNoEqual = WCCustomProperties.ALLOW_QUERY_PARAM_WITH_NO_EQUAL;
    static final long serialVersionUID = -8812776818782166575L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    ChainedRequest(ChainedResponse resp, HttpServletRequest req) throws IOException {
        super(req);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[]{resp, req});
        }
        this._parameters = new Hashtable();
        this._headers = new Hashtable();
        this._resp = resp;
        this._req = req;
        ByteArrayInputStream bin = new ByteArrayInputStream(resp.getOutputBuffer());
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "onServletUnloaded", "Creating chained Request with buffer:\n" + new String(resp.getOutputBuffer()));
        }
        this._in = new ServletInputStreamAdapter(bin);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Cookie[] getCookies() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getCookies", new Object[0]);
        }
        Cookie[] cookieArray = this._resp.getCookies();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            cookieArray = cookieArray;
            logger.exiting(CLASS_NAME, "getCookies", cookieArray);
        }
        return cookieArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ServletInputStream getInputStream() throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getInputStream", new Object[0]);
        }
        ServletInputStream servletInputStream = this._in;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            servletInputStream = servletInputStream;
            logger.exiting(CLASS_NAME, "getInputStream", servletInputStream);
        }
        return servletInputStream;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public BufferedReader getReader() throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getReader", new Object[0]);
        }
        if (this._reader == null) {
            this._reader = new BufferedReader(new InputStreamReader((InputStream)this._in, this._resp.getCharacterEncoding()));
        }
        BufferedReader bufferedReader = this._reader;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bufferedReader = bufferedReader;
            logger.exiting(CLASS_NAME, "getReader", bufferedReader);
        }
        return bufferedReader;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public HttpServletRequest getProxiedHttpServletRequest() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getProxiedHttpServletRequest", new Object[0]);
        }
        HttpServletRequest httpServletRequest = this._req;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            httpServletRequest = httpServletRequest;
            logger.exiting(CLASS_NAME, "getProxiedHttpServletRequest", httpServletRequest);
        }
        return httpServletRequest;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void setHeader(String name, String value) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setHeader", new Object[]{name, value});
        }
        if (name == null) {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.exiting(CLASS_NAME, "setHeader");
            }
            return;
        }
        if (value == null) {
            this._headers.remove(name);
        } else {
            this._headers.put(name, value);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setHeader");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Enumeration getHeaderNames() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getHeaderNames", new Object[0]);
        }
        Enumeration enumeration = this._headers.keys();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            enumeration = enumeration;
            logger.exiting(CLASS_NAME, "getHeaderNames", enumeration);
        }
        return enumeration;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getHeader(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getHeader", new Object[]{name});
        }
        String string = (String)this._headers.get(name);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "getHeader", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getIntHeader(String name) throws NumberFormatException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getIntHeader", new Object[]{name});
        }
        String val = (String)this._headers.get(name);
        if (val == null) {
            int n = -1;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                n = n;
                logger.exiting(CLASS_NAME, "getIntHeader", n);
            }
            return n;
        }
        int n = Integer.valueOf(val);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting(CLASS_NAME, "getIntHeader", n);
        }
        return n;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getDateHeader(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getDateHeader", new Object[]{name});
        }
        String val = (String)this._headers.get(name);
        if (val == null) {
            long l = -1L;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                l = l;
                logger.exiting(CLASS_NAME, "getDateHeader", l);
            }
            return l;
        }
        long l = Long.valueOf(val);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting(CLASS_NAME, "getDateHeader", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getContentLength() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getContentLength", new Object[0]);
        }
        int n = this.getIntHeader("content-length");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting(CLASS_NAME, "getContentLength", n);
        }
        return n;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getContentType() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getContentType", new Object[0]);
        }
        String string = this.getHeader("content-type");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "getContentType", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getParameter(String name) {
        String[] values;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getParameter", new Object[]{name});
        }
        if (this._parameters == null) {
            this.parseParameters();
        }
        if ((values = (String[])this._parameters.get(name)) != null && values.length > 0) {
            String string = values[0];
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "getParameter", string);
            }
            return string;
        }
        String string = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "getParameter", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Enumeration getParameterNames() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getParameterNames", new Object[0]);
        }
        if (this._parameters == null) {
            this.parseParameters();
        }
        Enumeration enumeration = this._parameters.keys();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            enumeration = enumeration;
            logger.exiting(CLASS_NAME, "getParameterNames", enumeration);
        }
        return enumeration;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String[] getParameterValues(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getParameterValues", new Object[]{name});
        }
        if (this._parameters == null) {
            this.parseParameters();
        }
        String[] stringArray = (String[])this._parameters.get(name);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            stringArray = stringArray;
            logger.exiting(CLASS_NAME, "getParameterValues", stringArray);
        }
        return stringArray;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private synchronized void parseParameters() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "parseParameters", new Object[0]);
        }
        if (this._parameters == null) {
            try {
                String contentType;
                String method = this.getMethod().toLowerCase();
                if (method.equals("get")) {
                    String queryString = this.getQueryString();
                    if (queryString != null && (queryString.indexOf("=") != -1 || allowQueryParamWithNoEqual)) {
                        this._parameters = RequestUtils.parseQueryString((String)this.getQueryString());
                    }
                } else if (method.equals("post") && (contentType = this.getContentType()) != null && contentType.equals("application/x-www-form-urlencoded")) {
                    this._parameters = this.parsePostData(this.getContentLength(), this.getInputStream());
                }
            }
            catch (IOException method) {
                void e;
                FFDCFilter.processException((Throwable)method, (String)CLASS_NAME, (String)"211", (Object)((Object)this), (Object[])new Object[0]);
                FFDCWrapper.processException((Throwable)e, (String)"com.ibm.websphere.servlet.filter.ChainedResponse.parseParameters", (String)"286", (Object)((Object)this));
            }
            if (this._parameters == null) {
                this._parameters = new Hashtable();
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "parseParameters");
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Hashtable parsePostData(int len, ServletInputStream in) {
        String postedBody;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "parsePostData", new Object[]{len, in});
        }
        byte[] postedBytes = null;
        if (len <= 0) {
            Hashtable hashtable = null;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                hashtable = hashtable;
                logger.exiting(CLASS_NAME, "parsePostData", hashtable);
            }
            return hashtable;
        }
        try {
            int inputLen;
            postedBytes = new byte[len];
            int offset = 0;
            do {
                if ((inputLen = in.read(postedBytes, offset, len - offset)) > 0) continue;
                String msg = nls.getString("post.body.contains.less.bytes.than.specified", "post body contains less bytes than specified by content-length");
                throw new IOException(msg);
            } while (len - (offset += inputLen) > 0);
        }
        catch (IOException msg) {
            void e;
            FFDCFilter.processException((Throwable)msg, (String)CLASS_NAME, (String)"250", (Object)((Object)this), (Object[])new Object[]{len, in});
            FFDCWrapper.processException((Throwable)e, (String)"com.ibm.websphere.servlet.filter.ChainedResponse.parsePostData", (String)"326", (Object)((Object)this));
            Hashtable hashtable = new Hashtable();
            if (logger != null && logger.isLoggable(Level.FINER)) {
                hashtable = hashtable;
                logger.exiting(CLASS_NAME, "parsePostData", hashtable);
            }
            return hashtable;
        }
        try {
            postedBody = new String(postedBytes, this._resp.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            FFDCFilter.processException((Throwable)e, (String)CLASS_NAME, (String)"265", (Object)((Object)this), (Object[])new Object[]{len, in});
            FFDCWrapper.processException((Throwable)e, (String)"com.ibm.websphere.servlet.filter.ChainedResponse.parsePostData", (String)"341", (Object)((Object)this));
            postedBody = new String(postedBytes);
        }
        Hashtable hashtable = RequestUtils.parseQueryString((String)postedBody);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            hashtable = hashtable;
            logger.exiting(CLASS_NAME, "parsePostData", hashtable);
        }
        return hashtable;
    }
}

