/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.cors;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.cors.config.CorsConfig;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={CorsHelper.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class CorsHelper {
    private static final TraceComponent tc = Tr.register(CorsHelper.class, (String)"CorsService", (String)"com.ibm.ws.webcontainer.cors.internal.resources.CorsServiceMessages");
    private static final String REQUEST_HEADER_ORIGIN = "Origin";
    private static final String REQUEST_HEADER_ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
    private static final String REQUEST_HEADER_ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
    private static final String RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    private static final String RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    private static final String RESPONSE_HEADER_ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
    private static final String RESPONSE_HEADER_ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    private static final String RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    private static final String RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    private static final List<String> SIMPLE_REQUEST_HEADER_CONTENT_TYPE_VALUES = Arrays.asList("application/x-www-form-urlencoded", "multipart/form-data", "text/plain");
    List<CorsConfig> configurations = new CopyOnWriteArrayList<CorsConfig>();
    static final long serialVersionUID = -8836660110101617808L;

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
    }

    @Deactivate
    protected void deactivate(ComponentContext context, int reason) {
    }

    @Reference(service=CorsConfig.class, name="corsConfig", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY)
    protected void setCorsConfig(CorsConfig corsConfig) {
        this.configurations.add(corsConfig);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Added CorsConfig : " + corsConfig), (Object[])new Object[0]);
        }
    }

    protected void unsetCorsConfig(CorsConfig corsConfig) {
        this.configurations.remove(corsConfig);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Removed CorsConfig : " + corsConfig), (Object[])new Object[0]);
        }
    }

    public boolean handleCorsRequest(HttpServletRequest request, HttpServletResponse response) {
        boolean continueHandlingRequest = false;
        if (request.getHeader(REQUEST_HEADER_ORIGIN) != null) {
            this.logCorsRequestInfo(request);
            CorsRequestType type = this.getRequestType(request);
            if (type == CorsRequestType.PRE_FLIGHT) {
                continueHandlingRequest = this.handlePreflightRequest(request, response);
            } else if (type == CorsRequestType.SIMPLE || type == CorsRequestType.ACTUAL) {
                continueHandlingRequest = this.handleSimpleCrossOriginRequest(request, response);
            }
            this.logCorsResponseInfo(response);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Request is fully handled and processed? " + continueHandlingRequest), (Object[])new Object[0]);
        }
        return continueHandlingRequest;
    }

    private boolean handleSimpleCrossOriginRequest(HttpServletRequest request, HttpServletResponse response) {
        String requestOrigin = request.getHeader(REQUEST_HEADER_ORIGIN);
        if (requestOrigin == null) {
            return false;
        }
        CorsConfig config = this.matchCorsConfig(request.getRequestURI());
        if (config == null) {
            return false;
        }
        if (!CorsHelper.isMatch(config, requestOrigin)) {
            return false;
        }
        boolean allowCredentials = config.getAllowCredentials();
        if (allowCredentials) {
            response.setHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_CREDENTIALS, "true");
        }
        if (CorsHelper.isWildcardPath(config.getAllowedOrigins()) && !allowCredentials) {
            response.setHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, "*");
        } else {
            response.setHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, CorsHelper.filterHttpHeader(requestOrigin));
        }
        String exposeHeaders = config.getExposedHeaders();
        if (exposeHeaders != null) {
            response.setHeader(RESPONSE_HEADER_ACCESS_CONTROL_EXPOSE_HEADERS, exposeHeaders);
        }
        return false;
    }

    private boolean handlePreflightRequest(HttpServletRequest request, HttpServletResponse response) {
        boolean allowCredentials;
        String requestOrigin = request.getHeader(REQUEST_HEADER_ORIGIN);
        if (requestOrigin == null) {
            return false;
        }
        CorsConfig config = this.matchCorsConfig(request.getRequestURI());
        if (config == null) {
            return false;
        }
        if (!CorsHelper.isMatch(config, requestOrigin)) {
            return false;
        }
        String accessControlRequestMethod = request.getHeader(REQUEST_HEADER_ACCESS_CONTROL_REQUEST_METHOD);
        if (accessControlRequestMethod == null || accessControlRequestMethod.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Value of the request header 'Access-Control-Request-Method' is '" + String.valueOf(accessControlRequestMethod) + "'."), (Object[])new Object[0]);
            }
            return false;
        }
        accessControlRequestMethod = accessControlRequestMethod.trim();
        String accessControlRequestHeadersHeader = request.getHeader(REQUEST_HEADER_ACCESS_CONTROL_REQUEST_HEADERS);
        List<Object> accessControlRequestHeaders = accessControlRequestHeadersHeader == null || accessControlRequestHeadersHeader.isEmpty() ? Collections.emptyList() : Arrays.asList(accessControlRequestHeadersHeader.trim().split("\\s*,\\s*"));
        List<String> allowedMethods = config.getAllowedMethods();
        if (!allowedMethods.contains(accessControlRequestMethod)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Access-Control-Request-Method '" + accessControlRequestMethod + "' is not included in the list of allowed methods: " + Arrays.toString(allowedMethods.toArray())), (Object[])new Object[0]);
            }
            return false;
        }
        List<String> allowedHeaders = config.getAllowedHeaders();
        if (!accessControlRequestHeaders.isEmpty() && !CorsHelper.isWildcardHeader(allowedHeaders)) {
            TreeSet<String> allowedHeadersSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            TreeSet<Object> accessControlRequestHeaderSet = new TreeSet<Object>(String.CASE_INSENSITIVE_ORDER);
            allowedHeadersSet.addAll(allowedHeaders);
            accessControlRequestHeaderSet.addAll(accessControlRequestHeaders);
            if (!allowedHeadersSet.containsAll(accessControlRequestHeaderSet)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Access-Control-Request-Header '" + Arrays.toString(accessControlRequestHeaders.toArray()) + "' is not included in the list of allowed headers: " + Arrays.toString(allowedHeaders.toArray())), (Object[])new Object[0]);
                }
                return false;
            }
        }
        if (allowCredentials = config.getAllowCredentials()) {
            response.setHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_CREDENTIALS, "true");
        }
        if (CorsHelper.isWildcardPath(config.getAllowedOrigins()) && !allowCredentials) {
            response.setHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, "*");
        } else {
            response.setHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, CorsHelper.filterHttpHeader(requestOrigin));
        }
        Long maxAge = config.getMaxAge();
        if (maxAge != null) {
            response.setHeader(RESPONSE_HEADER_ACCESS_CONTROL_MAX_AGE, String.valueOf(maxAge));
        }
        response.setHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_METHODS, CorsHelper.join(", ", allowedMethods));
        if (CorsHelper.isWildcardHeader(allowedHeaders)) {
            if (!accessControlRequestHeaders.isEmpty()) {
                response.setHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_HEADERS, CorsHelper.join(", ", accessControlRequestHeaders));
            }
        } else if (!allowedHeaders.isEmpty()) {
            response.setHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_HEADERS, CorsHelper.join(", ", allowedHeaders));
        }
        return true;
    }

    private CorsRequestType getRequestType(HttpServletRequest request) {
        CorsRequestType type = CorsRequestType.OTHER;
        String origin = request.getHeader(REQUEST_HEADER_ORIGIN);
        if (origin != null && !origin.isEmpty()) {
            String requestMethod = request.getMethod();
            if ("OPTIONS".equals(requestMethod)) {
                String accessControlRequestMethod = request.getHeader(REQUEST_HEADER_ACCESS_CONTROL_REQUEST_METHOD);
                if (accessControlRequestMethod != null && !accessControlRequestMethod.isEmpty()) {
                    type = CorsRequestType.PRE_FLIGHT;
                } else if (accessControlRequestMethod == null) {
                    type = CorsRequestType.ACTUAL;
                }
            } else {
                type = "GET".equals(requestMethod) || "HEAD".equals(requestMethod) ? CorsRequestType.SIMPLE : ("POST".equals(requestMethod) ? (SIMPLE_REQUEST_HEADER_CONTENT_TYPE_VALUES.contains(CorsHelper.getType(request.getContentType())) ? CorsRequestType.SIMPLE : CorsRequestType.ACTUAL) : CorsRequestType.ACTUAL);
            }
        }
        return type;
    }

    private static String getType(String contentType) {
        if (contentType == null) {
            return null;
        }
        int firstIndex = contentType.indexOf(";");
        String type = firstIndex == -1 ? contentType : contentType.substring(0, firstIndex);
        return type.trim().toLowerCase(Locale.ENGLISH);
    }

    private CorsConfig matchCorsConfig(String path) {
        CorsConfig matchingConfig = null;
        if (!this.configurations.isEmpty()) {
            int length = -1;
            for (CorsConfig config : this.configurations) {
                String domain = config.getDomain();
                if (!path.startsWith(domain) || domain.length() <= length) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Found " + (matchingConfig == null ? "first" : "a better") + " match. path=" + path + " : corsConfig=" + config), (Object[])new Object[0]);
                }
                length = domain.length();
                matchingConfig = config;
            }
        }
        if (matchingConfig == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Found no match for path " + path), (Object[])new Object[0]);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Found a match. path=" + path + " : matchingConfig=" + matchingConfig), (Object[])new Object[0]);
        }
        return matchingConfig;
    }

    private static boolean isWildcardHeader(List<String> allowedHeaders) {
        return !allowedHeaders.isEmpty() && "*".equals(allowedHeaders.get(0));
    }

    private static String filterHttpHeader(String original) {
        return original.replaceAll("(\\n|\\r|\\u0085|\\u2028)", "");
    }

    private static boolean isMatch(CorsConfig config, String path) {
        if (config == null) {
            return false;
        }
        List<String> allowedOrigins = config.getAllowedOrigins();
        if (allowedOrigins.get(0).equals("null")) {
            return false;
        }
        if (CorsHelper.isWildcardPath(allowedOrigins)) {
            return true;
        }
        for (String origin : allowedOrigins) {
            if (!origin.equals(path)) continue;
            return true;
        }
        return false;
    }

    private static boolean isWildcardPath(List<String> allowedOrigins) {
        return "*".equals(allowedOrigins.get(0));
    }

    public boolean isCorsSupportEnabled() {
        return !this.configurations.isEmpty();
    }

    private static String join(String delimiter, List<String> elements) {
        if (elements == null || delimiter == null) {
            throw new NullPointerException();
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (String element : elements) {
            if (!isFirst) {
                sb.append(delimiter);
            } else {
                isFirst = false;
            }
            if (element == null) continue;
            sb.append(element);
        }
        return sb.toString();
    }

    private void logCorsRequestInfo(HttpServletRequest request) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Request :: Method: " + request.getMethod() + " | Origin: " + String.valueOf(request.getHeader(REQUEST_HEADER_ORIGIN)) + " | Request Method: " + String.valueOf(request.getHeader(REQUEST_HEADER_ACCESS_CONTROL_REQUEST_METHOD)) + " | Request Headers: " + String.valueOf(request.getHeader(REQUEST_HEADER_ACCESS_CONTROL_REQUEST_HEADERS))), (Object[])new Object[0]);
        }
    }

    private void logCorsResponseInfo(HttpServletResponse response) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Respond :: Allow Origin: " + String.valueOf(response.getHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_ORIGIN)) + " | Allow Credential: " + String.valueOf(response.getHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_CREDENTIALS)) + " | Expose Headers: " + String.valueOf(response.getHeader(RESPONSE_HEADER_ACCESS_CONTROL_EXPOSE_HEADERS)) + " | Max Age: " + String.valueOf(response.getHeader(RESPONSE_HEADER_ACCESS_CONTROL_MAX_AGE)) + " | Allow Methods: " + String.valueOf(response.getHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_METHODS)) + " | Allow Headers :" + String.valueOf(response.getHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_HEADERS))), (Object[])new Object[0]);
        }
    }

    private static enum CorsRequestType {
        SIMPLE,
        PRE_FLIGHT,
        ACTUAL,
        OTHER;

    }
}

