/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.security.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.javaee.dd.common.SecurityRole;
import com.ibm.ws.javaee.dd.web.common.AuthConstraint;
import com.ibm.ws.javaee.dd.web.common.LoginConfig;
import com.ibm.ws.javaee.dd.web.common.UserDataConstraint;
import com.ibm.ws.jaxws.metadata.JaxWsModuleInfo;
import com.ibm.ws.jaxws.metadata.JaxWsModuleType;
import com.ibm.ws.jaxws.metadata.ServiceSecurityInfo;
import com.ibm.ws.jaxws.webcontainer.JaxWsWebAppConfigurator;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.security.metadata.LoginConfiguration;
import com.ibm.ws.webcontainer.security.metadata.LoginConfigurationImpl;
import com.ibm.ws.webcontainer.security.metadata.SecurityConstraint;
import com.ibm.ws.webcontainer.security.metadata.SecurityConstraintCollection;
import com.ibm.ws.webcontainer.security.metadata.SecurityConstraintCollectionImpl;
import com.ibm.ws.webcontainer.security.metadata.SecurityMetadata;
import com.ibm.ws.webcontainer.security.metadata.WebResourceCollection;
import com.ibm.ws.webcontainer.webapp.WebAppConfigExtended;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.util.ArrayList;
import java.util.List;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JaxWsWebAppSecurityConfigurator
implements JaxWsWebAppConfigurator {
    private static final TraceComponent tc = Tr.register(JaxWsWebAppSecurityConfigurator.class, (String)"JaxWsSecurity", (String)"com.ibm.ws.jaxws.security.internal.resources.JaxWsSecurityMessages");
    private static final String ALL_ROLES_MARKER = "*";
    static final long serialVersionUID = 5640040896311607225L;

    public void configure(JaxWsModuleInfo jaxWsModuleInfo, WebAppConfig webAppConfig) {
        SecurityMetadata securityMetaData = (SecurityMetadata)((WebAppConfigExtended)webAppConfig).getMetaData().getSecurityMetaData();
        ServiceSecurityInfo jaxWsServiceSecurityInfo = jaxWsModuleInfo.getServiceSecurityInfo();
        if (jaxWsServiceSecurityInfo == null) {
            return;
        }
        List roles = securityMetaData.getRoles();
        for (SecurityRole securityRole : jaxWsServiceSecurityInfo.getSecurityRoles()) {
            String role = securityRole.getRoleName();
            if (role == null || role.equals(ALL_ROLES_MARKER) || roles.contains(role)) continue;
            roles.add(role);
        }
        LoginConfig loginConfig = jaxWsServiceSecurityInfo.getLoginConfig();
        if (loginConfig != null) {
            if (!jaxWsModuleInfo.getModuleType().equals((Object)JaxWsModuleType.EJB)) {
                Tr.warning((TraceComponent)tc, (String)"ibm.ws.bnd.login.config.in.war.is.ingnored", (Object[])new Object[0]);
            } else {
                String authMethod = loginConfig.getAuthMethod();
                String realmName = loginConfig.getRealmName();
                if (authMethod != null || realmName != null) {
                    if ("CLIENT-CERT".equalsIgnoreCase(authMethod)) {
                        authMethod = "CLIENT_CERT";
                    }
                    if (authMethod == null) {
                        authMethod = "BASIC";
                    }
                    if ("BASIC".equals(authMethod) || "CLIENT_CERT".equals(authMethod)) {
                        securityMetaData.setLoginConfiguration((LoginConfiguration)new LoginConfigurationImpl(authMethod, realmName, null));
                    } else {
                        Tr.warning((TraceComponent)tc, (String)"ibm.ws.bnd.auth.method.not.support", (Object[])new Object[]{authMethod});
                    }
                }
            }
        }
        ArrayList<SecurityConstraint> securityConstraints = new ArrayList<SecurityConstraint>();
        for (com.ibm.ws.javaee.dd.web.common.SecurityConstraint archiveSecurityConstraint : jaxWsServiceSecurityInfo.getSecurityConstraints()) {
            SecurityConstraint securityConstraint = this.createSecurityConstraint(archiveSecurityConstraint, roles);
            securityConstraints.add(securityConstraint);
        }
        SecurityConstraintCollection securityConstraintCollection = securityMetaData.getSecurityConstraintCollection();
        if (securityConstraintCollection != null) {
            securityConstraintCollection.addSecurityConstraints(securityConstraints);
        } else {
            securityMetaData.setSecurityConstraintCollection((SecurityConstraintCollection)new SecurityConstraintCollectionImpl(securityConstraints));
        }
    }

    private SecurityConstraint createSecurityConstraint(com.ibm.ws.javaee.dd.web.common.SecurityConstraint archiveConstraint, List<String> allRoles) {
        List<WebResourceCollection> webResourceCollections = this.createWebResourceCollections(archiveConstraint);
        List<String> roles = this.createRoles(archiveConstraint, allRoles);
        boolean sslRequired = this.isSSLRequired(archiveConstraint);
        boolean accessPrecluded = this.isAccessPrecluded(archiveConstraint);
        boolean accessUncovered = false;
        boolean fromHttpConstraint = false;
        return new SecurityConstraint(webResourceCollections, roles, sslRequired, accessPrecluded, accessUncovered, fromHttpConstraint);
    }

    private List<WebResourceCollection> createWebResourceCollections(com.ibm.ws.javaee.dd.web.common.SecurityConstraint archiveConstraint) {
        ArrayList<WebResourceCollection> webResourceCollections = new ArrayList<WebResourceCollection>();
        List archiveWebResourceCollections = archiveConstraint.getWebResourceCollections();
        for (com.ibm.ws.javaee.dd.web.common.WebResourceCollection archiveWebResourceCollection : archiveWebResourceCollections) {
            List urlPatterns = archiveWebResourceCollection.getURLPatterns();
            List methods = archiveWebResourceCollection.getHTTPMethods();
            List omissionMethods = archiveWebResourceCollection.getHTTPMethodOmissions();
            webResourceCollections.add(new WebResourceCollection(urlPatterns, methods, omissionMethods));
        }
        return webResourceCollections;
    }

    private List<String> createRoles(com.ibm.ws.javaee.dd.web.common.SecurityConstraint archiveConstraint, List<String> allRoles) {
        List<String> roles = new ArrayList<String>();
        AuthConstraint authConstraint = archiveConstraint.getAuthConstraint();
        if (authConstraint != null && (roles = authConstraint.getRoleNames()).contains(ALL_ROLES_MARKER)) {
            roles = allRoles;
        }
        return roles;
    }

    private boolean isSSLRequired(com.ibm.ws.javaee.dd.web.common.SecurityConstraint archiveConstraint) {
        int transportGuarantee;
        boolean sslRequired = false;
        UserDataConstraint dataConstraint = archiveConstraint.getUserDataConstraint();
        if (dataConstraint != null && (transportGuarantee = dataConstraint.getTransportGuarantee()) != 0) {
            sslRequired = true;
        }
        return sslRequired;
    }

    private boolean isAccessPrecluded(com.ibm.ws.javaee.dd.web.common.SecurityConstraint archiveConstraint) {
        List roles;
        boolean accessPrecluded = false;
        AuthConstraint authConstraint = archiveConstraint.getAuthConstraint();
        if (authConstraint != null && ((roles = authConstraint.getRoleNames()) == null || roles.isEmpty())) {
            accessPrecluded = true;
        }
        return accessPrecluded;
    }
}

