/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.sib.ra.impl.SibRaConnectionRequestInfo;
import com.ibm.ws.sib.ra.impl.SibRaManagedConnectionFactory;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionFactory;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ResourceAdapterInternalException;
import jakarta.resource.spi.security.PasswordCredential;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;

final class SibRaConnectionInfo
implements FFDCSelfIntrospectable {
    private final String _userName;
    private final String _password;
    private final Subject _subject;
    private final Map _properties;
    private final SibRaManagedConnectionFactory _managedConnectionFactory;
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaConnectionInfo.class);
    private static final TraceNLS NLS = SibRaUtils.getTraceNls();
    private static final String FFDC_PROBE_1 = "1";
    private static final String FFDC_PROBE_2 = "2";

    SibRaConnectionInfo(final SibRaManagedConnectionFactory factory, final Subject containerSubject, SibRaConnectionRequestInfo requestInfo) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaConnectionInfo", (Object)new Object[]{factory, SibRaUtils.subjectToString(containerSubject), requestInfo});
        }
        this._managedConnectionFactory = factory;
        this._properties = requestInfo.getConnectionProperties();
        if (containerSubject == null) {
            if (requestInfo.getSubject() == null) {
                this._userName = requestInfo.getUserName();
                this._password = requestInfo.getPassword();
                this._subject = null;
            } else {
                this._userName = null;
                this._password = null;
                this._subject = requestInfo.getSubject();
            }
        } else {
            PasswordCredential matchingCredential = (PasswordCredential)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Set<PasswordCredential> credentials = containerSubject.getPrivateCredentials(PasswordCredential.class);
                    PasswordCredential match = null;
                    Iterator<PasswordCredential> iterator = credentials.iterator();
                    while (iterator.hasNext() && match == null) {
                        PasswordCredential credential = iterator.next();
                        if (!factory.equals(credential.getManagedConnectionFactory())) continue;
                        match = credential;
                    }
                    return match;
                }
            });
            if (matchingCredential == null) {
                this._userName = null;
                this._password = null;
                this._subject = containerSubject;
            } else {
                this._userName = matchingCredential.getUserName();
                this._password = String.valueOf(matchingCredential.getPassword());
                this._subject = null;
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaConnectionInfo");
        }
    }

    SICoreConnection createConnection() throws ResourceAdapterInternalException, ResourceException {
        SICoreConnection connection;
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createConnection");
        }
        SICoreConnectionFactory connectionFactory = this._managedConnectionFactory.getCoreFactory();
        try {
            connection = this._subject == null ? connectionFactory.createConnection(this._userName, this._password, this._properties) : connectionFactory.createConnection(this._subject, this._properties);
        }
        catch (SIException exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.ra.impl.SibRaConnectionInfo.createConnection", (String)FFDC_PROBE_1, (Object)this);
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
            }
            throw new ResourceException(NLS.getFormattedMessage("CONNECTION_CREATION_CWSIV0300", new Object[]{exception}, null), (Throwable)exception);
        }
        catch (SIErrorException exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.ra.impl.SibRaConnectionInfo.createConnection", (String)FFDC_PROBE_2, (Object)this);
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
            }
            throw new ResourceException(NLS.getFormattedMessage("CONNECTION_CREATION_CWSIV0300", new Object[]{exception}, null), (Throwable)exception);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createConnection", (Object)connection);
        }
        return connection;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof SibRaConnectionInfo) {
            SibRaConnectionInfo otherConnectionInfo = (SibRaConnectionInfo)other;
            if (SibRaUtils.objectsNotEqual(this._userName, otherConnectionInfo._userName)) {
                return false;
            }
            if (SibRaUtils.objectsNotEqual(this._password, otherConnectionInfo._password)) {
                return false;
            }
            if (SibRaUtils.objectsNotEqual(this._subject, otherConnectionInfo._subject)) {
                return false;
            }
            return !SibRaUtils.objectsNotEqual(this._properties, otherConnectionInfo._properties);
        }
        return false;
    }

    public int hashCode() {
        int hashCode = SibRaUtils.objectHashCode(this._userName);
        hashCode = SibRaUtils.addObjectToHashCode(hashCode, this._password);
        hashCode = SibRaUtils.addObjectToHashCode(hashCode, this._subject);
        hashCode = SibRaUtils.addObjectToHashCode(hashCode, this._properties);
        return hashCode;
    }

    public String toString() {
        StringBuffer buffer = SibRaUtils.startToString(this);
        SibRaUtils.addFieldToString(buffer, "userName", this._userName);
        SibRaUtils.addPasswordFieldToString(buffer, "password", this._password);
        SibRaUtils.addFieldToString(buffer, "subject", SibRaUtils.subjectToString(this._subject));
        SibRaUtils.addFieldToString(buffer, "properties", this._properties);
        SibRaUtils.addFieldToString(buffer, "managedConnectionFactory", this._managedConnectionFactory);
        SibRaUtils.endToString(buffer);
        return buffer.toString();
    }

    public String[] introspectSelf() {
        return new String[]{this.toString()};
    }

    String getUserName() {
        return this._userName;
    }

    String getPassword() {
        return this._password;
    }

    String getBusName() {
        return (String)this._properties.get("busName");
    }

    String getProviderEndpoints() {
        return (String)this._properties.get("remoteServerAddress");
    }

    String getTargetTransportChain() {
        return (String)this._properties.get("targetTransportChain");
    }
}

