/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.jakarta.persistence.internal;

import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.spi.PersistenceProvider;
import jakarta.persistence.spi.PersistenceProviderResolver;
import jakarta.persistence.spi.PersistenceProviderResolverHolder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.WeakHashMap;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class JakartaPersistenceActivator
implements BundleActivator,
PersistenceProviderResolver {
    private final WeakHashMap<ModuleMetaData, List<PersistenceProvider>> providerCache = new WeakHashMap();
    public static final String PERSISTENCE_PROVIDER = "jakarta.persistence.spi.PersistenceProvider";
    private BundleContext ctx = null;
    private ServiceTracker persistenceProviderTracker = null;
    private final Map<String, PersistenceProvider> providers = new WeakHashMap<String, PersistenceProvider>();

    public void start(BundleContext ctx) throws Exception {
        this.ctx = ctx;
        JPAServiceTracker jpaServiceTracker = new JPAServiceTracker();
        this.persistenceProviderTracker = new ServiceTracker(ctx, PERSISTENCE_PROVIDER, (ServiceTrackerCustomizer)jpaServiceTracker);
        this.persistenceProviderTracker.open();
        PersistenceProviderResolverHolder.setPersistenceProviderResolver(this);
    }

    public void stop(BundleContext ctx) throws Exception {
        this.persistenceProviderTracker.close();
        this.persistenceProviderTracker = null;
        PersistenceProviderResolverHolder.setPersistenceProviderResolver(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCachedProviders() {
        Map<Object, Object> map = this.providerCache;
        synchronized (map) {
            this.providerCache.clear();
        }
        map = this.providers;
        synchronized (map) {
            this.providers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PersistenceProvider> getPersistenceProviders() {
        List<PersistenceProvider> nonOSGiProviders = null;
        ModuleMetaData mmd = this.getModuleMetaData();
        if (mmd != null) {
            WeakHashMap<ModuleMetaData, List<PersistenceProvider>> weakHashMap = this.providerCache;
            synchronized (weakHashMap) {
                nonOSGiProviders = this.providerCache.get(mmd);
                if (nonOSGiProviders == null) {
                    nonOSGiProviders = this.findProvidersByClassLoader();
                    this.providerCache.put(mmd, nonOSGiProviders);
                }
            }
        } else {
            nonOSGiProviders = this.findProvidersByClassLoader();
        }
        ArrayList<PersistenceProvider> combinedProviders = new ArrayList<PersistenceProvider>(nonOSGiProviders);
        Map<String, PersistenceProvider> map = this.providers;
        synchronized (map) {
            combinedProviders.addAll(this.providers.values());
        }
        return combinedProviders;
    }

    private ModuleMetaData getModuleMetaData() {
        try {
            return ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData().getModuleMetaData();
        }
        catch (Throwable t) {
            return null;
        }
    }

    private List<PersistenceProvider> findProvidersByClassLoader() {
        ArrayList<PersistenceProvider> nonOSGiProviders = new ArrayList<PersistenceProvider>();
        ClassLoader cl = PrivClassLoader.get(null);
        if (cl == null) {
            cl = PrivClassLoader.get(JakartaPersistenceActivator.class);
        }
        try {
            ServiceLoader<PersistenceProvider> providers = ServiceLoader.load(PersistenceProvider.class, cl);
            Iterator<PersistenceProvider> provider = providers.iterator();
            while (provider.hasNext()) {
                nonOSGiProviders.add(provider.next());
            }
        }
        catch (Exception e) {
            throw new PersistenceException("Failed to load provider from META-INF/services", e);
        }
        return Collections.unmodifiableList(nonOSGiProviders);
    }

    private static class PrivClassLoader
    implements PrivilegedAction<ClassLoader> {
        private final Class<?> c;

        public static ClassLoader get(Class<?> c) {
            PrivClassLoader action = new PrivClassLoader(c);
            if (System.getSecurityManager() != null) {
                return AccessController.doPrivileged(action);
            }
            return action.run();
        }

        private PrivClassLoader(Class<?> c) {
            this.c = c;
        }

        @Override
        public ClassLoader run() {
            if (this.c != null) {
                return this.c.getClassLoader();
            }
            return Thread.currentThread().getContextClassLoader();
        }
    }

    private class JPAServiceTracker
    implements ServiceTrackerCustomizer {
        private JPAServiceTracker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object addingService(ServiceReference sr) {
            PersistenceProvider provider = null;
            try {
                provider = (PersistenceProvider)JakartaPersistenceActivator.this.ctx.getService(sr);
                String name = (String)sr.getProperty(JakartaPersistenceActivator.PERSISTENCE_PROVIDER);
                Map map = JakartaPersistenceActivator.this.providers;
                synchronized (map) {
                    JakartaPersistenceActivator.this.providers.put(name, provider);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return provider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void modifiedService(ServiceReference sr, Object obj) {
            try {
                PersistenceProvider provider = (PersistenceProvider)JakartaPersistenceActivator.this.ctx.getService(sr);
                String name = (String)sr.getProperty(JakartaPersistenceActivator.PERSISTENCE_PROVIDER);
                Map map = JakartaPersistenceActivator.this.providers;
                synchronized (map) {
                    JakartaPersistenceActivator.this.providers.remove(name);
                    JakartaPersistenceActivator.this.providers.put(name, provider);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference sr, Object obj) {
            String name = (String)sr.getProperty(JakartaPersistenceActivator.PERSISTENCE_PROVIDER);
            Map map = JakartaPersistenceActivator.this.providers;
            synchronized (map) {
                JakartaPersistenceActivator.this.providers.remove(name);
            }
        }
    }
}

