/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session.store.cache;

import com.ibm.websphere.ras.annotation.Trivial;
import java.util.Arrays;

@Trivial
public final class TypeConversion {
    public static int bytesToInt(byte[] bytes, int offset) {
        return ((bytes[offset + 3] & 0xFF) << 0) + ((bytes[offset + 2] & 0xFF) << 8) + ((bytes[offset + 1] & 0xFF) << 16) + ((bytes[offset + 0] & 0xFF) << 24);
    }

    public static short bytesToShort(byte[] bytes, int offset) {
        short result = 0;
        for (int i = offset; i < offset + 2; ++i) {
            result = (short)(result << 8);
            result = (short)(result | bytes[i] & 0xFF);
        }
        return result;
    }

    public static long bytesToLong(byte[] bytes, int offset) {
        long result = 0L;
        for (int i = offset; i < offset + 8; ++i) {
            result <<= 8;
            result |= (long)bytes[i] & 0xFFL;
        }
        return result;
    }

    public static char bytesToChar(byte[] bytes, int offset) {
        char result = '\u0000';
        for (int i = offset; i < offset + 2; ++i) {
            result = (char)(result << 8);
            result = (char)(result | bytes[i] & 0xFF);
        }
        return result;
    }

    public static void charToBytes(char value, byte[] bytes, int offset) {
        for (int i = offset + 1; i >= offset; --i) {
            bytes[i] = (byte)value;
            value = (char)(value >> 8);
        }
    }

    public static void intToBytes(int value, byte[] bytes, int offset) {
        bytes[offset + 3] = (byte)(value >>> 0);
        bytes[offset + 2] = (byte)(value >>> 8);
        bytes[offset + 1] = (byte)(value >>> 16);
        bytes[offset + 0] = (byte)(value >>> 24);
    }

    public static void shortToBytes(short value, byte[] bytes, int offset) {
        for (int i = offset + 1; i >= offset; --i) {
            bytes[i] = (byte)value;
            value = (short)(value >> 8);
        }
    }

    public static void longToBytes(long value, byte[] bytes, int offset) {
        for (int i = offset + 7; i >= offset; --i) {
            bytes[i] = (byte)value;
            value >>= 8;
        }
    }

    public static long varIntBytesToLong(byte[] bytes, int offset) {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = bytes[offset++];
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new IllegalStateException("Varint representation is invalid or exceeds 64-bit value");
    }

    public static int varIntBytesToInt(byte[] bytes, int offset) {
        byte tmp;
        if ((tmp = bytes[offset++]) >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        if ((tmp = bytes[offset++]) >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            if ((tmp = bytes[offset++]) >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                if ((tmp = bytes[offset++]) >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    tmp = bytes[offset++];
                    result |= tmp << 28;
                    if (tmp < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if (bytes[offset++] < 0) continue;
                            return result;
                        }
                        throw new IllegalStateException("Varint representation is invalid or exceeds 32-bit value");
                    }
                }
            }
        }
        return result;
    }

    public static int writeLongAsVarIntBytes(long v, byte[] bytes, int offest) {
        int pos = offest;
        while (true) {
            if ((v & 0xFFFFFFFFFFFFFF80L) == 0L) {
                bytes[pos++] = (byte)v;
                return pos;
            }
            bytes[pos++] = (byte)(v & 0x7FL | 0x80L);
            v >>>= 7;
        }
    }

    public static int writeIntAsVarIntBytes(int intVal, byte[] bytes, int offset) {
        int pos = offset;
        int v = intVal;
        if ((v & 0xFFFFFF80) == 0) {
            bytes[pos++] = (byte)v;
            return 1 + offset;
        }
        while (true) {
            if ((v & 0xFFFFFF80) == 0) {
                bytes[pos++] = (byte)v;
                return pos;
            }
            bytes[pos++] = (byte)(v & 0x7F | 0x80);
            v >>>= 7;
        }
    }

    public static String limitedBytesToString(byte[] bytes) {
        if (bytes.length <= 1000) {
            return Arrays.toString(bytes);
        }
        byte[] firstBytes = new byte[1000];
        System.arraycopy(bytes, 0, firstBytes, 0, 1000);
        return Arrays.toString(firstBytes);
    }
}

