/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.cdi;

import com.ibm.tx.jta.TransactionSynchronizationRegistryFactory;
import com.ibm.tx.jta.impl.UserTransactionImpl;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.Transaction.TransactionScopeDestroyer;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.context.Destroyed;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.context.spi.AlterableContext;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.PassivationCapable;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.transaction.TransactionScoped;
import jakarta.transaction.TransactionSynchronizationRegistry;
import jakarta.transaction.UserTransaction;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class AbstractTransactionContext
implements AlterableContext,
TransactionScopeDestroyer {
    private final UserTransaction ut = UserTransactionImpl.instance();
    private final TransactionSynchronizationRegistry tsr = TransactionSynchronizationRegistryFactory.getTransactionSynchronizationRegistry();
    private final String TXC_STORAGE_ID = "cdi_TXC";
    private static final TraceComponent tc = Tr.register(AbstractTransactionContext.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static InitializedQualifier initializedQualifier = new InitializedQualifier(){
        static final long serialVersionUID = 4740156256096884515L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public Class value() {
            return TransactionScoped.class;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.tx.jta.cdi.AbstractTransactionContext$1", 1.class, null, null);
        }
    };
    private static DestroyedQualifier destroyedQualifier = new DestroyedQualifier(){
        static final long serialVersionUID = -2828584993179685754L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public Class value() {
            return TransactionScoped.class;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.tx.jta.cdi.AbstractTransactionContext$2", 2.class, null, null);
        }
    };
    private final BeanManager beanManager;
    static final long serialVersionUID = 4341865493711504298L;

    public AbstractTransactionContext(BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    @ManualTrace
    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"get", (Object[])new Object[]{contextual, creationalContext, this});
        }
        this.performChecks(contextual);
        Map<String, InstanceAndContext<?>> storage = this.getStorage(true);
        InstanceAndContext<Object> data = this.getByContextual(storage, contextual);
        if (data != null) {
            return data.instance;
        }
        if (creationalContext == null) {
            return null;
        }
        Object t = contextual.create(creationalContext);
        String contextId = ((PassivationCapable)contextual).getId();
        data = new InstanceAndContext<Object>(contextual, creationalContext, t);
        storage.put(contextId, data);
        this.fireEvent(this.beanManager, "Initializing transaction context", new Annotation[]{initializedQualifier});
        this.tsr.putResource((Object)"transactionScopeDestroyer", (Object)this);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"get", (Object)t);
        }
        return (T)t;
    }

    public abstract void fireEvent(BeanManager var1, Object var2, Annotation ... var3);

    public Class<? extends Annotation> getScope() {
        return TransactionScoped.class;
    }

    @ManualTrace
    public boolean isActive() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isActive", (Object[])new Object[]{this});
        }
        boolean isActive = false;
        try {
            switch (this.ut.getStatus()) {
                case 0: 
                case 1: 
                case 2: 
                case 5: 
                case 7: 
                case 8: 
                case 9: {
                    isActive = true;
                    break;
                }
                default: {
                    isActive = false;
                    break;
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.tx.jta.cdi.AbstractTransactionContext", (String)"148", (Object)this, (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isActive", (Object)isActive);
        }
        return isActive;
    }

    @ManualTrace
    public void destroy(Contextual<?> contextual) {
        Map<String, InstanceAndContext<?>> storage;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroy(Contextual)", (Object[])new Object[]{contextual, this});
        }
        if ((storage = this.getStorage(false)) != null) {
            String contextId = AbstractTransactionContext.getContextualId(contextual);
            InstanceAndContext<?> data = this.getByContextual(storage, contextual);
            if (data != null) {
                storage.remove(contextId);
                this.destroyItem(contextId, data);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroy(Contextual)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroy", (Object[])new Object[]{this});
        }
        if (this.tsr.getTransactionKey() != null) {
            Map<String, InstanceAndContext<?>> storage = this.getStorage(false);
            if (storage != null) {
                try {
                    for (InstanceAndContext<?> entry : storage.values()) {
                        String id = AbstractTransactionContext.getContextualId(entry.context);
                        this.destroyItem(id, entry);
                    }
                }
                finally {
                    this.tsr.putResource((Object)"cdi_TXC", null);
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Tran synchronization registry not available, skipping destroy", (Object[])new Object[0]);
        }
        this.fireEvent(this.beanManager, "Destroying transaction context", new Annotation[]{destroyedQualifier});
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    @ManualTrace
    private void performChecks(Contextual<?> contextual) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"performChecks", (Object[])new Object[]{this});
        }
        if (!this.isActive()) {
            throw new ContextNotActiveException();
        }
        if (contextual == null) {
            throw new IllegalArgumentException("Contextual parameter should not be null");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"performChecks");
        }
    }

    private <T> InstanceAndContext<T> getByContextual(Map<String, InstanceAndContext<?>> storage, Contextual<T> contextual) {
        String contextId = AbstractTransactionContext.getContextualId(contextual);
        return storage.get(contextId);
    }

    private static String getContextualId(Contextual<?> contextual) {
        return ((PassivationCapable)contextual).getId();
    }

    @ManualTrace
    private <T> Map<String, InstanceAndContext<?>> getStorage(boolean create) {
        HashMap storage;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getStorage", (Object[])new Object[]{create, this});
        }
        if ((storage = (HashMap)this.tsr.getResource((Object)"cdi_TXC")) == null && create) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No existing storage for transaction context, creating", (Object[])new Object[0]);
            }
            storage = new HashMap();
            this.tsr.putResource((Object)"cdi_TXC", storage);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getStorage");
        }
        return storage;
    }

    @ManualTrace
    private <T> void destroyItem(String contextId, InstanceAndContext<T> item) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroyItem", (Object[])new Object[]{item, this});
        }
        item.context.destroy(item.instance, item.creationalContext);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroyItem");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static abstract class InitializedQualifier
    extends AnnotationLiteral<Initialized>
    implements Initialized {
        static final long serialVersionUID = 6067091545607361819L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.tx.jta.cdi.AbstractTransactionContext$InitializedQualifier", InitializedQualifier.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static abstract class DestroyedQualifier
    extends AnnotationLiteral<Destroyed>
    implements Destroyed {
        static final long serialVersionUID = -8571465283336914871L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.tx.jta.cdi.AbstractTransactionContext$DestroyedQualifier", DestroyedQualifier.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class InstanceAndContext<T> {
        Contextual<T> context;
        CreationalContext<T> creationalContext;
        T instance;
        static final long serialVersionUID = 5906753757959247357L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public InstanceAndContext(Contextual<T> context, CreationalContext<T> creationalContext, T instance) {
            this.context = context;
            this.creationalContext = creationalContext;
            this.instance = instance;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[").append(AbstractTransactionContext.getContextualId(this.context)).append(", ");
            sb.append(this.creationalContext.toString()).append(", ");
            sb.append(this.instance.toString()).append("]");
            return sb.toString();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.tx.jta.cdi.AbstractTransactionContext$InstanceAndContext", InstanceAndContext.class, null, null);
        }
    }
}

