/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.support;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Map;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.UrlUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.WSDLGetInterceptor;
import org.apache.cxf.frontend.WSDLGetOutInterceptor;
import org.apache.cxf.frontend.WSDLGetUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.OutgoingChainInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LibertyJaxWsCompatibleWSDLGetInterceptor
extends WSDLGetInterceptor {
    private Interceptor<Message> wsdlGetOutInterceptor = WSDLGetOutInterceptor.INSTANCE;
    private static final String TRANSFORM_SKIP = "transform.skip";
    private static final TraceComponent tc = Tr.register(LibertyJaxWsCompatibleWSDLGetInterceptor.class, (String)"JaxWsClientContainer", (String)"com.ibm.ws.jaxws.clientcontainer.internal.resources.JaxWsClientContainerMessages");
    private static final Document noWSDLDoc = DOMUtils.createDocument();
    private final String implBeanClazzName;
    private final String wsdlLocation;
    private final boolean wsdlLoationExisted;
    private final Document noWSDLLocationDoc;
    static final long serialVersionUID = 3845858470835173039L;

    public LibertyJaxWsCompatibleWSDLGetInterceptor(String implBeanClazzName, String wsdlLocation, boolean wsdlLoationExisted) {
        this.implBeanClazzName = implBeanClazzName;
        this.wsdlLocation = wsdlLocation;
        this.wsdlLoationExisted = wsdlLoationExisted;
        this.noWSDLLocationDoc = DOMUtils.createDocument();
        if (!wsdlLoationExisted) {
            Element root = this.noWSDLLocationDoc.createElement("Error");
            root.setTextContent(Tr.formatMessage((TraceComponent)tc, (String)"error.no.wsdl.find", (Object[])new Object[]{wsdlLocation, implBeanClazzName}));
            this.noWSDLLocationDoc.appendChild(root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document getDocument(WSDLGetUtils utils, Message message, String base, Map<String, String> params, String ctxUri) {
        Endpoint endpoint = message.getExchange().getEndpoint();
        synchronized (endpoint) {
            return utils.getDocument(message, base, params, ctxUri, message.getExchange().getEndpoint().getEndpointInfo());
        }
    }

    public void handleMessage(Message message) throws Fault {
        Map map;
        String method = (String)message.get((Object)"org.apache.cxf.request.method");
        String query = (String)message.get((Object)Message.QUERY_STRING);
        if (!"GET".equals(method) || StringUtils.isEmpty((String)query)) {
            return;
        }
        String baseUri = (String)message.get((Object)"org.apache.cxf.request.url");
        String ctx = (String)message.get((Object)Message.PATH_INFO);
        WSDLGetUtils utils = (WSDLGetUtils)message.getContextualProperty(WSDLGetUtils.class.getName());
        if (utils == null) {
            utils = new WSDLGetUtils();
            message.put(WSDLGetUtils.class, (Object)utils);
        }
        if (this.isRecognizedQuery(map = UrlUtils.parseQueryString((String)query))) {
            Document doc = this.getDocument(utils, message, baseUri, map, ctx);
            Endpoint e = message.getExchange().getEndpoint();
            MessageImpl mout = new MessageImpl();
            mout.setExchange(message.getExchange());
            mout = e.getBinding().createMessage((Message)mout);
            mout.setInterceptorChain(OutgoingChainInterceptor.getOutInterceptorChain((Exchange)message.getExchange()));
            message.getExchange().setOutMessage((Message)mout);
            mout.put((Object)DOCUMENT_HOLDER, (Object)doc);
            mout.put((Object)"Content-Type", (Object)"text/xml");
            mout.put((Object)Message.RESPONSE_CODE, (Object)404);
            this.cleanUpOutInterceptors((Message)mout);
            mout.getInterceptorChain().add(this.wsdlGetOutInterceptor);
            message.getExchange().put((Object)TRANSFORM_SKIP, (Object)Boolean.TRUE);
            message.getInterceptorChain().doInterceptStartingAt(message, OutgoingChainInterceptor.class.getName());
        }
    }

    private boolean isRecognizedQuery(Map<String, String> map) {
        return map.containsKey("wsdl") || map.containsKey("xsd");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        Element root = noWSDLDoc.createElement("Error");
        root.setTextContent(Tr.formatMessage((TraceComponent)tc, (String)"error.no.wsdl.per.specification", (Object[])new Object[0]));
        noWSDLDoc.appendChild(root);
    }
}

