/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.ejb;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxws.metadata.EndpointInfo;
import com.ibm.ws.jaxws.metadata.HandlerInfo;
import com.ibm.ws.jaxws.metadata.JaxWsModuleInfo;
import com.ibm.ws.jaxws.metadata.JaxWsModuleMetaData;
import com.ibm.ws.jaxws.metadata.JaxWsServerMetaData;
import com.ibm.ws.jaxws.support.JaxWsMetaDataManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.ejbcontainer.WSEJBHandlerResolver;
import java.util.ArrayList;
import java.util.List;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class EJBHandlerResolver
implements WSEJBHandlerResolver {
    private static final TraceComponent tc = Tr.register(EJBHandlerResolver.class, (String)"JaxWsEJB", (String)"com.ibm.ws.jaxws.ejb.internal.resources.JaxWsEJBMessages");
    static final long serialVersionUID = 8539805581445672797L;

    /*
     * WARNING - void declaration
     */
    public List<Class<?>> retrieveJAXWSHandlers(J2EEName j2eeName) {
        JaxWsModuleMetaData jaxWsModuleMetaData = JaxWsMetaDataManager.getJaxWsModuleMetaData();
        if (jaxWsModuleMetaData == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to get the JaxWsModuleMetaData from current invocation context while querying EJBHandler", (Object[])new Object[0]);
            }
            return null;
        }
        JaxWsModuleInfo jaxWsModuleInfo = null;
        try {
            Container containerToAdapt = jaxWsModuleMetaData.getModuleContainer();
            jaxWsModuleInfo = (JaxWsModuleInfo)containerToAdapt.adapt(JaxWsModuleInfo.class);
        }
        catch (UnableToAdaptException containerToAdapt) {
            void e;
            FFDCFilter.processException((Throwable)containerToAdapt, (String)"com.ibm.ws.jaxws.ejb.EJBHandlerResolver", (String)"56", (Object)this, (Object[])new Object[]{j2eeName});
            throw new IllegalStateException((Throwable)e);
        }
        if (jaxWsModuleInfo == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to get the JaxWsModuleInfo from current module {0} while querying EJBHandler", (Object[])new Object[]{jaxWsModuleMetaData.getModuleInfo().getName()});
            }
            return null;
        }
        JaxWsServerMetaData jaxwsServerMetaData = jaxWsModuleMetaData.getServerMetaData();
        String endpointName = jaxwsServerMetaData.retrieveEndpointName(j2eeName);
        if (endpointName == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No endpoint with j2eeName {0} exists in module {1}", (Object[])new Object[]{j2eeName, jaxWsModuleMetaData.getModuleInfo().getName()});
            }
            return null;
        }
        EndpointInfo endpointInfo = jaxWsModuleInfo.getEndpointInfo(endpointName);
        if (endpointInfo == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No endpoint with endpoint name {0} exists in module {1}", (Object[])new Object[]{endpointName, jaxWsModuleMetaData.getModuleInfo().getName()});
            }
            return null;
        }
        ClassLoader appContextClassLoader = jaxWsModuleMetaData.getAppContextClassLoader();
        List handlerInfos = endpointInfo.getHandlerChainsInfo().getAllHandlerInfos();
        ArrayList handlerClasses = new ArrayList(handlerInfos.size());
        for (HandlerInfo handlerInfo : handlerInfos) {
            String handlerClassName = handlerInfo.getHandlerClass();
            try {
                Class<?> handlerClass = appContextClassLoader.loadClass(handlerClassName);
                handlerClasses.add(handlerClass);
            }
            catch (ClassNotFoundException handlerClass) {
                void e;
                FFDCFilter.processException((Throwable)handlerClass, (String)"com.ibm.ws.jaxws.ejb.EJBHandlerResolver", (String)"95", (Object)this, (Object[])new Object[]{j2eeName});
                Tr.warning((TraceComponent)tc, (String)"warn.could.not.find.handler", (Object[])new Object[]{handlerClassName, e.getMessage()});
            }
        }
        return handlerClasses;
    }
}

