/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.common.CommsByteBuffer;
import com.ibm.ws.sib.comms.server.ServerJFapCommunicator;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSetChangeCallback;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;

public class ServerConsumerMonitorListener
extends ServerJFapCommunicator
implements ConsumerSetChangeCallback {
    private static String CLASS_NAME = ServerConsumerMonitorListener.class.getName();
    private static final TraceComponent tc = SibTr.register(ServerConsumerMonitorListener.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private final short consumerMonitorListenerID;
    private final short connectionObjectId;

    public ServerConsumerMonitorListener(short id, short connectionObjectId, Conversation conversation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"<init>", (Object)("id=" + id + ",convId=" + connectionObjectId + ",conversation=" + conversation));
        }
        this.consumerMonitorListenerID = id;
        this.connectionObjectId = connectionObjectId;
        this.setConversation(conversation);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"<init>");
        }
    }

    public void consumerSetChange(boolean isEmpty) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"consumerSetChange", (Object)new Object[]{isEmpty});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Sending ConsumerSetChangeCallback callback for: convId=" + this.connectionObjectId + ",id=" + this.consumerMonitorListenerID));
        }
        CommsByteBuffer request = this.getCommsByteBuffer();
        request.putShort(this.connectionObjectId);
        request.putShort(this.consumerMonitorListenerID);
        request.putBoolean(isEmpty);
        try {
            this.jfapSend(request, 133, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD);
        }
        catch (SIConnectionLostException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".consumerSetChange"), (String)"3-033-0001", (Object)((Object)this));
        }
        catch (SIConnectionDroppedException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".consumerSetChange"), (String)"3-033-0002", (Object)((Object)this));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"consumerSetChange");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.comms.server.impl/src/com/ibm/ws/sib/comms/server/clientsupport/ServerConsumerMonitorListener.java, SIB.comms, WASX.SIB");
        }
    }
}

