/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.common.CommsByteBuffer;
import com.ibm.ws.sib.comms.common.CommsByteBufferPool;
import com.ibm.ws.sib.comms.common.CommsUtils;
import com.ibm.ws.sib.comms.server.CommsServerByteBuffer;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.IdToTransactionTable;
import com.ibm.ws.sib.comms.server.ServerLinkLevelState;
import com.ibm.ws.sib.comms.server.clientsupport.CATConnection;
import com.ibm.ws.sib.comms.server.clientsupport.CATMainConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.ChunkedMessageWrapper;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATHelper;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATProducer;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.JFapByteBuffer;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.impl.JsMessageFactory;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.DestinationConfiguration;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.Distribution;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class StaticCATDestination {
    private static String CLASS_NAME = StaticCATDestination.class.getName();
    private static CommsByteBufferPool poolManager = CommsByteBufferPool.getInstance();
    private static final TraceComponent tc = SibTr.register(StaticCATDestination.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");

    static void rcvCreateTempDestination(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvCreateTempDestination", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool, "" + partOfExchange});
        }
        ConversationState convState = (ConversationState)conversation.getAttachment();
        short connectionObjectID = request.getShort();
        SICoreConnection connection = ((CATConnection)convState.getObject(connectionObjectID)).getSICoreConnection();
        short dist = request.getShort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"SICoreConnection Id:", (Object)connectionObjectID);
            SibTr.debug((TraceComponent)tc, (String)"Distribution", (Object)dist);
        }
        Distribution distribution = Distribution.getDistribution((int)dist);
        String destinationNamePrefix = request.getString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Destination prefix;", (Object)destinationNamePrefix);
        }
        try {
            JsDestinationAddress destAddress = (JsDestinationAddress)connection.createTemporaryDestination(distribution, destinationNamePrefix);
            CommsByteBuffer reply = poolManager.allocate();
            reply.putSIDestinationAddress((SIDestinationAddress)destAddress, conversation.getHandshakeProperties().getFapLevel());
            try {
                conversation.send((JFapByteBuffer)reply, 193, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvCreateTempDestination"), (String)"3-007-0001");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2022", (Object)((Object)e));
            }
        }
        catch (SINotAuthorizedException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, null, conversation, requestNumber);
        }
        catch (SIException e) {
            if (!convState.hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvCreateTempDestination"), (String)"3-007-0002");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, "3-007-0002", conversation, requestNumber);
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvCreateTempDestination");
        }
    }

    static void rcvDeleteTempDestination(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvDeleteTempDestination", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool, "" + partOfExchange});
        }
        ConversationState convState = (ConversationState)conversation.getAttachment();
        short connectionObjectID = request.getShort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"SICoreConnection Id:", (Object)("" + connectionObjectID));
        }
        SICoreConnection connection = ((CATConnection)convState.getObject(connectionObjectID)).getSICoreConnection();
        try {
            SIDestinationAddress destAddress;
            block16: {
                ConsumerSession cacheSession;
                destAddress = request.getSIDestinationAddress(conversation.getHandshakeProperties().getFapLevel());
                CATMainConsumer cacheConsumer = convState.getCachedConsumer();
                if (cacheConsumer != null && (cacheSession = cacheConsumer.getConsumerSession()) != null && cacheSession.getDestinationAddress().equals(destAddress)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"The destination is currently held open by us");
                    }
                    try {
                        cacheSession.close();
                        convState.setCachedConsumer(null);
                    }
                    catch (SIException e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block16;
                        SibTr.debug((TraceComponent)tc, (String)"Unable to close cached consumer", (Object)((Object)e));
                    }
                }
            }
            connection.deleteTemporaryDestination(destAddress);
            try {
                conversation.send((JFapByteBuffer)poolManager.allocate(), 194, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvDeleteTempDestination"), (String)"3-007-0003");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2022", (Object)((Object)e));
            }
        }
        catch (SINotAuthorizedException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, null, conversation, requestNumber);
        }
        catch (SIException e) {
            if (!convState.hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvDeleteTempDestination"), (String)"3-007-0004");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, "3-007-0004", conversation, requestNumber);
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvDeleteTempDestination");
        }
    }

    /*
     * WARNING - void declaration
     */
    static void rcvGetDestinationConfiguration(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvGetDestinationConfiguration", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool, "" + partOfExchange});
        }
        ConversationState convState = (ConversationState)conversation.getAttachment();
        short connectionObjectID = request.getShort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"SICoreConnection Id:", (Object)("" + connectionObjectID));
        }
        SICoreConnection connection = ((CATConnection)convState.getObject(connectionObjectID)).getSICoreConnection();
        try {
            SIDestinationAddress destAddress = request.getSIDestinationAddress(conversation.getHandshakeProperties().getFapLevel());
            DestinationConfiguration dc = connection.getDestinationConfiguration(destAddress);
            int defaultPriority = dc.getDefaultPriority();
            int maxFailedDeliveries = dc.getMaxFailedDeliveries();
            short flags = 0;
            if (dc.isProducerQOSOverrideEnabled()) {
                flags = (short)(flags | 1);
            }
            if (dc.isReceiveAllowed()) {
                flags = (short)(flags | 2);
            }
            if (dc.isReceiveExclusive()) {
                flags = (short)(flags | 4);
            }
            if (dc.isSendAllowed()) {
                flags = (short)(flags | 8);
            }
            if (conversation.getHandshakeProperties().getFapLevel() >= 5 && dc.isStrictOrderingRequired()) {
                flags = (short)(flags | 0x10);
            }
            Reliability reliability = dc.getDefaultReliability();
            short reliabilityShort = (short)reliability.toInt();
            Reliability maxReliability = dc.getMaxReliability();
            short maxReliabilityShort = (short)maxReliability.toInt();
            DestinationType destType = dc.getDestinationType();
            short destinationTypeShort = (short)destType.toInt();
            CommsByteBuffer reply = poolManager.allocate();
            reply.putInt(defaultPriority);
            reply.putInt(maxFailedDeliveries);
            reply.putShort(reliabilityShort);
            reply.putShort(maxReliabilityShort);
            reply.putShort(destinationTypeShort);
            reply.putShort(flags);
            reply.putString(dc.getUUID());
            reply.putString(dc.getDescription());
            reply.putString(dc.getExceptionDestination());
            reply.putString(dc.getName());
            reply.putSIDestinationAddress(dc.getReplyDestination(), conversation.getHandshakeProperties().getFapLevel());
            try {
                int n;
                Map context = dc.getDestinationContext();
                HashMap<String, String> stringOnlyContext = new HashMap<String, String>();
                if (context != null) {
                    Set entrySet = context.entrySet();
                    for (Map.Entry entry : entrySet) {
                        String string = (String)entry.getKey();
                        Object value = entry.getValue();
                        if (value instanceof String) {
                            stringOnlyContext.put(string, (String)value);
                            continue;
                        }
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        SibTr.debug((TraceComponent)tc, (String)"Absorbing non-string property.", (Object)new Object[]{string, value});
                    }
                }
                int numberOfItems = stringOnlyContext.size();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Adding " + numberOfItems + " name / value item(s)"));
                }
                reply.putShort(numberOfItems);
                if (numberOfItems > 0) {
                    Set stringOnlyEntrySet = stringOnlyContext.entrySet();
                    for (Map.Entry entry : stringOnlyEntrySet) {
                        reply.putString((String)entry.getKey());
                        reply.putString((String)entry.getValue());
                    }
                }
                SIDestinationAddress[] frp = dc.getDefaultForwardRoutingPath();
                boolean bl = false;
                if (frp != null) {
                    n = frp.length;
                }
                reply.putShort(n);
                if (n > 0) {
                    void var25_37;
                    boolean bl2 = false;
                    while (var25_37 < frp.length) {
                        reply.putSIDestinationAddress(frp[var25_37], conversation.getHandshakeProperties().getFapLevel());
                        ++var25_37;
                    }
                }
                try {
                    conversation.send((JFapByteBuffer)reply, 229, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvGetDestinationConfiguration"), (String)"3-014-0001");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)sIException.getMessage(), (Object)((Object)sIException));
                    }
                    SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2022", (Object)((Object)sIException));
                }
            }
            catch (ClassCastException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvGetDestinationConfiguration"), (String)"3-014-0002");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)e);
                }
                StaticCATHelper.sendExceptionToClient(e, "3-014-0002", conversation, requestNumber);
            }
        }
        catch (SINotAuthorizedException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, null, conversation, requestNumber);
        }
        catch (SIException e) {
            if (!convState.hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvGetDestinationConfiguration"), (String)"3-014-0003");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, "3-014-0003", conversation, requestNumber);
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvGetDestinationConfiguration");
        }
    }

    static void rcvSendToExceptionDest(CommsServerByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvSendToExceptionDest", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool, "" + partOfExchange});
        }
        ServerLinkLevelState linkState = (ServerLinkLevelState)conversation.getLinkLevelAttachment();
        ConversationState convState = (ConversationState)conversation.getAttachment();
        boolean optimizedTx = CommsUtils.requiresOptimizedTransaction((Conversation)conversation);
        try {
            short connectionObjId = request.getShort();
            int txId = request.getSITransactionId(connectionObjId, linkState, optimizedTx);
            SIDestinationAddress destAddr = request.getSIDestinationAddress(conversation.getHandshakeProperties().getFapLevel());
            int reason = request.getInt();
            String alternateUser = request.getString();
            int messageLength = (int)request.peekLong();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"ConnectionObjectId", (Object)("" + connectionObjId));
                SibTr.debug((TraceComponent)tc, (String)"DestinationAddress", (Object)destAddr);
                SibTr.debug((TraceComponent)tc, (String)"Reason", (Object)("" + reason));
                SibTr.debug((TraceComponent)tc, (String)"TransactionId", (Object)("" + txId));
                SibTr.debug((TraceComponent)tc, (String)"MessageLength", (Object)("" + messageLength));
                SibTr.debug((TraceComponent)tc, (String)"AlternateUser", (Object)alternateUser);
            }
            SIBusMessage jsMessage = request.getMessage(null);
            String[] inserts = null;
            int numberOfInserts = request.getShort();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Number of inserts", (Object)("" + numberOfInserts));
            }
            if (numberOfInserts != 0) {
                inserts = new String[numberOfInserts];
                for (int x = 0; x < numberOfInserts; ++x) {
                    inserts[x] = request.getString();
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    SibTr.debug((TraceComponent)tc, (String)("Insert[" + x + "] = " + inserts[x]));
                }
            }
            SITransaction tran = linkState.getTransactionTable().get(txId);
            SICoreConnection connection = ((CATConnection)convState.getObject(connectionObjId)).getSICoreConnection();
            if (tran != IdToTransactionTable.INVALID_TRANSACTION) {
                connection.sendToExceptionDestination(destAddr, jsMessage, reason, inserts, tran, alternateUser);
            }
            try {
                conversation.send((JFapByteBuffer)poolManager.allocate(), 237, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvSendToExceptionDest"), (String)"3-014-0004");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2022", (Object)((Object)e));
            }
        }
        catch (SINotAuthorizedException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, null, conversation, requestNumber);
        }
        catch (SIException e) {
            if (!convState.hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvSendToExceptionDest"), (String)"3-014-0005");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, "3-014-0005", conversation, requestNumber);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvSendToExceptionDest"), (String)"3-014-0006");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)e);
            }
            StaticCATHelper.sendExceptionToClient(e, "3-014-0006", conversation, requestNumber);
        }
        if (allocatedFromBufferPool) {
            request.release();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvSendToExceptionDest");
        }
    }

    static void rcvSendChunkedToExceptionDest(CommsServerByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        boolean last;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvSendChunkedToExceptionDest", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool, "" + partOfExchange});
        }
        ServerLinkLevelState linkState = (ServerLinkLevelState)conversation.getLinkLevelAttachment();
        ConversationState convState = (ConversationState)conversation.getAttachment();
        boolean txOptimized = CommsUtils.requiresOptimizedTransaction((Conversation)conversation);
        ChunkedMessageWrapper wrapper = null;
        short connectionObjectId = request.getShort();
        int transactionId = request.getSITransactionId(connectionObjectId, linkState, txOptimized);
        byte flags = request.get();
        boolean first = (flags & 1) == 1;
        boolean bl = last = (flags & 4) == 4;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"connectionObjectId", (Object)connectionObjectId);
            SibTr.debug((TraceComponent)tc, (String)"transactionId", (Object)transactionId);
            SibTr.debug((TraceComponent)tc, (String)"flags", (Object)flags);
        }
        long wrapperId = StaticCATProducer.getWrapperId(connectionObjectId, (short)0, transactionId);
        if (first) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"This is the first chunk of data");
            }
            SIDestinationAddress destAddr = request.getSIDestinationAddress(conversation.getHandshakeProperties().getFapLevel());
            int reason = request.getInt();
            String alternateUser = request.getString();
            Object[] inserts = null;
            int numberOfInserts = request.getShort();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Number of inserts", (Object)("" + numberOfInserts));
            }
            if (numberOfInserts != 0) {
                inserts = new String[numberOfInserts];
                for (int x = 0; x < numberOfInserts; ++x) {
                    inserts[x] = request.getString();
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    SibTr.debug((TraceComponent)tc, (String)("Insert[" + x + "] = " + (String)inserts[x]));
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"DestinationAddress", (Object)destAddr);
                SibTr.debug((TraceComponent)tc, (String)"Reason", (Object)("" + reason));
                SibTr.debug((TraceComponent)tc, (String)"AlternateUser", (Object)alternateUser);
                SibTr.debug((TraceComponent)tc, (String)"Message Inserts", (Object)Arrays.toString(inserts));
            }
            SICoreConnection connection = ((CATConnection)convState.getObject(connectionObjectId)).getSICoreConnection();
            SITransaction siTran = linkState.getTransactionTable().get(transactionId);
            wrapper = new ChunkedMessageWrapper(siTran, connection, destAddr, reason, alternateUser, (String[])inserts);
            convState.putChunkedMessageWrapper(wrapperId, wrapper);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Appending to chunks already collected");
            }
            wrapper = convState.getChunkedMessageWrapper(wrapperId);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Appending to wrapper: ", (Object)wrapper);
            }
        }
        if (wrapper == null) {
            SIErrorException e = new SIErrorException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.comms.CWSICMessages", (String)"CHUNK_WRAPPER_NULL_SICO2165", null, null));
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvSendChunkedToExceptionDest"), (String)"3-014-0007", (Object)("" + wrapperId));
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Chunked message wrapper is null!");
            }
            throw e;
        }
        wrapper.addDataSlice(request.getDataSlice());
        if (last) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"This is the last chunk - sending message");
            }
            convState.removeChunkedMessageWrapper(wrapperId);
            try {
                JsMessage sibMessage = JsMessageFactory.getInstance().createInboundJsMessage(wrapper.getMessageData());
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Sending exception message - " + sibMessage));
                    SibTr.debug((TraceComponent)tc, (String)("Destination: " + wrapper.getDestinationAddress()));
                    SibTr.debug((TraceComponent)tc, (String)("Discriminator: " + sibMessage.getDiscriminator()));
                    SibTr.debug((TraceComponent)tc, (String)("Reliability: " + sibMessage.getReliability()));
                }
                if (wrapper.getTransaction() != IdToTransactionTable.INVALID_TRANSACTION) {
                    wrapper.getConnection().sendToExceptionDestination(wrapper.getDestinationAddress(), (SIBusMessage)sibMessage, wrapper.getReason(), wrapper.getMessageInserts(), wrapper.getTransaction(), wrapper.getAlternateUser());
                }
                try {
                    conversation.send((JFapByteBuffer)poolManager.allocate(), 252, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
                }
                catch (SIException e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvSendChunkedToExceptionDest"), (String)"3-014-0008");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                    }
                    SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2022", (Object)((Object)e));
                }
            }
            catch (SINotAuthorizedException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
                StaticCATHelper.sendExceptionToClient(e, null, conversation, requestNumber);
            }
            catch (SIException e) {
                if (!convState.hasMETerminated()) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvSendChunkedToExceptionDest"), (String)"3-014-0009");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
                StaticCATHelper.sendExceptionToClient(e, "3-014-0009", conversation, requestNumber);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvSendChunkedToExceptionDest"), (String)"3-014-0010");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)e);
                }
                StaticCATHelper.sendExceptionToClient(e, "3-014-0010", conversation, requestNumber);
            }
        }
        if (allocatedFromBufferPool) {
            request.release();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvSendChunkedToExceptionDest");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.comms.server.impl/src/com/ibm/ws/sib/comms/server/clientsupport/StaticCATDestination.java, SIB.comms, WASX.SIB, aa1225.01 1.71");
        }
    }
}

