/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.server.impl;

import com.ibm.websphere.channelfw.ChainData;
import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.channelfw.ChannelFactoryData;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.jfapchannel.AcceptListener;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationMetaData;
import com.ibm.ws.sib.jfapchannel.ConversationReceiveListener;
import com.ibm.ws.sib.jfapchannel.Dispatchable;
import com.ibm.ws.sib.jfapchannel.MetaDataProvider;
import com.ibm.ws.sib.jfapchannel.buffer.WsByteBuffer;
import com.ibm.ws.sib.jfapchannel.framework.FrameworkException;
import com.ibm.ws.sib.jfapchannel.framework.NetworkConnection;
import com.ibm.ws.sib.jfapchannel.framework.NetworkConnectionContext;
import com.ibm.ws.sib.jfapchannel.impl.Connection;
import com.ibm.ws.sib.jfapchannel.impl.ConversationImpl;
import com.ibm.ws.sib.jfapchannel.richclient.framework.impl.CFWNetworkConnection;
import com.ibm.ws.sib.jfapchannel.richclient.framework.impl.CFWNetworkConnectionContext;
import com.ibm.ws.sib.jfapchannel.richclient.impl.ConversationMetaDataImpl;
import com.ibm.ws.sib.jfapchannel.server.impl.InboundConnection;
import com.ibm.ws.sib.jfapchannel.server.impl.ServerConnectionManagerImpl;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.channelfw.ChannelFramework;
import com.ibm.wsspi.channelfw.ChannelFrameworkFactory;
import com.ibm.wsspi.channelfw.ConnectionLink;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.channelfw.base.InboundApplicationLink;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import java.util.Map;

public class JFapInboundConnLink
extends InboundApplicationLink
implements MetaDataProvider {
    private static final TraceComponent tc = SibTr.register(JFapInboundConnLink.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private final ChannelData config;
    private ConversationMetaData metaData;

    public JFapInboundConnLink(VirtualConnection vc, ChannelFactoryData channelFactoryData, ChannelData cc) {
        block9: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"<init>", (Object)new Object[]{vc, channelFactoryData, cc});
            }
            ChannelFramework cfw = ChannelFrameworkFactory.getChannelFramework();
            this.config = cc;
            try {
                ChainData[] chainDataArray = null;
                String channelName = this.config.getName();
                chainDataArray = cfw.getInternalRunningChains(channelName);
                if (chainDataArray != null) {
                    if (chainDataArray.length != 1 && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)"chain data contains more than one entry!");
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)("channelName=" + channelName + " chainData=" + chainDataArray[0]));
                    }
                    this.metaData = new ConversationMetaDataImpl(chainDataArray[0], (ConnectionLink)this);
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)("cannot find a running chain for channel: " + channelName));
                }
            }
            catch (ChannelException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.jfapchannel.impl.JFapInboundConnLink", (String)"00090003", (Object)cfw);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block9;
                SibTr.exception((Object)((Object)this), (TraceComponent)tc, (Exception)((Object)e));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"<init>");
        }
    }

    public void ready(VirtualConnection readyVc) {
        InboundConnection connection;
        AcceptListener acceptListener;
        block21: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"ready", (Object)readyVc);
            }
            if ((acceptListener = (AcceptListener)this.config.getPropertyBag().get("jfapchannel.ACCEPT_LISTENER")) == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)"null accept listener - obtaining one from factory");
                }
                acceptListener = ServerConnectionManagerImpl.getAcceptListenerFactory().manufactureAcceptListener();
            }
            Map properties = this.config.getPropertyBag();
            int heartbeatInterval = this.determineHeartbeatInterval(properties);
            int heartbeatTimeout = this.determineHeartbeatTimeout(properties);
            CFWNetworkConnection conn = new CFWNetworkConnection(readyVc);
            connection = null;
            try {
                connection = new InboundConnection((NetworkConnectionContext)new CFWNetworkConnectionContext((NetworkConnection)conn, (ConnectionLink)this), (NetworkConnection)conn, acceptListener, heartbeatInterval, heartbeatTimeout);
            }
            catch (FrameworkException fe) {
                FFDCFilter.processException((Throwable)fe, (String)"com.ibm.ws.sib.jfapchannel.impl.JFapInboundConnLink", (String)"00090004");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)"Exception occurred creating InboundConnection");
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block21;
                SibTr.exception((Object)((Object)this), (TraceComponent)tc, (Exception)((Object)fe));
            }
        }
        if (connection != null) {
            ConversationReceiveListener rl;
            ConversationImpl conversation;
            block22: {
                conversation = new ConversationImpl(1, true, (Connection)connection, null);
                rl = null;
                try {
                    rl = acceptListener.acceptConnection((Conversation)conversation);
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.sib.jfapchannel.impl.JFapInboundConnLink", (String)"00090001");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)"Exception occurred in acceptConnection callback");
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block22;
                    SibTr.exception((Object)((Object)this), (TraceComponent)tc, (Throwable)t);
                }
            }
            if (rl == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Null receive listener, closing conversation");
                }
                conversation.setDefaultReceiveListener((ConversationReceiveListener)new CloseConversationReceiveListener());
                try {
                    conversation = connection.startNewConversation(conversation);
                    conversation.close();
                }
                catch (SIException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.jfapchannel.impl.JFapInboundConnLink", (String)"00090002");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.exception((Object)((Object)this), (TraceComponent)tc, (Exception)((Object)e));
                    }
                    connection.invalidate(true, e, "SIConnectionLostException thrown during conversation close");
                }
            } else {
                conversation.setDefaultReceiveListener(rl);
                try {
                    connection.startNewConversation(conversation);
                }
                catch (SIResourceException e) {
                    try {
                        conversation.close();
                    }
                    catch (SIConnectionLostException sIConnectionLostException) {
                        // empty catch block
                    }
                    connection.invalidate(true, e, "Resource exception thrown when starting new conversation");
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"ready");
        }
    }

    private int determineHeartbeatInterval(Map properties) {
        String intervalStr;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"determineHeartbeatInterval", (Object)properties);
        }
        int heartbeatInterval = 300;
        try {
            heartbeatInterval = Integer.parseInt(RuntimeInfo.getPropertyWithMsg((String)"com.ibm.ws.sib.jfapchannel.HEARTBEAT_INTERVAL", (String)("" + heartbeatInterval)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (properties != null && (intervalStr = (String)properties.get("com.ibm.ws.sib.jfapchannel.HEARTBEAT_INTERVAL_PROPERTY")) != null) {
            try {
                heartbeatInterval = Integer.parseInt(intervalStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"determineHeartbeatInterval", (Object)heartbeatInterval);
        }
        return heartbeatInterval;
    }

    private int determineHeartbeatTimeout(Map properties) {
        String timeoutStr;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"determineHeartbeatTimeout", (Object)properties);
        }
        int heartbeatTimeout = 7;
        try {
            heartbeatTimeout = Integer.parseInt(RuntimeInfo.getPropertyWithMsg((String)"com.ibm.ws.sib.jfapchannel.HEARTBEAT_TIMEOUT", (String)("" + heartbeatTimeout)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (properties != null && (timeoutStr = (String)properties.get("com.ibm.ws.sib.jfapchannel.HEARTBEAT_TIMEOUT_PROPERTY")) != null) {
            try {
                heartbeatTimeout = Integer.parseInt(timeoutStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"determineHeartbeatTimeout", (Object)heartbeatTimeout);
        }
        return heartbeatTimeout;
    }

    public void close(VirtualConnection vc, Exception e) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"close", (Object)new Object[]{vc, e});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled() && e != null) {
            SibTr.exception((Object)((Object)this), (TraceComponent)tc, (Exception)e);
        }
        super.close(vc, e);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"close");
        }
    }

    public void destroy(Exception e) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"destroy", (Object)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled() && e != null) {
            SibTr.exception((Object)((Object)this), (TraceComponent)tc, (Exception)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"destroy");
        }
    }

    public ConversationMetaData getMetaData() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"getMetaData");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"getMetaData", (Object)this.metaData);
        }
        return this.metaData;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.server.impl/src/com/ibm/ws/sib/jfapchannel/impl/JFapInboundConnLink.java, SIB.comms, WASX.SIB, aa1225.01 1.38");
        }
    }

    private static class CloseConversationReceiveListener
    implements ConversationReceiveListener {
        private CloseConversationReceiveListener() {
        }

        public ConversationReceiveListener dataReceived(WsByteBuffer data, int segmentType, int requestNumber, int priority, boolean allocatedFromBufferPool, boolean partOfExchange, Conversation conversation) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"CloseConversationReceiveListener.dataReceived");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"CloseConversationReceiveListener.dataReceived");
            }
            return null;
        }

        public void errorOccurred(SIConnectionLostException exception, int segmentType, int requestNumber, int priority, Conversation conversation) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"CloseConversationReceiveListener.errorOccurred");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)exception));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"CloseConversationReceiveListener.errorOccurred");
            }
        }

        public Dispatchable getThreadContext(Conversation conversation, WsByteBuffer data, int segmentType) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"CloseConversationReceiveListener.getThreadContext");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"CloseConversationReceiveListener.getThreadContext");
            }
            return null;
        }
    }
}

