/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jaspi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.security.auth.message.config.AuthConfigFactory;
import java.security.Security;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AuthConfigFactoryWrapper {
    private static final TraceComponent tc = Tr.register(AuthConfigFactoryWrapper.class, (String)"security", (String)"com.ibm.ws.security.jaspi.internal.resources.JaspiMessages");
    static final String JASPI_PROVIDER_REGISTRY = "com.ibm.ws.security.jaspi.ProviderRegistry";
    static boolean initialized = false;
    static final long serialVersionUID = 869568865078469422L;

    public static AuthConfigFactory getFactory() {
        if (!initialized) {
            AuthConfigFactoryWrapper.setFactoryImplementation();
        }
        return AuthConfigFactory.getFactory();
    }

    static synchronized void setFactoryImplementation() {
        if (initialized) {
            return;
        }
        initialized = true;
        String authConfigProvider = Security.getProperty("authconfigprovider.factory");
        if (authConfigProvider == null || authConfigProvider.isEmpty()) {
            Tr.info((TraceComponent)tc, (String)"JASPI_DEFAULT_AUTH_CONFIG_FACTORY", (Object[])new Object[]{JASPI_PROVIDER_REGISTRY});
            Security.setProperty("authconfigprovider.factory", JASPI_PROVIDER_REGISTRY);
        } else if (!authConfigProvider.equals(JASPI_PROVIDER_REGISTRY)) {
            Tr.info((TraceComponent)tc, (String)"JASPI_AUTH_CONFIG_FACTORY", (Object[])new Object[]{authConfigProvider});
        }
    }
}

