/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jaspi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jaspi.AuthConfigFactoryWrapper;
import com.ibm.ws.security.jaspi.DefaultAuthConfigProvider;
import com.ibm.ws.security.jaspi.JaspiServiceImpl;
import com.ibm.ws.security.jaspi.PersistenceManager;
import com.ibm.ws.security.jaspi.RegistrationID;
import com.ibm.ws.security.jaspi.XMLJaspiConfiguration;
import com.ibm.ws.webcontainer.security.util.WebConfigUtils;
import com.ibm.wsspi.security.jaspi.ProviderService;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import jakarta.security.auth.message.config.AuthConfigFactory;
import jakarta.security.auth.message.config.AuthConfigProvider;
import jakarta.security.auth.message.config.RegistrationListener;
import jakarta.security.auth.message.module.ServerAuthModule;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecurityPermission;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ProviderRegistry
extends AuthConfigFactory {
    private static final TraceComponent tc = Tr.register(ProviderRegistry.class, (String)"Security", null);
    private static final String CONTEXT_REGISTRATION_ID = "CONTEXT_REGISTRATION_ID";
    private final Map<RegistrationID, CacheEntry<AuthConfigProvider, AuthConfigFactory.RegistrationContext, Collection<RegistrationListener>>> cache = new HashMap<RegistrationID, CacheEntry<AuthConfigProvider, AuthConfigFactory.RegistrationContext, Collection<RegistrationListener>>>();
    private final Lock lock = new ReentrantLock();
    private PersistenceManager persistenceMgr = null;
    private static String registerDefaultProviderForAllContexts = "com.ibm.websphere.jaspi.registerDefaultProviderForAllContexts";
    RegistrationID defaultRegistrationID = new RegistrationID(null, null);
    static final long serialVersionUID = 4438089766390732931L;

    public ProviderRegistry() {
        String persistConfigFileName = System.getProperty("com.ibm.websphere.jaspi.configuration");
        if (persistConfigFileName != null && !persistConfigFileName.isEmpty()) {
            String path = JaspiServiceImpl.getServerResourceAbsolutePath(persistConfigFileName);
            path = path != null ? path : persistConfigFileName;
            File persistConfigFile = new File(path);
            this.persistenceMgr = new XMLJaspiConfiguration();
            this.persistenceMgr.setAuthConfigFactory(this);
            this.persistenceMgr.setFile(persistConfigFile);
            this.persistenceMgr.load();
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"System property com.ibm.websphere.jaspi.configuration not set, persistent config will not be used", (Object[])new Object[0]);
        }
    }

    public PersistenceManager getPersistenceManager() {
        return this.persistenceMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] detachListener(RegistrationListener listener, String layer, String appContext) {
        this.checkPermission("setProperty.authconfigfactory.provider");
        HashSet<String> registrationIDs = new HashSet<String>();
        for (RegistrationID id : this.cache.keySet()) {
            CacheEntry<AuthConfigProvider, AuthConfigFactory.RegistrationContext, Collection<RegistrationListener>> entry = this.cache.get(id);
            if (entry == null || !this.matchesRegistrationContext(layer, appContext, (AuthConfigFactory.RegistrationContext)entry.context)) continue;
            registrationIDs.add(id.toString());
            if (((Collection)entry.listeners).isEmpty()) continue;
            this.lock.lock();
            try {
                ((Collection)entry.listeners).remove(listener);
            }
            finally {
                this.lock.unlock();
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"detachListener registrationIDs", (Object[])new Object[]{registrationIDs});
        }
        return registrationIDs.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthConfigProvider getConfigProvider(String layer, String appContext, RegistrationListener listener) {
        AuthConfigProvider provider;
        CacheEntry<AuthConfigProvider, AuthConfigFactory.RegistrationContext, Collection<RegistrationListener>> entry = null;
        this.lock.lock();
        try {
            if (layer != null && appContext != null) {
                entry = this.cache.get(new RegistrationID(layer, appContext));
            }
            if (entry == null) {
                if (appContext != null) {
                    entry = this.cache.get(new RegistrationID(null, appContext));
                }
                if (entry == null) {
                    if (layer != null) {
                        entry = this.cache.get(new RegistrationID(layer, null));
                    }
                    if (entry == null) {
                        entry = this.cache.get(new RegistrationID(null, null));
                    }
                }
            }
            if (listener != null && entry != null) {
                ((Collection)entry.listeners).add(listener);
            }
        }
        finally {
            this.lock.unlock();
        }
        AuthConfigProvider authConfigProvider = provider = entry == null ? null : (AuthConfigProvider)entry.provider;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getConfigProvider entry", (Object[])new Object[]{entry});
        }
        return provider;
    }

    public AuthConfigFactory.RegistrationContext getRegistrationContext(String registrationID) {
        AuthConfigFactory.RegistrationContext context = null;
        CacheEntry<AuthConfigProvider, AuthConfigFactory.RegistrationContext, Collection<RegistrationListener>> entry = null;
        entry = this.cache.get(new RegistrationID(registrationID));
        if (entry != null) {
            context = (AuthConfigFactory.RegistrationContext)entry.context;
        }
        return context;
    }

    @ManualTrace
    public String[] getRegistrationIDs(AuthConfigProvider provider) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRegistrationIDs", (Object[])new Object[0]);
        }
        HashSet<String> registrationIDs = new HashSet<String>();
        if (provider == null) {
            for (RegistrationID key : this.cache.keySet()) {
                registrationIDs.add(key.toString());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getRegistrationIDs", registrationIDs);
            }
            return registrationIDs.toArray(new String[0]);
        }
        Set<Map.Entry<RegistrationID, CacheEntry<AuthConfigProvider, AuthConfigFactory.RegistrationContext, Collection<RegistrationListener>>>> entries = this.cache.entrySet();
        for (Map.Entry<RegistrationID, CacheEntry<AuthConfigProvider, AuthConfigFactory.RegistrationContext, Collection<RegistrationListener>>> entry : entries) {
            if (!provider.equals(entry.getValue().provider)) continue;
            registrationIDs.add(entry.getKey().toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRegistrationIDs", registrationIDs);
        }
        return registrationIDs.toArray(new String[0]);
    }

    public void refresh() {
        this.checkPermission("setProperty.authconfigfactory.provider");
    }

    public String registerConfigProvider(AuthConfigProvider provider, String layer, String appContext, String description) {
        this.checkPermission("setProperty.authconfigfactory.provider");
        String registrationID = this.registerProvider(false, provider, layer, appContext, description);
        return registrationID;
    }

    public String registerConfigProvider(String className, Map properties, String layer, String appContext, String description) {
        this.checkPermission("setProperty.authconfigfactory.provider");
        AuthConfigProvider provider = this.newInstance(null, className, true, this.doPrivGetContextClassLoader(), properties);
        String registrationID = this.registerProvider(true, provider, layer, appContext, description);
        if (this.persistenceMgr != null) {
            this.persistenceMgr.registerProvider(className, properties, layer, appContext, description);
        }
        return registrationID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String registerProvider(boolean isPersistent, AuthConfigProvider provider, String layer, String appContext, String description) {
        RegistrationID registrationID = new RegistrationID(layer, appContext);
        Context context = new Context(isPersistent, layer, appContext, description);
        CacheEntry<AuthConfigProvider, Context, Object> newEntry = new CacheEntry<AuthConfigProvider, Context, Object>(provider, context, null);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"adding new entry to provider cache", (Object[])new Object[]{newEntry});
        }
        this.lock.lock();
        try {
            CacheEntry<AuthConfigProvider, Context, Object> oldEntry = this.cache.put(registrationID, newEntry);
            newEntry.listeners = oldEntry == null ? new HashSet() : oldEntry.listeners;
        }
        finally {
            this.lock.unlock();
        }
        this.notifyListener((Collection)newEntry.listeners, layer, appContext);
        return registrationID.toString();
    }

    public String registerServerAuthModule(final ServerAuthModule serverAuthModule, Object context) {
        ServletContext servletContext = null;
        String registrationId = null;
        String hostName = null;
        if (context instanceof ServletContext) {
            String appContextId;
            servletContext = (ServletContext)context;
            WebAppConfig appCfg = WebConfigUtils.getWebAppConfig();
            hostName = appCfg != null ? appCfg.getVirtualHostName() : "default_host";
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("virtual server name: " + hostName), (Object[])new Object[0]);
            }
            String contextPath = servletContext.getContextPath();
            final String f_appContextId = appContextId = hostName.concat(" ").concat(contextPath);
            registrationId = AccessController.doPrivileged(new PrivilegedAction<String>(){
                static final long serialVersionUID = -9150636998709408056L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public String run() {
                    return AuthConfigFactoryWrapper.getFactory().registerConfigProvider((AuthConfigProvider)new DefaultAuthConfigProvider(serverAuthModule), "HttpServlet", f_appContextId, null);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.jaspi.ProviderRegistry$1", 1.class, (String)"security", (String)"com.ibm.ws.security.jaspi.internal.resources.JaspiMessages");
                }
            });
            servletContext.setAttribute(CONTEXT_REGISTRATION_ID, (Object)registrationId);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Returning registrationId: " + registrationId), (Object[])new Object[0]);
        }
        return registrationId;
    }

    public void removeServerAuthModule(Object context) {
        ServletContext servletContext = null;
        if (context instanceof ServletContext) {
            servletContext = (ServletContext)context;
            final String registrationId = (String)servletContext.getAttribute(CONTEXT_REGISTRATION_ID);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Removing registrationId: " + registrationId), (Object[])new Object[0]);
            }
            if (registrationId != null && !registrationId.isEmpty()) {
                Boolean unregistered = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
                    static final long serialVersionUID = 8408065971054196641L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Boolean run() {
                        return AuthConfigFactoryWrapper.getFactory().removeRegistration(registrationId);
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.jaspi.ProviderRegistry$2", 2.class, (String)"security", (String)"com.ibm.ws.security.jaspi.internal.resources.JaspiMessages");
                    }
                });
                if (!unregistered.booleanValue()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Failed to remove registrationId: " + registrationId), (Object[])new Object[0]);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Successfully removed registrationId: " + registrationId), (Object[])new Object[0]);
                }
            }
        }
    }

    protected void notifyListener(Collection<RegistrationListener> listeners, String layer, String appContext) {
        boolean hasListeners;
        boolean bl = hasListeners = listeners != null && !listeners.isEmpty();
        if (hasListeners) {
            for (RegistrationListener listener : listeners) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"notifyListener", (Object[])new Object[]{listener});
                }
                listener.notify(layer, appContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRegistration(String registrationID) {
        this.checkPermission("setProperty.authconfigfactory.provider");
        CacheEntry<AuthConfigProvider, AuthConfigFactory.RegistrationContext, Collection<RegistrationListener>> entry = null;
        boolean removed = false;
        if (registrationID != null) {
            RegistrationID id = new RegistrationID(registrationID);
            this.lock.lock();
            try {
                entry = this.cache.remove(id);
                removed = entry != null;
            }
            finally {
                this.lock.unlock();
            }
            if (entry != null) {
                String layer = ((AuthConfigFactory.RegistrationContext)entry.context).getMessageLayer();
                String appContext = ((AuthConfigFactory.RegistrationContext)entry.context).getAppContext();
                this.notifyListener((Collection)entry.listeners, layer, appContext);
                if (this.persistenceMgr != null) {
                    this.persistenceMgr.removeProvider(layer, appContext);
                }
            }
        }
        return removed;
    }

    protected void checkPermission(String permName) {
        SecurityManager secMgr = System.getSecurityManager();
        if (secMgr != null) {
            secMgr.checkPermission(new SecurityPermission(permName));
        }
    }

    /*
     * WARNING - void declaration
     */
    protected AuthConfigProvider newInstance(AuthConfigFactory factory, String className, boolean init, ClassLoader loader, Map<?, ?> properties) {
        AuthConfigProvider provider = null;
        if (className != null) {
            try {
                Class<?> clz;
                Constructor<?> ctor;
                Object obj;
                if (properties != null) {
                    for (Map.Entry<?, ?> entry : properties.entrySet()) {
                        boolean isValid = entry.getKey() instanceof String && entry.getValue() instanceof String;
                        if (isValid) continue;
                        throw new IllegalArgumentException("All keys and values in properties parameter must be of type String.");
                    }
                }
                if ((obj = (ctor = (clz = Class.forName(className, init, loader == null ? this.doPrivGetContextClassLoader() : loader)).getConstructor(Map.class, AuthConfigFactory.class)).newInstance(properties, factory)) instanceof AuthConfigProvider) {
                    provider = (AuthConfigProvider)obj;
                }
            }
            catch (Throwable clz) {
                void t;
                FFDCFilter.processException((Throwable)clz, (String)"com.ibm.ws.security.jaspi.ProviderRegistry", (String)"446", (Object)((Object)this), (Object[])new Object[]{factory, className, init, loader, properties});
                throw new SecurityException("Unable to create a provider, class name: " + className, (Throwable)t);
            }
        }
        return provider;
    }

    protected boolean matchesRegistrationContext(String layer, String appContext, AuthConfigFactory.RegistrationContext context) {
        boolean match = false;
        if (context != null) {
            String ctxLayer = context.getMessageLayer();
            String ctxId = context.getAppContext();
            if (ctxLayer != null && ctxId != null) {
                match = ctxLayer.equals(layer) && ctxId.equals(appContext);
            } else if (ctxLayer == null && ctxId == null) {
                match = true;
            } else if (ctxLayer == null && ctxId != null) {
                match = ctxId.equals(appContext);
            } else if (ctxLayer != null && ctxId == null) {
                match = ctxLayer.equals(layer);
            }
        }
        return match;
    }

    protected ClassLoader doPrivGetContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
            static final long serialVersionUID = -3126703586680027360L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.jaspi.ProviderRegistry$3", 3.class, (String)"security", (String)"com.ibm.ws.security.jaspi.internal.resources.JaspiMessages");
            }
        });
    }

    public AuthConfigProvider setProvider(ProviderService providerService) {
        AuthConfigProvider authConfigProvider = null;
        if (providerService != null) {
            authConfigProvider = providerService.getAuthConfigProvider(this);
            this.registerConfigProvider(authConfigProvider, null, null, null);
        } else {
            this.removeRegistration(this.defaultRegistrationID.toString());
        }
        return authConfigProvider;
    }

    boolean isAnyProviderRegistered() {
        return !this.cache.isEmpty();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class Context
    implements AuthConfigFactory.RegistrationContext {
        public String layer;
        public String appContext;
        public String description;
        public boolean isPersistent;
        static final long serialVersionUID = 5737137219562953507L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public Context(boolean isPersistent, String layer, String appContext, String description) {
            this.isPersistent = isPersistent;
            this.layer = layer;
            this.appContext = appContext;
            this.description = description;
        }

        public String getAppContext() {
            return this.appContext;
        }

        public String getDescription() {
            return this.description;
        }

        public String getMessageLayer() {
            return this.layer;
        }

        public boolean isPersistent() {
            return this.isPersistent;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("RegistrationContext[");
            builder.append("layer=" + this.layer + ",appContext=" + this.appContext + ",isPersistent=" + this.isPersistent + ",description=" + this.description);
            return builder.append("]").toString();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.jaspi.ProviderRegistry$Context", Context.class, (String)"security", (String)"com.ibm.ws.security.jaspi.internal.resources.JaspiMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class CacheEntry<P, C, L> {
        P provider;
        C context;
        L listeners;
        static final long serialVersionUID = -6041717773443698490L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        CacheEntry(P provider, C context, L listeners) {
            this.provider = provider;
            this.context = context;
            this.listeners = listeners;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("CacheEntry[");
            builder.append(this.context + ",provider=" + this.provider + ",listeners=" + this.listeners);
            return builder.append("]").toString();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.jaspi.ProviderRegistry$CacheEntry", CacheEntry.class, (String)"security", (String)"com.ibm.ws.security.jaspi.internal.resources.JaspiMessages");
        }
    }
}

