/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webserver.plugin.runtime.collaborators;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppConfiguration;
import com.ibm.ws.webserver.plugin.runtime.listeners.GeneratePluginConfigListener;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.webcontainer.collaborator.WebAppInitializationCollaborator;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import jakarta.servlet.SessionCookieConfig;
import org.osgi.service.component.annotations.Component;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={WebAppInitializationCollaborator.class}, immediate=true, property={"service.vendor=IBM"})
public class GenPluginConfigCollaborator
implements WebAppInitializationCollaborator {
    private static final TraceComponent tc = Tr.register(GenPluginConfigCollaborator.class, (String)"PluginRuntime", null);
    static final long serialVersionUID = -2885973359406121352L;

    public void starting(Container moduleContainer) {
    }

    public void started(Container moduleContainer) {
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("application started. moduleContainer: " + moduleContainer.getName()), (Object[])new Object[0]);
            }
            try {
                WebAppConfiguration webAppConfig = (WebAppConfiguration)moduleContainer.adapt(WebAppConfig.class);
                WebApp webApp = webAppConfig.getWebApp();
                SessionCookieConfig sccfg = webApp.getSessionCookieConfig();
                GeneratePluginConfigListener gpcl = GeneratePluginConfigListener.getGeneratePluginConfigListener();
                if (gpcl != null) {
                    gpcl.applicationInitialized(webApp, sccfg);
                }
            }
            catch (UnableToAdaptException webApp) {
                FFDCFilter.processException((Throwable)webApp, (String)"com.ibm.ws.webserver.plugin.runtime.collaborators.GenPluginConfigCollaborator", (String)"61", (Object)this, (Object[])new Object[]{moduleContainer});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((Object)this, (TraceComponent)tc, (String)"application started. cannot adapt to webapp - ignore", (Object[])new Object[0]);
            }
        }
    }

    public void stopping(Container moduleContainer) {
    }

    public void stopped(Container moduleContainer) {
    }
}

