/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.utils.xml.ra;

import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.jca.utils.xml.ra.RaConfigProperty;
import com.ibm.ws.jca.utils.xml.ra.v10.Ra10ConfigProperty;
import com.ibm.ws.jca.utils.xml.ra.v10.Ra10ResourceAdapter;
import com.ibm.ws.jca.utils.xml.wlp.ra.WlpRaConnectionDefinition;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

@Trivial
@XmlType(propOrder={"managedConnectionFactoryClass", "configProperties", "connectionFactoryInterface", "connectionFactoryImplClass", "connectionInterface", "connectionImplClass"})
public class RaConnectionDefinition {
    public static final HashMap<String, String> parentPids = new HashMap();
    private String managedConnectionFactoryClass;
    private String connectionFactoryInterface;
    private String connectionFactoryImplClass;
    private String connectionInterface;
    private String connectionImplClass;
    private String id;
    @XmlElement(name="config-property")
    private final List<RaConfigProperty> configProperties = new LinkedList<RaConfigProperty>();
    @XmlTransient
    private String wlp_aliasSuffix;
    @XmlTransient
    private String wlp_connectionFactoryInterface;
    @XmlTransient
    private String wlp_nlsKey;
    @XmlTransient
    private String wlp_name;
    @XmlTransient
    private String wlp_description;

    public String getName() {
        return this.wlp_name;
    }

    public String getDescription() {
        return this.wlp_description;
    }

    public String getNLSKey() {
        return this.wlp_nlsKey;
    }

    public String getAliasSuffix() {
        return this.wlp_aliasSuffix;
    }

    public String getID() {
        return this.id;
    }

    @XmlID
    @XmlAttribute(name="id")
    public void setID(String id) {
        this.id = id;
    }

    @XmlElement(name="managedconnectionfactory-class", required=true)
    public void setManagedConnectionFactoryClass(String managedConnectionFactoryClass) {
        this.managedConnectionFactoryClass = managedConnectionFactoryClass;
    }

    public String getManagedConnectionFactoryClass() {
        return this.managedConnectionFactoryClass;
    }

    @XmlElement(name="connectionfactory-interface", required=true)
    public void setConnectionFactoryInterface(String connectionFactoryInterface) {
        this.connectionFactoryInterface = connectionFactoryInterface;
    }

    public String getConnectionFactoryInterface() {
        return this.connectionFactoryInterface != null ? this.connectionFactoryInterface : this.wlp_connectionFactoryInterface;
    }

    @XmlElement(name="connectionfactory-impl-class", required=true)
    public void setConnectionFactoryImplClass(String connectionFactoryImplClass) {
        this.connectionFactoryImplClass = connectionFactoryImplClass;
    }

    public String getConnectionFactoryImplClass() {
        return this.connectionFactoryImplClass;
    }

    @XmlElement(name="connection-interface", required=true)
    public void setConnectionInterface(String connectionInterface) {
        this.connectionInterface = connectionInterface;
    }

    public String getConnectionInterface() {
        return this.connectionInterface;
    }

    @XmlElement(name="connection-impl-class", required=true)
    public void setConnectionImplClass(String connectionImplClass) {
        this.connectionImplClass = connectionImplClass;
    }

    public String getConnectionImplClass() {
        return this.connectionImplClass;
    }

    public List<RaConfigProperty> getConfigProperties() {
        return this.configProperties;
    }

    public RaConfigProperty getConfigPropertyById(String name) {
        for (RaConfigProperty configProperty : this.configProperties) {
            if (!configProperty.getName().equals(name)) continue;
            return configProperty;
        }
        return null;
    }

    public boolean isConfigPropertyAlreadyDefined(String configPropName) {
        RaConfigProperty configProperty = this.getConfigPropertyById(configPropName);
        if (configProperty == null) {
            return false;
        }
        return configProperty.getType() != null;
    }

    public String getConnectionFactoryParentPid() {
        String parentPid = parentPids.get(this.connectionFactoryInterface);
        if (parentPid != null) {
            return parentPid;
        }
        return parentPids.get(null);
    }

    public void copyWlpSettings(WlpRaConnectionDefinition connectionDefinition) {
        this.wlp_aliasSuffix = connectionDefinition.getAliasSuffix();
        this.wlp_nlsKey = connectionDefinition.getNLSKey();
        this.wlp_name = connectionDefinition.getName();
        this.wlp_description = connectionDefinition.getDescription();
    }

    public void copyRa10Settings(Ra10ResourceAdapter ra10resourceAdapter) {
        this.connectionFactoryImplClass = ra10resourceAdapter.getConnectionFactoryImpl();
        this.connectionFactoryInterface = ra10resourceAdapter.getConnectionFactoryInterface();
        this.connectionImplClass = ra10resourceAdapter.getConnectionImpl();
        this.connectionInterface = ra10resourceAdapter.getConnectionInterface();
        this.managedConnectionFactoryClass = ra10resourceAdapter.getManagedConnectionFactoryClass();
        for (Ra10ConfigProperty property : ra10resourceAdapter.getConfigProperties()) {
            RaConfigProperty configProperty = new RaConfigProperty();
            configProperty.copyRa10Settings(property);
            this.configProperties.add(configProperty);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RaConnectionDefinition{");
        sb.append("connectionfactory-interface='");
        if (this.connectionFactoryInterface != null) {
            sb.append(this.connectionFactoryInterface);
        } else {
            sb.append(this.wlp_connectionFactoryInterface);
        }
        sb.append("'}");
        return sb.toString();
    }

    public boolean useSpecializedConfig() {
        return parentPids.get(this.connectionFactoryInterface) != null;
    }

    static {
        parentPids.put("jakarta.jms.ConnectionFactory", "com.ibm.ws.jca.jmsConnectionFactory");
        parentPids.put("jakarta.jms.QueueConnectionFactory", "com.ibm.ws.jca.jmsQueueConnectionFactory");
        parentPids.put("jakarta.jms.TopicConnectionFactory", "com.ibm.ws.jca.jmsTopicConnectionFactory");
        parentPids.put(null, "com.ibm.ws.jca.connectionFactory");
    }
}

