/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authorization.jacc.web.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authorization.jacc.common.PolicyContextHandlerImpl;
import com.ibm.ws.security.authorization.jacc.web.WebSecurityValidator;
import jakarta.security.jacc.PolicyContext;
import jakarta.security.jacc.PolicyContextException;
import jakarta.security.jacc.PolicyContextHandler;
import jakarta.security.jacc.WebUserDataPermission;
import jakarta.servlet.http.HttpServletRequest;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.HashMap;
import javax.security.auth.Subject;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WebSecurityValidatorImpl
implements WebSecurityValidator {
    private static final TraceComponent tc = Tr.register(WebSecurityValidatorImpl.class, (String)"Security.Authorization", (String)"com.ibm.ws.security.authorization.jacc.web.resources.JaccWebAuthorizationMessages");
    private static String[] jaccHandlerKeyArrayEe8 = new String[]{"javax.security.auth.Subject.container", "jakarta.servlet.http.HttpServletRequest"};
    private static String[] jaccHandlerKeyArrayEe9 = new String[]{"javax.security.auth.Subject.container", "jakarta.servlet.http.HttpServletRequest"};
    private static ProtectionDomain nullPd = new ProtectionDomain(new CodeSource(null, (Certificate[])null), null, null, null);
    private static CodeSource nullCs = new CodeSource(null, (Certificate[])null);
    private static PolicyContextHandlerImpl pch = PolicyContextHandlerImpl.getInstance();
    static final long serialVersionUID = -7550709475744759832L;

    /*
     * WARNING - void declaration
     */
    public boolean checkDataConstraints(String contextId, Object httpServletRequest, WebUserDataPermission webUDPermission) {
        HttpServletRequest req = null;
        if (httpServletRequest != null) {
            try {
                req = (HttpServletRequest)httpServletRequest;
            }
            catch (ClassCastException classCastException) {
                FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.security.authorization.jacc.web.impl.WebSecurityValidatorImpl", (String)"50", (Object)this, (Object[])new Object[]{contextId, httpServletRequest, webUDPermission});
                Tr.error((TraceComponent)tc, (String)"JACC_WEB_SPI_PARAMETER_ERROR", (Object[])new Object[]{httpServletRequest.getClass().getName(), "checkDataConstraints", "HttpServletRequest"});
                return false;
            }
        }
        Boolean result = Boolean.FALSE;
        try {
            final WebUserDataPermission wudp = webUDPermission;
            final String fci = contextId;
            final HashMap handlerObjects = new HashMap();
            final HttpServletRequest hsr = req;
            result = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){
                static final long serialVersionUID = 5506202845143740964L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Boolean run() throws PolicyContextException {
                    PolicyContext.setContextID((String)fci);
                    for (String jaccHandlerKey : jaccHandlerKeyArrayEe8) {
                        PolicyContext.registerHandler((String)jaccHandlerKey, (PolicyContextHandler)pch, (boolean)true);
                    }
                    for (String jaccHandlerKey : jaccHandlerKeyArrayEe9) {
                        PolicyContext.registerHandler((String)jaccHandlerKey, (PolicyContextHandler)pch, (boolean)true);
                    }
                    handlerObjects.put(jaccHandlerKeyArrayEe8[1], hsr);
                    handlerObjects.put(jaccHandlerKeyArrayEe9[1], hsr);
                    PolicyContext.setHandlerData((Object)handlerObjects);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Calling JACC implies", (Object[])new Object[0]);
                    }
                    return Policy.getPolicy().implies(nullPd, (Permission)wudp);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.authorization.jacc.web.impl.WebSecurityValidatorImpl$1", 1.class, (String)"Security.Authorization", (String)"com.ibm.ws.security.authorization.jacc.web.resources.JaccWebAuthorizationMessages");
                }
            });
        }
        catch (PrivilegedActionException wudp) {
            void e;
            FFDCFilter.processException((Throwable)wudp, (String)"com.ibm.ws.security.authorization.jacc.web.impl.WebSecurityValidatorImpl", (String)"83", (Object)this, (Object[])new Object[]{contextId, httpServletRequest, webUDPermission});
            Tr.error((TraceComponent)tc, (String)"JACC_WEB_IMPLIES_FAILURE", (Object[])new Object[]{contextId, e.getException()});
            result = Boolean.FALSE;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public boolean checkResourceConstraints(String contextId, Object httpServletRequest, Permission webPerm, Subject subject) {
        HttpServletRequest req = null;
        if (httpServletRequest != null) {
            try {
                req = (HttpServletRequest)httpServletRequest;
            }
            catch (ClassCastException classCastException) {
                FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.security.authorization.jacc.web.impl.WebSecurityValidatorImpl", (String)"98", (Object)this, (Object[])new Object[]{contextId, httpServletRequest, webPerm, subject});
                Tr.error((TraceComponent)tc, (String)"JACC_WEB_SPI_PARAMETER_ERROR", (Object[])new Object[]{httpServletRequest.getClass().getName(), "checkDataConstraints", "HttpServletRequest"});
                return false;
            }
        }
        boolean result = false;
        try {
            HashMap<String, Object> ho = new HashMap<String, Object>();
            Subject s = subject;
            String cid = contextId;
            Permission p = webPerm;
            HttpServletRequest r = req;
            result = this.checkResourceConstraints(cid, r, p, s, ho);
        }
        catch (PrivilegedActionException ho) {
            void e;
            FFDCFilter.processException((Throwable)ho, (String)"com.ibm.ws.security.authorization.jacc.web.impl.WebSecurityValidatorImpl", (String)"111", (Object)this, (Object[])new Object[]{contextId, httpServletRequest, webPerm, subject});
            Tr.error((TraceComponent)tc, (String)"JACC_WEB_IMPLIES_FAILURE", (Object[])new Object[]{contextId, e.getException()});
        }
        return result;
    }

    private boolean checkResourceConstraints(final String contextId, final HttpServletRequest req, final Permission permission, final Subject subject, final HashMap<String, Object> handlerObjects) throws PrivilegedActionException {
        Boolean result = Boolean.FALSE;
        result = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){
            static final long serialVersionUID = -2021383360035354984L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean run() throws PolicyContextException {
                PolicyContext.setContextID((String)contextId);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Registering JACC context handlers", (Object[])new Object[0]);
                }
                for (String key : jaccHandlerKeyArrayEe8) {
                    PolicyContext.registerHandler((String)key, (PolicyContextHandler)pch, (boolean)true);
                }
                for (String key : jaccHandlerKeyArrayEe9) {
                    PolicyContext.registerHandler((String)key, (PolicyContextHandler)pch, (boolean)true);
                }
                handlerObjects.put(jaccHandlerKeyArrayEe8[0], subject);
                handlerObjects.put(jaccHandlerKeyArrayEe8[1], req);
                handlerObjects.put(jaccHandlerKeyArrayEe9[0], subject);
                handlerObjects.put(jaccHandlerKeyArrayEe9[1], req);
                ProtectionDomain pd = null;
                if (subject != null && subject.getPrincipals().size() > 0) {
                    Principal[] principalArray = subject.getPrincipals().toArray(new Principal[subject.getPrincipals().size()]);
                    pd = new ProtectionDomain(nullCs, null, null, principalArray);
                } else {
                    pd = nullPd;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Setting JACC handler data", (Object[])new Object[0]);
                }
                PolicyContext.setHandlerData((Object)handlerObjects);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Calling JACC implies. PD : " + pd), (Object[])new Object[0]);
                }
                return Policy.getPolicy().implies(pd, permission);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.authorization.jacc.web.impl.WebSecurityValidatorImpl$2", 2.class, (String)"Security.Authorization", (String)"com.ibm.ws.security.authorization.jacc.web.resources.JaccWebAuthorizationMessages");
            }
        });
        return result;
    }
}

