/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.async.osgi.internal;

import com.ibm.ejs.container.RemoteAsyncResult;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ejbcontainer.EJBPMICollaborator;
import com.ibm.ws.ejbcontainer.async.osgi.internal.RemoteAsyncResultReaper;
import com.ibm.ws.ejbcontainer.async.osgi.internal.ServerAsyncResultImpl;
import com.ibm.ws.ejbcontainer.jitdeploy.ClassDefiner;
import com.ibm.ws.ejbcontainer.jitdeploy.JITDeploy;
import com.ibm.ws.ejbcontainer.osgi.EJBRemoteRuntime;
import com.ibm.ws.ffdc.FFDCFilter;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Observer;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.rmi.CORBA.Tie;
import org.omg.PortableServer.Servant;

@Trivial
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
public final class RemoteAsyncResultImpl
extends ServerAsyncResultImpl
implements RemoteAsyncResult {
    private static final String CLASS_NAME = RemoteAsyncResultImpl.class.getName();
    private static final TraceComponent tc = Tr.register(RemoteAsyncResultImpl.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static Class<? extends Tie> remoteResultTieClass;
    private final EJBRemoteRuntime ivRemoteRuntime;
    private final RemoteAsyncResultReaper ivRemoteAsyncResultReaper;
    private byte[] ivObjectID;
    private boolean ivAddedToReaper;
    private long ivTimeoutStartTime;
    private Observer ivObserver;
    static final long serialVersionUID = -3415106891073696291L;

    public RemoteAsyncResultImpl(EJBRemoteRuntime remoteRuntime, RemoteAsyncResultReaper reaper, EJBPMICollaborator pmiBean) {
        super(pmiBean);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("<init>: " + (Object)((Object)this)), (Object[])new Object[0]);
        }
        this.ivRemoteRuntime = remoteRuntime;
        this.ivRemoteAsyncResultReaper = reaper;
    }

    public String toString() {
        return super.toString() + "[activated=" + this.isActivated() + ", timeout=" + (this.ivTimeoutStartTime == 0L ? null : new Date(this.ivTimeoutStartTime)) + ']';
    }

    private boolean isActivated() {
        return this.ivObjectID != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setObserver(Observer observer) {
        boolean success;
        Observer oldObserver;
        RemoteAsyncResultImpl remoteAsyncResultImpl = this;
        synchronized (remoteAsyncResultImpl) {
            oldObserver = this.ivObserver;
            success = oldObserver != null || !this.isDone();
            this.ivObserver = success ? observer : null;
        }
        if (oldObserver != null) {
            oldObserver.update(null, observer);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void done() {
        Observer oldObserver;
        Object object = this;
        synchronized (object) {
            super.done();
            oldObserver = this.ivObserver;
            this.ivObserver = null;
        }
        if (oldObserver != null) {
            oldObserver.update(null, null);
        }
        object = this.ivRemoteAsyncResultReaper;
        synchronized (object) {
            if (this.isActivated()) {
                this.ivTimeoutStartTime = System.currentTimeMillis();
                this.ivRemoteAsyncResultReaper.add(this);
                this.ivAddedToReaper = true;
            }
        }
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean cancelled = super.cancel(mayInterruptIfRunning);
        if (cancelled) {
            this.cleanup();
        }
        return cancelled;
    }

    public Object get() throws CancellationException, ExecutionException, InterruptedException {
        Object result;
        try {
            result = super.get();
            this.cleanup();
        }
        catch (ExecutionException ee) {
            this.cleanup();
            throw ee;
        }
        return result;
    }

    public Object get(long timeout, String unit) throws CancellationException, ExecutionException, InterruptedException, TimeoutException {
        Object result;
        try {
            result = super.get(timeout, TimeUnit.valueOf(unit));
            this.cleanup();
        }
        catch (ExecutionException ee) {
            this.cleanup();
            throw ee;
        }
        return result;
    }

    public long getTimeoutStartTime() {
        return this.ivTimeoutStartTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    private void cleanup() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"cleanup", (Object[])new Object[0]);
        }
        RemoteAsyncResultReaper remoteAsyncResultReaper = this.ivRemoteAsyncResultReaper;
        synchronized (remoteAsyncResultReaper) {
            if (this.ivAddedToReaper) {
                this.ivRemoteAsyncResultReaper.remove(this);
            } else {
                this.unexportObject();
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cleanup");
        }
    }

    RemoteAsyncResult exportObject() throws RemoteException {
        this.ivObjectID = this.ivRemoteRuntime.activateAsyncResult((Servant)this.createTie());
        return this.ivRemoteRuntime.getAsyncResultReference(this.ivObjectID);
    }

    private Tie createTie() {
        Tie tie;
        try {
            tie = RemoteAsyncResultImpl.getTieClass().newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        tie.setTarget((Remote)((Object)this));
        return tie;
    }

    private static synchronized Class<? extends Tie> getTieClass() {
        Class<? extends Tie> tieClass = remoteResultTieClass;
        if (tieClass == null) {
            try {
                tieClass = JITDeploy.generate_Tie((ClassLoader)RemoteAsyncResultImpl.class.getClassLoader(), (String)RemoteAsyncResultImpl.class.getName(), RemoteAsyncResult.class, null, (ClassDefiner)new ClassDefiner(), (int)0, (boolean)true).asSubclass(Tie.class);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            remoteResultTieClass = tieClass;
        }
        return tieClass;
    }

    protected void unexportObject() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unexportObject: " + (Object)((Object)this)), (Object[])new Object[0]);
        }
        if (this.ivObjectID != null) {
            try {
                this.ivRemoteRuntime.deactivateAsyncResult(this.ivObjectID);
            }
            catch (Throwable e) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"unexportObject exception", (Object[])new Object[]{e});
                }
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".unexportObject"), (String)"237", (Object)((Object)this));
            }
            this.ivObjectID = null;
        }
    }
}

