/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.messaging.lifecycle;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.messaging.lifecycle.LifecycleError;
import com.ibm.ws.messaging.lifecycle.SingletonAgent;
import com.ibm.wsspi.logging.Introspector;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"osgi.command.scope=sib", "osgi.command.function=singletons", "service.vendor=IBM"})
public class SingletonMonitor
implements Introspector {
    public static final TraceComponent tc = Tr.register(SingletonMonitor.class);
    private static final AtomicInteger counter = new AtomicInteger(0);
    private final int version = counter.incrementAndGet();
    private final Set<String> declaredSingletons = new TreeSet<String>();
    private final Set<String> realizedSingletons = new TreeSet<String>();

    @Activate
    public SingletonMonitor() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"SingletonMonitor constructed", (Object[])new Object[0]);
        }
    }

    @Deactivate
    public void deactivate() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this + " deactivate"), (Object[])new Object[0]);
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    synchronized void addDeclaredSingleton(ServiceReference<SingletonAgent> agent, Map<String, Object> properties) {
        String id = (String)properties.get("id");
        this.declaredSingletons.add(id);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)String.format("Declared Singleton added: %s%nDeclared: %s%n:  Realized: %s", id, this.declaredSingletons, this.realizedSingletons), (Object[])new Object[0]);
        }
    }

    synchronized void removeDeclaredSingleton(SingletonAgent agent, Map<String, Object> properties) {
        String id = (String)properties.get("id");
        boolean removed = this.declaredSingletons.remove(properties.get("id"));
        if (!removed) {
            throw new LifecycleError("Cannot remove undeclared Singleton:" + id);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)String.format("Declared Singleton removed: %s%nDeclared: %s%n  Realized: %s", id, this.declaredSingletons, this.realizedSingletons), (Object[])new Object[0]);
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    synchronized void addRealizedSingleton(SingletonAgent agent) {
        this.realizedSingletons.add(agent.getSingletonType());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)String.format("Realized Singleton added: %s%nDeclared: %s%n:  Realized: %s", agent.getSingletonType(), this.declaredSingletons, this.realizedSingletons), (Object[])new Object[0]);
        }
    }

    synchronized void removeRealizedSingleton(SingletonAgent agent) {
        this.realizedSingletons.remove(agent.getSingletonType());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)String.format("Realized Singleton removed: %s%nDeclared: %s%n  Realized: %s", agent.getSingletonType(), this.declaredSingletons, this.realizedSingletons), (Object[])new Object[0]);
        }
    }

    public String toString() {
        return SingletonMonitor.class.getName() + "#" + this.version;
    }

    public String getIntrospectorName() {
        return "Messaging" + this.getClass().getSimpleName();
    }

    public String getIntrospectorDescription() {
        return String.format("List the declared (D) and the realized (R) messaging singletons.%nMessaging cannot start until all the declared singletons become available (i.e. are realized).", new Object[0]);
    }

    public void introspect(PrintWriter out) throws Exception {
        ((Stream)Stream.concat(this.declaredSingletons.stream(), this.realizedSingletons.stream()).sorted().distinct().sequential()).peek(s -> out.print('[')).peek(s -> out.print(this.declaredSingletons.contains(s) ? (char)'D' : (char)' ')).peek(s -> out.print(this.realizedSingletons.contains(s) ? (char)'R' : (char)' ')).peek(s -> out.print("] ")).forEach(out::println);
    }

    public void singletons() throws Exception {
        System.out.println(this.getIntrospectorName());
        System.out.println(this.getIntrospectorDescription());
        try (PrintWriter pw = new PrintWriter(System.out);){
            this.introspect(pw);
        }
    }
}

