/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.messaging.lifecycle;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.messaging.lifecycle.LifecycleError;
import com.ibm.ws.messaging.lifecycle.Singleton;
import com.ibm.ws.messaging.lifecycle.SingletonAgent;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={SingletonsReady.class}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.vendor=IBM", "singletons.cardinality.minimum=100000", "singletons.target=(id=unbound)", "allSingletons.cardinality.minimum=100000"})
public class SingletonsReady {
    private static final TraceComponent tc = Tr.register(SingletonsReady.class);
    private static final AtomicReference<SingletonsReady> CURRENT = new AtomicReference();
    private final Map<Class<?>, Singleton> singletonMap;

    @Activate
    public SingletonsReady(@Reference(name="singletons") List<SingletonAgent> singletonAgents, @Reference(name="allSingletons") List<Singleton> allSingletons, Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object[])new Object[]{singletonAgents, allSingletons});
        }
        properties.entrySet().forEach(e -> Tr.debug((TraceComponent)tc, (String)("### SingletonsReady property " + (String)e.getKey() + " = " + (e.getValue() instanceof String[] ? Arrays.toString((Object[])e.getValue()) : e.getValue())), (Object[])new Object[0]));
        List singletons = singletonAgents.stream().map(SingletonAgent::getSingleton).collect(Collectors.toList());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"singletons, allSingletons", (Object[])new Object[]{singletons, allSingletons});
        }
        List unexpected = allSingletons.stream().filter(SingletonsReady.not(singletons::contains)).map(Object::toString).peek(s -> Tr.debug((Object)this, (TraceComponent)tc, (String)"Unexpected singleton: ", (Object[])new Object[]{s})).collect(Collectors.toList());
        if (unexpected.size() > 0) {
            throw new LifecycleError("Found unexpected Singleton services that have been declared but not configured correctly: " + unexpected);
        }
        LinkedHashMap map = new LinkedHashMap();
        for (Singleton s2 : singletons) {
            for (Class<?> cls : SingletonsReady.singletonClassesOf(s2)) {
                Singleton oldValue = map.putIfAbsent(cls, s2);
                if (null == oldValue) continue;
                map.replace(cls, oldValue, AMBIGUOUS_ENTRY.INSTANCE);
            }
        }
        this.singletonMap = Collections.unmodifiableMap(map);
        HashSet distinct = new HashSet(map.values());
        HashSet ambiguous = new HashSet(singletons);
        ambiguous.removeAll(distinct);
        if (ambiguous.size() > 0) {
            throw new LifecycleError(String.format("Some singletons share implementation classes: %n\tdistinct  = %s%n\tambiguous = %s", distinct, ambiguous));
        }
        boolean applied = CURRENT.compareAndSet(null, this);
        if (!applied) {
            throw new LifecycleError("Could not set " + SingletonsReady.class.getSimpleName() + " instance as current");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Set impls = distinct.stream().map(Object::getClass).map(Class::getSimpleName).collect(TreeSet::new, Set::add, Set::addAll);
            Set intfs = map.keySet().stream().map(Class::getSimpleName).filter(SingletonsReady.not(impls::contains)).collect(TreeSet::new, Set::add, Set::addAll);
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Messaging singletons are now available: ", (Object[])new Object[]{impls});
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Messaging singletons also available as: ", (Object[])new Object[]{intfs});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    @Deactivate
    private void destroy() {
        boolean result = CURRENT.compareAndSet(this, null);
        Tr.debug((Object)this, (TraceComponent)tc, (String)"Messaging singletons are no longer available: ", (Object[])new Object[]{this.singletonMap.keySet(), result ? "unset succeeded" : "unset failed"});
    }

    public static <T extends Singleton> T requireService(Class<T> type) {
        SingletonsReady current = CURRENT.get();
        if (current == null) {
            throw new LifecycleError("Singletons are not yet ready. Examine the call stack for a service component where a dependency on " + SingletonsReady.class.getSimpleName() + " can be declared to resolve this error.");
        }
        Singleton value = current.singletonMap.get(type);
        if (value == null) {
            throw new LifecycleError("No singleton found of type: " + type);
        }
        if (value == AMBIGUOUS_ENTRY.INSTANCE) {
            throw new LifecycleError("More than one singleton found of type: " + type);
        }
        return (T)((Singleton)type.cast(value));
    }

    private static Set<Class<?>> singletonClassesOf(Singleton singleton) {
        return SingletonsReady.allClassesOf(singleton.getClass()).filter(Singleton.class::isAssignableFrom).filter(SingletonsReady.not(Singleton.class::equals)).collect(Collectors.toSet());
    }

    private static Stream<Class<?>> allClassesOf(Class<?> c) {
        if (c == null) {
            return Stream.empty();
        }
        Stream interfaces = Stream.of(c.getInterfaces()).flatMap(SingletonsReady::allClassesOf);
        Stream<Class<?>> supers = SingletonsReady.allClassesOf(c.getSuperclass());
        Stream<Class<?>> ancestors = Stream.concat(interfaces, supers);
        return Stream.concat(Stream.of(c), ancestors);
    }

    private static <T> Predicate<T> not(Predicate<T> negand) {
        return negand.negate();
    }

    private static enum AMBIGUOUS_ENTRY implements Singleton
    {
        INSTANCE;

    }
}

