/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.sib.msgstore.Membership;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.msgstore.MessageStoreConstants;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NotInMessageStore;
import com.ibm.ws.sib.msgstore.PersistentDataEncodingException;
import com.ibm.ws.sib.msgstore.ProtocolException;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.TransactionException;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.transactions.PersistentTranId;
import com.ibm.ws.sib.utils.DataSlice;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;

public abstract class AbstractItem {
    private final MembershipLock _membershipLock = new MembershipLock();
    public static final int DEFAULT_PRIORITY = 5;
    public static final long NEVER_EXPIRES = -2L;
    public static final long NO_ID = -1L;
    public static final long NO_LOCK_ID = -2L;
    public static final long DELIVERY_DELAY_LOCK_ID = -56789L;
    public static final int DEFAULT_DELIVERY_DELAY = 0;
    public static final int STORE_ALWAYS = 4;
    public static final int STORE_EVENTUALLY = 3;
    public static final int STORE_MAYBE = 2;
    public static final int STORE_NEVER = 1;
    private static TraceComponent tc = SibTr.register(AbstractItem.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private Membership _membership = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Membership _getMembership() {
        MembershipLock membershipLock = this._membershipLock;
        synchronized (membershipLock) {
            return this._membership;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void _setMembership(Membership membership) {
        MembershipLock membershipLock = this._membershipLock;
        synchronized (membershipLock) {
            this._membership = membership;
        }
    }

    public boolean canExpireSilently() {
        return true;
    }

    public boolean deferDataPersistence() {
        return false;
    }

    public void eventExpiryNotification(Transaction transaction) throws SevereMessageStoreException {
    }

    public void eventPostCommitAdd(Transaction transaction) throws SevereMessageStoreException {
    }

    public void eventPostCommitRemove(Transaction transaction) throws SevereMessageStoreException {
        this._setMembership(null);
    }

    public void eventPostCommitUpdate(Transaction transaction) throws SevereMessageStoreException {
    }

    public void eventPostRollbackAdd(Transaction transaction) throws SevereMessageStoreException {
        this._setMembership(null);
    }

    public void eventPostRollbackRemove(Transaction transaction) throws SevereMessageStoreException {
    }

    public void eventPostRollbackUpdate(Transaction transaction) throws SevereMessageStoreException {
    }

    public void eventPrecommitAdd(Transaction transaction) throws SevereMessageStoreException {
    }

    public void eventPrecommitRemove(Transaction transaction) throws SevereMessageStoreException {
    }

    public void eventPrecommitUpdate(Transaction transaction) throws SevereMessageStoreException {
    }

    public void eventRestored() throws SevereMessageStoreException {
    }

    public void eventUnlocked() throws SevereMessageStoreException {
    }

    public long getExpiryStartTime() {
        return 0L;
    }

    public final long getID() throws NotInMessageStore {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getID");
        }
        long id = -1L;
        Membership membership = this._getMembership();
        if (null == membership) {
            throw new NotInMessageStore();
        }
        if (null != membership) {
            id = membership.getID();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getID", (Object)id);
        }
        return id;
    }

    public int getInMemoryDataSize() {
        return 400;
    }

    public final long getLockID() throws MessageStoreException {
        Membership membership = this._getMembership();
        if (null == membership) {
            throw new NotInMessageStore();
        }
        return membership.getLockID();
    }

    public final int getPersistedRedeliveredCount() throws MessageStoreException {
        Membership thisItemLink;
        int count = 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistedRedeliveredCount");
        }
        if ((thisItemLink = this._getMembership()) == null) {
            throw new NotInMessageStore();
        }
        count = thisItemLink.getPersistedRedeliveredCount();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistedRedeliveredCount");
        }
        return count;
    }

    public long getMaximumTimeInStore() {
        return -2L;
    }

    protected final MessageStore getOwningMessageStore() throws NotInMessageStore {
        Membership membership;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getOwningMessageStore");
        }
        if (null == (membership = this._getMembership())) {
            throw new NotInMessageStore();
        }
        MessageStore messageStore = membership.getMessageStore();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getOwningMessageStore", (Object)messageStore);
        }
        return messageStore;
    }

    public List<DataSlice> getPersistentData() throws PersistentDataEncodingException {
        return null;
    }

    public int getPriority() {
        return 5;
    }

    public long getDeliveryDelay() {
        return 0L;
    }

    public int getStorageStrategy() {
        return 1;
    }

    public final PersistentTranId getTransactionId() {
        PersistentTranId id = null;
        Membership membership = this._getMembership();
        if (null != membership) {
            id = membership.getTransactionId();
        }
        return id;
    }

    public final int guessBackoutCount() {
        int count = 0;
        Membership membership = this._getMembership();
        if (null != membership) {
            count = membership.guessBackoutCount();
        }
        return count;
    }

    public final int guessUnlockCount() {
        int count = 0;
        Membership membership = this._getMembership();
        if (null != membership) {
            count = membership.guessUnlockCount();
        }
        return count;
    }

    public final boolean isAdding() {
        boolean is = false;
        Membership membership = this._getMembership();
        if (null != membership) {
            is = membership.isAdding();
        }
        return is;
    }

    public final boolean isAvailable() {
        boolean is = false;
        Membership membership = this._getMembership();
        if (null != membership) {
            is = membership.isAvailable();
        }
        return is;
    }

    public boolean isCollection() {
        return false;
    }

    public final boolean isExpiring() {
        boolean is = false;
        Membership membership = this._getMembership();
        if (null != membership) {
            is = membership.isExpiring();
        }
        return is;
    }

    public final boolean isInStore() {
        boolean is = false;
        Membership membership = this._getMembership();
        if (null != membership) {
            is = membership.isInStore();
        }
        return is;
    }

    public boolean isItem() {
        return false;
    }

    public boolean isItemReference() {
        return false;
    }

    public boolean isItemStream() {
        return false;
    }

    public final boolean isLocked() {
        boolean is = false;
        Membership membership = this._getMembership();
        if (null != membership) {
            is = membership.isLocked();
        }
        return is;
    }

    public boolean isPersistentDataImmutable() {
        return false;
    }

    public boolean isPersistentDataNeverUpdated() {
        return false;
    }

    public final boolean isPersistentRepresentationStable() {
        boolean is = false;
        Membership membership = this._getMembership();
        if (null != membership) {
            is = membership.isPersistentRepresentationStable();
        }
        return is;
    }

    public final boolean isPersistentlyLocked() {
        boolean is = false;
        Membership membership = this._getMembership();
        if (null != membership) {
            is = membership.isPersistentlyLocked();
        }
        return is;
    }

    public boolean isReferenceStream() {
        return false;
    }

    public final boolean isRemoving() {
        boolean is = false;
        Membership membership = this._getMembership();
        if (null != membership) {
            is = membership.isRemoving();
        }
        return is;
    }

    public final synchronized boolean isUpdating() {
        boolean is = false;
        Membership membership = this._getMembership();
        if (null != membership) {
            is = membership.isUpdating();
        }
        return is;
    }

    public final boolean lockItemIfAvailable(long lockID) throws SevereMessageStoreException {
        boolean locked = false;
        Membership membership = this._getMembership();
        if (null != membership) {
            locked = membership.lockItemIfAvailable(lockID);
        }
        return locked;
    }

    public final void persistLock(Transaction transaction) throws ProtocolException, TransactionException, SevereMessageStoreException {
        Membership membership = this._getMembership();
        if (null == membership) {
            throw new NotInMessageStore();
        }
        membership.persistLock(transaction);
    }

    public void persistRedeliveredCount(int redeliveredCount) throws SevereMessageStoreException {
        Membership thisItemLink = this._getMembership();
        if (null == thisItemLink) {
            throw new NotInMessageStore();
        }
        thisItemLink.persistRedeliveredCount(redeliveredCount);
    }

    public final void remove(Transaction transaction, long lockID) throws MessageStoreException {
        Membership membership;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"remove");
        }
        if (null == (membership = this._getMembership())) {
            throw new NotInMessageStore();
        }
        membership.cmdRemove(lockID, transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"remove");
        }
    }

    public final void requestUpdate(Transaction transaction) throws MessageStoreException {
        Membership membership;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"requestUpdate", (Object)transaction);
        }
        if (null == (membership = this._getMembership())) {
            throw new NotInMessageStore();
        }
        membership.requestUpdate(transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"requestUpdate");
        }
    }

    public void restore(List<DataSlice> dataSlices) throws PersistentDataEncodingException, SevereMessageStoreException {
    }

    protected void restoreIfMsgAvailable(List<DataSlice> dataSlices) throws PersistentDataEncodingException, SevereMessageStoreException {
        throw new UnsupportedOperationException();
    }

    public void restoreData(boolean throwExceptionIfMsgNotAvailable) throws PersistentDataEncodingException, SevereMessageStoreException {
        Membership membership;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"restoreData", (Object)throwExceptionIfMsgNotAvailable);
        }
        if (null == (membership = this._getMembership())) {
            throw new NotInMessageStore();
        }
        List<DataSlice> dataSlices = membership.readDataFromPersistence();
        if (throwExceptionIfMsgNotAvailable) {
            this.restore(dataSlices);
        } else {
            this.restoreIfMsgAvailable(dataSlices);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"restoreData");
        }
    }

    public final void unlock(long lockID) throws MessageStoreException {
        this.unlock(lockID, null, true);
    }

    public final void unlock(long lockID, Transaction transaction) throws MessageStoreException {
        this.unlock(lockID, transaction, true);
    }

    public final void unlock(long lockID, Transaction transaction, boolean incrementUnlockCountIfNonpersistent) throws MessageStoreException {
        Membership membership = this._getMembership();
        if (null == membership) {
            throw new NotInMessageStore();
        }
        membership.unlock(lockID, transaction, incrementUnlockCountIfNonpersistent);
    }

    public final void xmlRequestWriteOn(FormattedWriter writer) throws IOException, NotInMessageStore {
        Membership membership = this._getMembership();
        if (null == membership) {
            throw new NotInMessageStore();
        }
        if (null != membership) {
            membership.requestXmlWriteOn(writer);
            writer.flush();
        }
    }

    public final void xmlRequestWriteOnSystemOut() throws IOException, NotInMessageStore {
        Membership membership = this._getMembership();
        if (null == membership) {
            throw new NotInMessageStore();
        }
        if (null != membership) {
            FormattedWriter writer = new FormattedWriter((Writer)new OutputStreamWriter(System.out));
            membership.requestXmlWriteOn(writer);
            writer.flush();
        }
    }

    public void xmlWriteOn(FormattedWriter writer) throws IOException {
    }

    public void handleInvalidDeliveryDelayable(MessageStoreConstants.MaximumAllowedDeliveryDelayAction action) throws MessageStoreException, SIException {
    }

    private static final class MembershipLock {
        private MembershipLock() {
        }
    }
}

