/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics.internal.cdi30.interceptors;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.astefanutti.metrics.cdi30.MetricResolver;
import io.openliberty.microprofile.metrics.internal.cdi30.helper.Utils;
import jakarta.annotation.Priority;
import jakarta.enterprise.inject.Intercepted;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundConstruct;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.AroundTimeout;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.annotation.Timed;

@Timed
@Interceptor
@Priority(value=1010)
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TimedInterceptor {
    private final Bean<?> bean;
    private final MetricRegistry registry;
    private final MetricResolver resolver;
    static final long serialVersionUID = -2799938320742432439L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Inject
    private TimedInterceptor(@Intercepted Bean<?> bean, MetricRegistry registry, MetricResolver resolver) {
        this.bean = bean;
        this.registry = registry;
        this.resolver = resolver;
    }

    @AroundConstruct
    private Object timedConstructor(InvocationContext context) throws Exception {
        return this.timedCallable(context, context.getConstructor());
    }

    @AroundInvoke
    private Object timedMethod(InvocationContext context) throws Exception {
        return this.timedCallable(context, context.getMethod());
    }

    @AroundTimeout
    private Object timedTimeout(InvocationContext context) throws Exception {
        return this.timedCallable(context, context.getMethod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private <E extends Member & AnnotatedElement> Object timedCallable(InvocationContext context, E element) throws Exception {
        MetricResolver.Of<Timed> timed = this.resolver.timed(this.bean.getBeanClass(), element);
        MetricID MetricID2 = new MetricID(timed.metricName(), Utils.tagsToTags(timed.tags()));
        Timer timer = (Timer)this.registry.getMetric(MetricID2);
        if (timer == null) {
            try {
                throw new IllegalStateException("No timer with metricID [" + MetricID2 + "] found in registry [" + this.registry + "]");
            }
            catch (IllegalStateException illegalStateException) {
                void exception;
                FFDCFilter.processException((Throwable)illegalStateException, (String)"io.openliberty.microprofile.metrics.internal.cdi30.interceptors.TimedInterceptor", (String)"92", (Object)this, (Object[])new Object[]{context, element});
                throw exception;
            }
        }
        Timer.Context time = timer.time();
        try {
            Object object = context.proceed();
            return object;
        }
        finally {
            time.stop();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.metrics.internal.cdi30.interceptors.TimedInterceptor", TimedInterceptor.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.cdi.resources.MetricsCDI");
    }
}

