/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.servlet;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.util.FileSystem;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Date;
import java.util.Set;

public class DirectoryBrowsingServlet
extends HttpServlet {
    private static final long serialVersionUID = 3258125864872195895L;
    private static TraceNLS nls = TraceNLS.getTraceNLS(DirectoryBrowsingServlet.class, (String)"com.ibm.ws.webcontainer.resources.Messages");

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean fileSystem;
        ServletContext context;
        File dir;
        String reqURI;
        String dirName;
        String title;
        block12: {
            title = "Index of ";
            dirName = (String)req.getAttribute("com.ibm.servlet.engine.webapp.dir.browsing.path");
            reqURI = (String)req.getAttribute("com.ibm.servlet.engine.webapp.dir.browsing.uri");
            dir = null;
            URL dirURL = null;
            String dirNameFileSystemPath = req.getRealPath(dirName);
            context = this.getServletConfig().getServletContext();
            fileSystem = false;
            if (dirNameFileSystemPath != null) {
                fileSystem = true;
                dirName = dirNameFileSystemPath;
                dir = new File(dirNameFileSystemPath);
                String contextRealPath = context.getRealPath("/");
                int idx = dirName.lastIndexOf(contextRealPath);
                if (idx != -1) {
                    String matchString = dirName.substring(idx + contextRealPath.length());
                    if (!(matchString = matchString.replace(File.separator, "/")).startsWith("/")) {
                        matchString = "/" + matchString;
                    }
                    if (matchString.endsWith("/")) {
                        matchString = matchString.substring(0, matchString.length() - 1);
                    }
                    boolean checkWEBINF = !WCCustomProperties.EXPOSE_WEB_INF_ON_DISPATCH || req.getAttribute("com.ibm.servlet.engine.webapp.dispatch_nested") == null;
                    try {
                        if (!FileSystem.uriCaseCheck(dir, matchString, checkWEBINF)) {
                            resp.sendError(404, nls.getString("File.not.found", "File not found"));
                            return;
                        }
                        break block12;
                    }
                    catch (IllegalArgumentException exc) {
                        resp.sendError(404, nls.getString("File.not.found", "File not found"));
                        return;
                    }
                }
                resp.sendError(404, nls.getString("File.not.found", "File not found"));
                return;
            }
            dirURL = context.getResource(dirName);
            if (dirURL == null) {
                resp.sendError(404, nls.getString("File.not.found", "File not found"));
                return;
            }
        }
        if (!reqURI.endsWith("/")) {
            reqURI = reqURI + '/';
        }
        title = title + reqURI;
        if (fileSystem && !dir.canRead()) {
            resp.sendError(404, nls.getString("File.not.found", "File not found"));
        }
        resp.setContentType("text/html; charset=UTF-8");
        PrintWriter out = resp.getWriter();
        out.println("<HTML><HEAD><TITLE>");
        out.println(title);
        out.println("</TITLE></HEAD><BODY>");
        out.println("<H1 align=\"left\">" + title + "</H1>");
        out.println("<HR size=\"3\"><TABLE cellpadding=\"2\"><TBODY><TR bgcolor=\"#d7ffff\">");
        out.println("<TH width=\"250\" nowrap><P align=\"left\">Name</P></TH>");
        out.println("<TH width=\"250\" nowrap><P align=\"left\">Last Modified</P></TH>");
        out.println("<TH width=\"150\" nowrap><P align=\"left\">Size</P></TH>");
        out.println("<TH width=\"300\" nowrap><P align=\"left\">Description</P></TH></TR>");
        if (fileSystem) {
            this.fillTableRows(dir, reqURI, out);
        } else {
            this.fillTableRows(context, dirName, reqURI, out);
        }
        out.println("</TBODY></TABLE></BODY></HTML>");
        out.close();
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    private void fillTableRows(ServletContext context, String dir, String reqURI, PrintWriter out) {
        Set resourcePaths = context.getResourcePaths(dir);
        for (String s : resourcePaths) {
            if ((s = s.substring(dir.length())).endsWith("/")) {
                if (s.equalsIgnoreCase("META-INF/") || s.equalsIgnoreCase("WEB-INF/")) continue;
                this.printDirectory(out, reqURI, s, "-");
                continue;
            }
            if (s.endsWith(".jsp") || s.endsWith(".jsv") || s.endsWith(".jsw")) continue;
            this.printFile(out, reqURI, s, -1L, "-");
        }
    }

    private void fillTableRows(File dir, String reqURI, PrintWriter out) {
        File[] files = dir.listFiles();
        int fc = 0;
        while (fc < files.length) {
            String lastModifiedDateString;
            Date date;
            if (files[fc].isDirectory()) {
                if (files[fc].getName().equalsIgnoreCase("META-INF") || files[fc].getName().equalsIgnoreCase("WEB-INF")) {
                    ++fc;
                    continue;
                }
                date = new Date(files[fc].lastModified());
                lastModifiedDateString = date.toString();
                this.printDirectory(out, reqURI, files[fc].getName(), lastModifiedDateString);
            } else {
                if (files[fc].getName().endsWith(".jsp") || files[fc].getName().endsWith(".jsv") || files[fc].getName().endsWith(".jsw")) {
                    ++fc;
                    continue;
                }
                date = new Date(files[fc].lastModified());
                lastModifiedDateString = date.toString();
                this.printFile(out, reqURI, files[fc].getName(), files[fc].length(), lastModifiedDateString);
            }
            ++fc;
        }
    }

    private void printDirectory(PrintWriter out, String urlString, String fileNameString, String dateString) {
        out.println("<TR><TD nowrap>");
        out.println("<A href=\"" + urlString + fileNameString + "\">");
        out.println("<B>" + fileNameString + "</B></A></TD>");
        out.println("<TD nowrap>" + dateString + "</TD>");
        out.println("<TD nowrap>-</TD><TD nowrap>Directory</TD></TR>");
    }

    private void printFile(PrintWriter out, String urlString, String fileNameString, long fileSize, String dateString) {
        out.println("<TR><TD nowrap>");
        out.println("<A href=\"" + urlString + fileNameString + "\">");
        out.println(fileNameString + "</A></TD>");
        out.println("<TD nowrap>" + dateString + "</TD>");
        if (fileSize == -1L) {
            out.println("<TD nowrap>-</TD>");
        } else {
            out.println("<TD nowrap>" + fileSize + "</TD>");
        }
        out.println("<TD nowrap>File</TD></TR>");
    }
}

