/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.session;

import com.ibm.ws.webcontainer.session.SessionCookieConfigImpl;
import jakarta.servlet.SessionTrackingMode;
import java.util.EnumSet;

public class SessionManagerConfigBase {
    protected boolean usingWebContainerSM = true;
    protected boolean useContextRootForSessionCookiePath = false;
    private static String serverLevelSessionCookieName = "JSESSIONID";
    static boolean is_zOS = false;
    private static int sessionIDLength = 23;
    protected EnumSet<SessionTrackingMode> trackingModes = EnumSet.noneOf(SessionTrackingMode.class);
    private String privateSessionCookieName;
    private String privateSessionCookieComment;
    private String privateSessionCookieDomain;
    private int privateSessionCookieMaxAge;
    private String privateSessionCookiePath;
    private boolean privateSessionCookieSecure;
    private boolean privateSessionCookieHttpOnly;
    protected SessionCookieConfigImpl cookieConfig;

    public SessionManagerConfigBase() {
        this.trackingModes.add(SessionTrackingMode.COOKIE);
        this.privateSessionCookieName = "JSESSIONID";
        this.privateSessionCookieComment = "";
        this.privateSessionCookieDomain = null;
        this.privateSessionCookieMaxAge = -1;
        this.privateSessionCookiePath = "/";
        this.privateSessionCookieSecure = false;
        this.privateSessionCookieHttpOnly = true;
        this.cookieConfig = new SessionCookieConfigImpl(this.privateSessionCookieName, this.privateSessionCookieDomain, this.privateSessionCookiePath, this.privateSessionCookieComment, this.privateSessionCookieMaxAge, this.privateSessionCookieHttpOnly, this.privateSessionCookieSecure);
    }

    protected String getDefaultSessionCookieName() {
        return this.privateSessionCookieName;
    }

    public void setEffectiveTrackingModes(EnumSet<SessionTrackingMode> effective) {
        this.trackingModes = effective != null ? EnumSet.copyOf(effective) : EnumSet.noneOf(SessionTrackingMode.class);
    }

    public EnumSet<SessionTrackingMode> getSessionTrackingMode() {
        return this.trackingModes;
    }

    public final SessionCookieConfigImpl getSessionCookieConfig() {
        return this.cookieConfig;
    }

    public final boolean isUsingWebContainerSMForBaseConfig() {
        return this.usingWebContainerSM;
    }

    public final void setUsingWebContainerSMForBaseConfig(boolean b) {
        this.usingWebContainerSM = b;
    }

    public final boolean isUseContextRootForSessionCookiePath() {
        return this.useContextRootForSessionCookiePath;
    }

    public final void setUseContextRootForSessionCookiePath(boolean useContextRootForSessionCookiePath) {
        this.useContextRootForSessionCookiePath = useContextRootForSessionCookiePath;
    }

    public static final int getSessionIDLength() {
        return sessionIDLength;
    }

    public static final void setSessionIDLength(int i) {
        sessionIDLength = i;
    }

    public static final boolean is_zOS() {
        return is_zOS;
    }

    public static final void set_is_zOS(boolean b) {
        is_zOS = b;
    }

    public static void setServerLevelSessionCookieName(String serverLevelSessionCookieName) {
        SessionManagerConfigBase.serverLevelSessionCookieName = serverLevelSessionCookieName;
    }

    public static String getServerLevelSessionCookieName() {
        return serverLevelSessionCookieName;
    }
}

