/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.DecimalFormat;

public class WSURLDecoder {
    private static final int STATE_NORMAL_CHAR = 0;
    private static final int STATE_START_DECODE = 1;
    private static final int STATE_DECODE_FIRST_DIGIT = 2;
    private static final int STATE_DECODE_SECOND_DIGIT = 3;
    private static final int STATE_FINISH_DECODE = 4;
    private static final String ERROR_INCOMPLETE = "URLDecoder: Incomplete trailing escape (%) pattern";
    private static final String ERROR_ILLEGAL = "URLDecoder: Illegal hex characters in escape (%) pattern";

    public static String decode(String url, String encoding) throws UnsupportedEncodingException {
        int srcCharBegin = 0;
        int byteValue = 0;
        int bufferOffset = 0;
        int state = 0;
        if (url.length() == 0) {
            throw new UnsupportedEncodingException();
        }
        char[] srcChars = url.toCharArray();
        int urlLength = srcChars.length;
        byte[] buffer = new byte[urlLength];
        StringBuffer result = new StringBuffer(urlLength);
        block24: for (int i = 0; i < urlLength; ++i) {
            char ch = srcChars[i];
            switch (state) {
                case 0: {
                    if (ch != '%') continue block24;
                    state = 2;
                    result.append(srcChars, srcCharBegin, i - srcCharBegin);
                    continue block24;
                }
                case 2: {
                    switch (ch) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            byteValue = 16 * (ch - 48);
                            break;
                        }
                        case 'A': 
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'E': 
                        case 'F': {
                            byteValue = 16 * (ch - 55);
                            break;
                        }
                        case 'a': 
                        case 'b': 
                        case 'c': 
                        case 'd': 
                        case 'e': 
                        case 'f': {
                            byteValue = 16 * (ch - 87);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(ERROR_ILLEGAL);
                        }
                    }
                    state = 3;
                    continue block24;
                }
                case 3: {
                    switch (ch) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            byteValue += ch - 48;
                            break;
                        }
                        case 'A': 
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'E': 
                        case 'F': {
                            byteValue += ch - 55;
                            break;
                        }
                        case 'a': 
                        case 'b': 
                        case 'c': 
                        case 'd': 
                        case 'e': 
                        case 'f': {
                            byteValue += ch - 87;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(ERROR_ILLEGAL);
                        }
                    }
                    buffer[bufferOffset++] = (byte)byteValue;
                    state = 4;
                    continue block24;
                }
                case 4: {
                    switch (ch) {
                        case '%': {
                            state = 2;
                            continue block24;
                        }
                    }
                    result.append(new String(buffer, 0, bufferOffset, encoding));
                    bufferOffset = 0;
                    srcCharBegin = i;
                    state = 0;
                }
            }
        }
        switch (state) {
            case 0: {
                result.append(srcChars, srcCharBegin, urlLength - srcCharBegin);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                throw new IllegalArgumentException(ERROR_INCOMPLETE);
            }
            case 4: {
                result.append(new String(buffer, 0, bufferOffset, encoding));
            }
        }
        return result.toString();
    }

    private static void testDecode(String url, String encoding, int reps, int runs) throws Exception {
        int j;
        int i;
        long begin = 0L;
        long end = 0L;
        double jdkElapsed = 0.0;
        double webElapsed = 0.0;
        DecimalFormat format = new DecimalFormat("0.00");
        System.out.println("Encoding url: '" + url + "', encoding: " + encoding);
        for (i = 0; i < runs; ++i) {
            if (i == runs - 1) {
                begin = System.currentTimeMillis();
            }
            for (j = 0; j < reps; ++j) {
                URLDecoder.decode(url, encoding);
            }
            if (i != runs - 1) continue;
            end = System.currentTimeMillis();
        }
        jdkElapsed = end - begin;
        System.out.println("java.net.WSURLDecoder result: '" + URLDecoder.decode(url, encoding) + "'");
        System.out.println("java.net.WSURLDecoder time, " + reps + " repetitions after " + runs + " runs: " + jdkElapsed + "ms\n");
        for (i = 0; i < runs; ++i) {
            if (i == runs - 1) {
                begin = System.currentTimeMillis();
            }
            for (j = 0; j < reps; ++j) {
                WSURLDecoder.decode(url, encoding);
            }
            if (i != runs - 1) continue;
            end = System.currentTimeMillis();
        }
        webElapsed = end - begin;
        System.out.println("webcontainer WSURLDecoder result: '" + WSURLDecoder.decode(url, encoding) + "'");
        System.out.println("webcontainer WSURLDecoder time, " + reps + " repetitions after " + runs + " runs: " + webElapsed + "ms");
        System.out.println("webcontainer WSURLDecoder performance difference: " + format.format((jdkElapsed - webElapsed) / jdkElapsed * 100.0) + "%\n");
    }

    public static void main(String[] args) throws Exception {
        WSURLDecoder.testDecode("a", "UTF-8", 100000, 5);
        WSURLDecoder.testDecode("ab", "UTF-8", 100000, 5);
        WSURLDecoder.testDecode("abc", "UTF-8", 100000, 5);
        WSURLDecoder.testDecode("abcd", "UTF-8", 100000, 5);
        WSURLDecoder.testDecode("abcde", "UTF-8", 100000, 5);
        WSURLDecoder.testDecode("abcdef", "UTF-8", 100000, 5);
        WSURLDecoder.testDecode("this/is/a/short/url/with/no/encoded/chars", "UTF-8", 100000, 5);
        WSURLDecoder.testDecode("this/is/a/looooooooooooooooonger/url/with/no/encoded/chars", "UTF-8", 100000, 5);
        WSURLDecoder.testDecode("this/is/a/muuuuuuuuuuuuuuuuuuuuuuuuuuuuch/looooooooooooooooooooooooooooooonger/url/with/no/encoded/chars/and/some+plus+characters", "UTF-8", 100000, 5);
        WSURLDecoder.testDecode("this/is/a/short/url/with/some/%65%66%67%68%69/encoded/chars", "UTF-8", 100000, 5);
        WSURLDecoder.testDecode("this/%65%66%67%68%69/is/%65%66%67%68%69/a/%65%66%67%68%69/longer/%65%66%67%68%69/url/with/scattered/%65%66%67%68%69/encoded/chars", "UTF-8", 100000, 5);
        WSURLDecoder.testDecode("this/%65%66%67%68%69/is/%65%66%67%68%69/a/%65%66%67%68%69/longer/%65%66%67%68%69/url/with/scattered/%65%66%67%68%69/encoded/chars/and/ends/with/encoded/chars/%65%66%67%68%69", "UTF-8", 100000, 5);
    }
}

