/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.security.config.css;

import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.security.context.SubjectManager;
import com.ibm.ws.transport.iiop.security.config.css.CSSASMechConfig;
import com.ibm.ws.transport.iiop.security.config.css.CSSSASMechConfig;
import com.ibm.ws.transport.iiop.security.config.tss.TSSASMechConfig;
import com.ibm.ws.transport.iiop.security.config.tss.TSSGSSUPMechConfig;
import com.ibm.ws.transport.iiop.security.util.Util;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import javax.security.auth.Subject;
import org.omg.IOP.Codec;
import org.omg.PortableInterceptor.ClientRequestInfo;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CSSGSSUPMechConfigDynamic
implements CSSASMechConfig {
    private static TraceComponent tc = Tr.register(CSSGSSUPMechConfigDynamic.class, (String)"CSIv2", (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages");
    private final String mechanism = "GSSUP";
    private final String domain;
    private final boolean required;
    private final String username;
    private final SerializableProtectedString password;
    static final long serialVersionUID = 4670726401395161250L;

    public CSSGSSUPMechConfigDynamic(String username, SerializableProtectedString password, String domain, boolean required) {
        this.username = username;
        this.password = password;
        this.domain = domain;
        this.required = required;
    }

    public CSSGSSUPMechConfigDynamic(String domain, boolean required) {
        this.username = null;
        this.password = null;
        this.domain = domain;
        this.required = required;
    }

    public CSSGSSUPMechConfigDynamic(String domain) {
        this.username = null;
        this.password = null;
        this.domain = domain;
        this.required = false;
    }

    @Override
    public short getSupports() {
        return 64;
    }

    @Override
    public short getRequires() {
        return this.required ? (short)64 : 0;
    }

    @Override
    public boolean canHandle(TSSASMechConfig asMech) {
        return asMech instanceof TSSGSSUPMechConfig || asMech.getRequires() == 0 && !this.required;
    }

    @Override
    public String getMechanism() {
        return "GSSUP";
    }

    @Override
    @Sensitive
    public byte[] encode(TSSASMechConfig tssasMechConfig, CSSSASMechConfig sas_mech, ClientRequestInfo ri, Codec codec) {
        byte[] encoding = null;
        if (tssasMechConfig instanceof TSSGSSUPMechConfig) {
            String targetName = ((TSSGSSUPMechConfig)tssasMechConfig).getTargetName();
            encoding = sas_mech.isAsserting() ? this.encodeGSSUPFromTrustedIdAndPassword(sas_mech, codec, targetName) : this.encodeGSSUPFromBasicAuthSubject(codec, targetName);
        }
        if (encoding == null) {
            encoding = new byte[]{};
        }
        return encoding;
    }

    @Sensitive
    private byte[] encodeGSSUPFromTrustedIdAndPassword(CSSSASMechConfig sas_mech, Codec codec, String targetName) {
        byte[] encoding = new byte[]{};
        String trustedIdentity = sas_mech.getTrustedIdentity();
        SerializableProtectedString trustedPassword = sas_mech.getTrustedPassword();
        if (trustedIdentity != null && trustedPassword != null && !trustedPassword.isEmpty()) {
            String password = PasswordUtil.passwordDecode((String)new String(trustedPassword.getChars()));
            encoding = this.commonEncode(codec, trustedIdentity, password, targetName);
        }
        return encoding;
    }

    /*
     * WARNING - void declaration
     */
    @Sensitive
    private byte[] encodeGSSUPFromBasicAuthSubject(Codec codec, String targetName) {
        byte[] encoding = new byte[]{};
        Subject subject = this.getSubject();
        SubjectHelper subjectHelper = new SubjectHelper();
        WSCredential wsCredential = null;
        if (subject != null) {
            wsCredential = subjectHelper.getWSCredential(subject);
        }
        if (wsCredential != null && wsCredential.isBasicAuth()) {
            try {
                encoding = this.commonEncode(codec, wsCredential.getSecurityName(), new String(wsCredential.getCredentialToken(), "UTF-8"), targetName);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.transport.iiop.security.config.css.CSSGSSUPMechConfigDynamic", (String)"146", (Object)this, (Object[])new Object[]{codec, targetName});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((TraceComponent)tc, (String)("The GSSUP token could not be encoded because of exception with message: " + e.getMessage()), (Object[])new Object[0]);
                }
            }
        } else if (this.password != null && !this.password.isEmpty() && this.username != null && !this.username.isEmpty()) {
            String scopedUserName = Util.buildScopedUserName(this.username, targetName);
            String pwd = PasswordUtil.passwordDecode((String)new String(this.password.getChars()));
            encoding = Util.encodeGSSUPToken(codec, scopedUserName, pwd.toCharArray(), targetName);
        }
        return encoding;
    }

    private Subject getSubject() {
        SubjectManager subjectManager = new SubjectManager();
        Subject subject = subjectManager.getInvocationSubject();
        if (subject == null) {
            subject = subjectManager.getCallerSubject();
        }
        return subject;
    }

    @Sensitive
    private byte[] commonEncode(Codec codec, String username, @Sensitive String password, String targetName) {
        String extendedUserName = Util.buildScopedUserName(username, targetName);
        return Util.encodeGSSUPToken(codec, extendedUserName, password.toCharArray(), targetName);
    }

    @Trivial
    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString("", buf);
        return buf.toString();
    }

    @Override
    @Trivial
    public void toString(String spaces, StringBuilder buf) {
        String moreSpaces = spaces + "  ";
        buf.append(spaces).append("CSSGSSUPMechConfigDynamic: [\n");
        buf.append(moreSpaces).append("domain:   ").append(this.domain).append("\n");
        if (this.username != null) {
            buf.append(moreSpaces).append("user:   ").append(this.username).append("\n");
        }
        buf.append(spaces).append("]\n");
    }
}

