/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.AuthenticationData;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AuthenticationGuard {
    private static final TraceComponent tc = Tr.register(AuthenticationGuard.class, (String)"Authentication", (String)"com.ibm.ws.security.authentication.internal.resources.AuthenticationMessages");
    private final Map<Object, ReentrantLock> authenticationDataLocks = new HashMap<Object, ReentrantLock>();
    static final long serialVersionUID = 4107967940780451175L;

    public synchronized ReentrantLock requestAccess(AuthenticationData authenticationData) {
        ReentrantLock currentLock = null;
        currentLock = this.authenticationDataLocks.get(authenticationData);
        if (currentLock == null) {
            currentLock = new ReentrantLock();
            this.authenticationDataLocks.put(authenticationData, currentLock);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"The size of the authenticationDataLocks is ", (Object[])new Object[]{this.authenticationDataLocks.size()});
        }
        return currentLock;
    }

    public synchronized void relinquishAccess(AuthenticationData authenticationData, ReentrantLock currentLock) {
        if (currentLock != null) {
            ReentrantLock savedLock = this.authenticationDataLocks.get(authenticationData);
            if (currentLock == savedLock) {
                this.authenticationDataLocks.remove(authenticationData);
            }
            currentLock.unlock();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"The size of the authenticationDataLocks is ", (Object[])new Object[]{this.authenticationDataLocks.size()});
        }
    }
}

