/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.internal.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.cache.AuthCacheService;
import com.ibm.ws.security.authentication.cache.CacheObject;
import com.ibm.ws.security.authentication.internal.cache.AuthCache;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import io.openliberty.jcache.CacheService;
import io.openliberty.jcache.DeserializationException;
import io.openliberty.jcache.SerializationException;
import java.util.HashSet;
import java.util.Set;
import javax.cache.Cache;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JCacheAuthCache
implements AuthCache {
    private static final TraceComponent tc = Tr.register(JCacheAuthCache.class, (String)"Authentication", (String)"com.ibm.ws.security.authentication.internal.resources.AuthenticationMessages");
    private CacheService cacheService = null;
    private final AuthCacheService authCacheService;
    private AuthCache inMemoryCache = null;
    private static final Set<String> NOT_SERIALIZABLE_CREDS = new HashSet<String>();
    private final Set<String> notSerializableClassesLogged = new HashSet<String>();
    static final long serialVersionUID = -4824315519263848994L;

    public JCacheAuthCache(CacheService cacheService, AuthCache inMemoryCache, AuthCacheService authCacheService) {
        this.cacheService = cacheService;
        this.inMemoryCache = inMemoryCache;
        this.authCacheService = authCacheService;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void clearAllEntries(boolean force) {
        Cache<Object, Object> jCache;
        if (!force && !this.authCacheService.getAutoClearCache()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The authentication cache was not cleared. Force clear? " + force + ", Auto-clear enabled? " + this.authCacheService.getAutoClearCache()), (Object[])new Object[0]);
            }
            return;
        }
        this.inMemoryCache.clearAllEntries(force);
        if (!FrameworkState.isStopping() && this.authCacheService.isServerStarted() && (jCache = this.getJCache()) != null) {
            try {
                jCache.removeAll();
                Tr.info((TraceComponent)tc, (String)"JCACHE_AUTH_CACHE_CLEARED_ALL_ENTRIES", (Object[])new Object[]{jCache.getName()});
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.authentication.internal.cache.JCacheAuthCache", (String)"107", (Object)this, (Object[])new Object[]{force});
                Tr.error((TraceComponent)tc, (String)"JCACHE_AUTH_CACHE_CLEAR_FAILED", (Object[])new Object[]{jCache.getName(), e});
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object get(Object key) {
        Object value = null;
        Cache<Object, Object> jCache = this.getJCache();
        if (jCache != null) {
            try {
                value = jCache.get(key);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    if (value == null) {
                        Tr.debug((TraceComponent)tc, (String)("JCache MISS for key " + key), (Object[])new Object[0]);
                    } else {
                        Tr.debug((TraceComponent)tc, (String)("JCache HIT for key " + key), (Object[])new Object[0]);
                    }
                }
            }
            catch (DeserializationException deserializationException) {
                void e;
                FFDCFilter.processException((Throwable)deserializationException, (String)"com.ibm.ws.security.authentication.internal.cache.JCacheAuthCache", (String)"139", (Object)this, (Object[])new Object[]{key});
                Tr.error((TraceComponent)tc, (String)e.getMessage(), (Object[])new Object[0]);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.authentication.internal.cache.JCacheAuthCache", (String)"146", (Object)this, (Object[])new Object[]{key});
                Tr.error((TraceComponent)tc, (String)"JCACHE_AUTH_CACHE_GET_FAILED", (Object[])new Object[]{key, jCache.getName(), e});
            }
        }
        if (value == null) {
            value = this.inMemoryCache.get(key);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                if (value == null) {
                    Tr.debug((TraceComponent)tc, (String)("In-memory cache MISS for key " + key), (Object[])new Object[0]);
                } else {
                    Tr.debug((TraceComponent)tc, (String)("In-memory cache HIT for key " + key), (Object[])new Object[0]);
                }
            }
        }
        return value;
    }

    @Override
    @FFDCIgnore(value={SerializationException.class})
    public void insert(Object key, CacheObject value) {
        boolean forceInMemory = false;
        for (Object cred : value.getSubject().getPrivateCredentials()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Checking private credential: " + cred.getClass()), (Object[])new Object[0]);
            }
            if (!NOT_SERIALIZABLE_CREDS.contains(cred.getClass().getName())) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Private credential: " + cred.getClass() + " will be stored to the in-memory cache."), (Object[])new Object[0]);
            }
            forceInMemory = true;
            break;
        }
        if (!forceInMemory) {
            Cache<Object, Object> jCache = this.getJCache();
            try {
                if (jCache != null) {
                    jCache.put(key, (Object)value);
                }
            }
            catch (SerializationException e) {
                String notSerializableClass = e.getNotSerializableClass();
                if (notSerializableClass == null || !this.notSerializableClassesLogged.contains(notSerializableClass)) {
                    if (notSerializableClass != null) {
                        this.notSerializableClassesLogged.add(notSerializableClass);
                    }
                    Tr.warning((TraceComponent)tc, (String)"JCACHE_AUTH_CACHE_SERIALIZATION_FAILED", (Object[])new Object[]{key, jCache.getName(), e.getMessage()});
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Insertion of entry for the " + key + " key into the " + jCache.getName() + " JCache failed due to a serialization error. The entry will be inserted into the in-memory cache instead."), (Object[])new Object[]{e});
                }
                this.inMemoryCache.insert(key, value);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.authentication.internal.cache.JCacheAuthCache", (String)"220", (Object)this, (Object[])new Object[]{key, value});
                Tr.error((TraceComponent)tc, (String)"JCACHE_AUTH_CACHE_INSERT_FAILED", (Object[])new Object[]{key, jCache.getName(), e});
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Refused to insert value for key " + key + " into " + this.getJCache().getName() + "JCache due to known limitation. Inserting into in-memory cache instead."), (Object[])new Object[0]);
            }
            this.inMemoryCache.insert(key, value);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void remove(Object key) {
        this.inMemoryCache.remove(key);
        Cache<Object, Object> jCache = this.getJCache();
        if (jCache != null) {
            try {
                jCache.remove(key);
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.authentication.internal.cache.JCacheAuthCache", (String)"252", (Object)this, (Object[])new Object[]{key});
                Tr.error((TraceComponent)tc, (String)"JCACHE_AUTH_CACHE_REMOVE_FAILED", (Object[])new Object[]{key, jCache.getName(), e});
            }
        }
    }

    private Cache<Object, Object> getJCache() {
        Cache jCache = null;
        if (this.cacheService != null) {
            jCache = this.cacheService.getCache();
        }
        return jCache;
    }

    @Override
    @Trivial
    public void stopEvictionTask() {
        if (this.inMemoryCache != null) {
            this.inMemoryCache.stopEvictionTask();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        NOT_SERIALIZABLE_CREDS.add("sun.security.jgss.GSSCredentialImpl");
        NOT_SERIALIZABLE_CREDS.add("com.ibm.security.jgss.GSSCredentialImpl");
        NOT_SERIALIZABLE_CREDS.add("com.sun.security.jgss.ExtendedGSSCredentialImpl");
    }
}

