/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.list;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.list.BehindRefList;
import com.ibm.ws.sib.msgstore.list.Link;
import com.ibm.ws.sib.msgstore.list.LinkedList;
import com.ibm.ws.sib.utils.ras.SibTr;

public final class Subcursor {
    private static TraceComponent tc = SibTr.register(Subcursor.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private Link _lastLink = null;
    private final Filter _filter;
    private boolean _jumpbackEnabled;
    private BehindRefList _behindList;
    private long _highestPosition = -1L;
    private final LinkedList _parent;

    public Subcursor(LinkedList parent, Filter filter, boolean jumpbackEnabled) {
        this._parent = parent;
        this._filter = filter;
        this._jumpbackEnabled = jumpbackEnabled;
        if (this._jumpbackEnabled) {
            this._behindList = new BehindRefList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AbstractItemLink _next(long lockID) throws SevereMessageStoreException {
        Subcursor subcursor;
        AbstractItemLink lockedMatchingLink = null;
        if (this._jumpbackEnabled) {
            while (null == lockedMatchingLink) {
                AbstractItemLink link;
                subcursor = this;
                synchronized (subcursor) {
                    link = this._behindList.getFirst(true);
                }
                if (link == null) break;
                if (!link.lockItemIfAvailable(lockID)) continue;
                lockedMatchingLink = link;
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("using available: " + lockedMatchingLink));
            }
        }
        if (null == lockedMatchingLink) {
            AbstractItemLink lookAtLink;
            subcursor = this;
            synchronized (subcursor) {
                lookAtLink = (AbstractItemLink)this.advance();
            }
            while (null != lookAtLink && null == lockedMatchingLink) {
                long pos = lookAtLink.getPosition();
                Subcursor subcursor2 = this;
                synchronized (subcursor2) {
                    if (pos > this._highestPosition) {
                        this._highestPosition = pos;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("examine " + lookAtLink + "(seq = " + this._highestPosition + ")"));
                        }
                    }
                }
                if (lookAtLink.lockIfMatches(this._filter, lockID)) {
                    lockedMatchingLink = lookAtLink;
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("found: " + lockedMatchingLink));
                    continue;
                }
                subcursor2 = this;
                synchronized (subcursor2) {
                    lookAtLink = (AbstractItemLink)this.advance();
                }
            }
        }
        return lockedMatchingLink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void available(AbstractItemLink link) throws SevereMessageStoreException {
        if (this._jumpbackEnabled) {
            long newPos = link.getPosition();
            Subcursor subcursor = this;
            synchronized (subcursor) {
                if (newPos <= this._highestPosition) {
                    if (null != link.matches(this._filter)) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("availableLink adding: " + link));
                        }
                        this._behindList.insert(link);
                    } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("availableLink does not match: " + link));
                    }
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("availableLink seq(" + newPos + ") too large (" + this._highestPosition + ")"));
                }
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("available link - jumpbackDisabled: " + link));
        }
    }

    public final Filter getFilter() {
        return this._filter;
    }

    public final AbstractItem next(boolean allowUnavailable) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"next", (Object)allowUnavailable);
        }
        AbstractItem found = null;
        AbstractItemLink lookAt = (AbstractItemLink)this.advance();
        while (null != lookAt && null == found) {
            found = lookAt.matches(this._filter, allowUnavailable);
            if (null != found) continue;
            lookAt = (AbstractItemLink)this.advance();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"next", (Object)found);
        }
        return found;
    }

    public final AbstractItem next(long lockID) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"next", (Object)lockID);
        }
        AbstractItemLink lockedMatchingLink = this._next(lockID);
        AbstractItem lockedMatchingItem = null;
        if (null != lockedMatchingLink) {
            lockedMatchingItem = lockedMatchingLink.getItem();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"next", (Object)lockedMatchingItem);
        }
        return lockedMatchingItem;
    }

    public final void finished() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"finished");
        }
        if (null != this._lastLink) {
            this._lastLink.cursorRemoved();
            this._lastLink = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"finished");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Link advance() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"advance");
        }
        Link replyLink = null;
        Link newLastLink = null;
        LinkedList linkedList = this._parent;
        synchronized (linkedList) {
            Link lookAt = this._lastLink;
            if (null == lookAt) {
                lookAt = this._parent.getDummyHead();
            }
            lookAt = lookAt.getNextPhysicalLink();
            while (null != lookAt && null == replyLink) {
                if (lookAt.isTail()) {
                    lookAt = null;
                    continue;
                }
                newLastLink = lookAt;
                if (lookAt.isLinked()) {
                    replyLink = lookAt;
                    continue;
                }
                lookAt = lookAt.getNextPhysicalLink();
            }
            if (null != newLastLink && (this._jumpbackEnabled || replyLink != null)) {
                if (null != this._lastLink) {
                    this._lastLink.decrementCursorCount();
                }
                this._lastLink = newLastLink;
                this._lastLink.incrementCursorCount();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"advance", (Object)replyLink);
        }
        return replyLink;
    }

    public final Object peepLastLink() {
        return this._lastLink;
    }

    public final AbstractItem next(boolean allowUnavailable, int fromIndex) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)("next  fromIndex=" + fromIndex), (Object)allowUnavailable);
        }
        AbstractItem found = null;
        AbstractItemLink lookAt = (AbstractItemLink)this.advance();
        while (lookAt != null && lookAt.getPosition() < (long)fromIndex) {
            lookAt = (AbstractItemLink)this.advance();
        }
        while (null == found && lookAt != null) {
            found = lookAt.matches(this._filter, allowUnavailable);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)("next(boolean)  fromIndex=" + fromIndex), (Object)found);
        }
        return found;
    }

    public AbstractItem next(long lockID, int fromIndex) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)("next  fromIndex=" + fromIndex), (Object)lockID);
        }
        AbstractItemLink lockedMatchingLink = this._next(lockID);
        AbstractItem lockedMatchingItem = null;
        while (lockedMatchingLink != null && lockedMatchingLink.getPosition() < (long)fromIndex) {
            lockedMatchingLink = this._next(lockID);
        }
        while (lockedMatchingItem == null && lockedMatchingLink != null) {
            lockedMatchingItem = lockedMatchingLink.getItem();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)("next(lockId)  fromIndex=" + fromIndex), (Object)lockedMatchingItem);
        }
        return lockedMatchingItem;
    }
}

