/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.dispatcher;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.utils.ras.SibTr;

public final class DispatchNotifier {
    private static TraceComponent tc = SibTr.register(DispatchNotifier.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private int _numRequests;
    private boolean _notified;
    private boolean _isRejectable;
    private boolean _dispatchRejected;

    public DispatchNotifier(int numRequests, boolean isRejectable) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{numRequests, isRejectable});
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        this._numRequests = numRequests;
        this._isRejectable = isRejectable;
        this._notified = false;
    }

    public synchronized void notifyDispatch() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"notifyDispatch");
        }
        if (this._numRequests > 0) {
            --this._numRequests;
            if (this._numRequests == 0) {
                this._notified = true;
                this.notify();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"notifyDispatch");
        }
    }

    public synchronized void forceNotify() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"forceNotify");
        }
        if (!this._notified) {
            this._notified = true;
            this.notify();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"forceNotify");
        }
    }

    public boolean isRejectable() {
        return this._isRejectable;
    }

    public synchronized void notifyRejected() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"notifyRejected");
        }
        if (!this._isRejectable) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"This dispatch is not rejectable!");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"notifyRejected");
            }
            throw new IllegalStateException("This dispatch is not rejectable!");
        }
        this._dispatchRejected = true;
        this.forceNotify();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"notifyRejected");
        }
    }

    public synchronized void waitForDispatch() throws PersistenceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"waitForDispatch");
        }
        while (!this._notified) {
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Waiting for dispatch");
                }
                this.wait();
                if (!this._dispatchRejected) continue;
                PersistenceException pe = new PersistenceException("DISPATCHER_CANNOT_ACCEPT_WORK_SIMS1500");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)"The dispatcher cannot accept work.", (Object)((Object)pe));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"waitForDispatch");
                }
                throw pe;
            }
            catch (InterruptedException interruptedException) {
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"waitForDispatch");
        }
    }
}

