/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.task;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.PersistentDataEncodingException;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.cache.links.LinkOwner;
import com.ibm.ws.sib.msgstore.persistence.Operation;
import com.ibm.ws.sib.msgstore.persistence.Persistable;
import com.ibm.ws.sib.msgstore.transactions.impl.PersistentTransaction;
import com.ibm.ws.sib.msgstore.transactions.impl.WorkItem;
import com.ibm.ws.sib.utils.ras.SibTr;

public abstract class Task
implements Operation,
WorkItem {
    private static TraceComponent tc = SibTr.register(Task.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    public static final int DEFAULT_TASK_PERSISTABLE_SIZE_APPROXIMATION = 500;
    private final AbstractItemLink _link;
    private AbstractItem _item = null;
    Task _nextTask = null;

    protected final AbstractItem getItem() throws SevereMessageStoreException {
        if (null == this._item) {
            this._item = this._link.getItem();
            if (null == this._item && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"null item");
            }
        }
        return this._item;
    }

    public Task(AbstractItemLink link) throws SevereMessageStoreException {
        this._link = link;
        if (this._link != null) {
            this.getItem();
        }
    }

    public abstract void abort(PersistentTransaction var1) throws SevereMessageStoreException;

    public abstract void commitExternal(PersistentTransaction var1) throws SevereMessageStoreException;

    public abstract void commitInternal(PersistentTransaction var1) throws SevereMessageStoreException;

    @Override
    public void copyDataIfVulnerable() throws PersistentDataEncodingException, SevereMessageStoreException {
    }

    @Override
    public void ensureDataAvailable() throws PersistentDataEncodingException, SevereMessageStoreException {
        this.copyDataIfVulnerable();
    }

    public final AbstractItemLink getLink() {
        return this._link;
    }

    @Override
    public Persistable getPersistable() {
        return this._link.getTuple();
    }

    final int getStorageStrategy() {
        return this.getPersistable().getStorageStrategy();
    }

    public Type getTaskType() {
        return Type.UNKNOWN;
    }

    @Override
    public boolean isCreateOfPersistentRepresentation() {
        return false;
    }

    @Override
    public boolean isDeleteOfPersistentRepresentation() {
        return false;
    }

    public boolean isRemoveFromList(LinkOwner list) {
        return false;
    }

    public abstract void postAbort(PersistentTransaction var1) throws SevereMessageStoreException;

    public abstract void postCommit(PersistentTransaction var1) throws SevereMessageStoreException;

    public abstract void preCommit(PersistentTransaction var1) throws SevereMessageStoreException;

    public String toString() {
        if (this.getLink() == null) {
            return "[" + this.getTaskType() + "]";
        }
        return "[" + this.getTaskType() + ":" + this.getLink().getID() + "]";
    }

    public static final class Type {
        public static final Type ADD = new Type("Add");
        public static final Type PERSIST_LOCK = new Type("PersistLock");
        public static final Type PERSIST_UNLOCK = new Type("PersistUnlock");
        public static final Type REMOVE = new Type("Remove");
        public static final Type REMOVE_LOCKED = new Type("RemoveLocked");
        public static final Type UNKNOWN = new Type("Unknown");
        public static final Type UPDATE = new Type("Update");
        public static final Type PERSIST_REDELIVERED_COUNT = new Type("PersistRedeliveredCount");
        private String _name;

        private Type(String name) {
            this._name = name;
        }

        public String toString() {
            return this._name;
        }
    }
}

