/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.ApplicationRegistry;
import io.openliberty.microprofile.openapi20.internal.utils.LoggingUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={ApplicationStateListener.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true)
public class ApplicationListener
implements ApplicationStateListener {
    private static final TraceComponent tc = Tr.register(ApplicationListener.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    @Reference
    private ApplicationRegistry appRegistry;
    static final long serialVersionUID = 4589556246512714332L;

    /*
     * WARNING - void declaration
     */
    public void applicationStarting(ApplicationInfo appInfo) throws StateChangeException {
        block4: {
            try {
                if (LoggingUtils.isEventEnabled(tc)) {
                    Tr.event((TraceComponent)tc, (String)("Application starting process started: " + appInfo), (Object[])new Object[0]);
                }
                this.appRegistry.addApplication(appInfo);
                if (LoggingUtils.isEventEnabled(tc)) {
                    Tr.event((TraceComponent)tc, (String)("Application starting process ended: " + appInfo), (Object[])new Object[0]);
                }
            }
            catch (Throwable throwable) {
                void e;
                FFDCFilter.processException((Throwable)throwable, (String)"io.openliberty.microprofile.openapi20.internal.ApplicationListener", (String)"50", (Object)this, (Object[])new Object[]{appInfo});
                if (!LoggingUtils.isEventEnabled(tc)) break block4;
                Tr.event((TraceComponent)tc, (String)("Failed to process application: " + e.getMessage()), (Object[])new Object[0]);
            }
        }
    }

    public void applicationStarted(ApplicationInfo appInfo) throws StateChangeException {
    }

    /*
     * WARNING - void declaration
     */
    public void applicationStopping(ApplicationInfo appInfo) {
        block2: {
            try {
                this.appRegistry.removeApplication(appInfo);
            }
            catch (Throwable throwable) {
                void e;
                FFDCFilter.processException((Throwable)throwable, (String)"io.openliberty.microprofile.openapi20.internal.ApplicationListener", (String)"66", (Object)this, (Object[])new Object[]{appInfo});
                if (!LoggingUtils.isEventEnabled(tc)) break block2;
                Tr.event((TraceComponent)tc, (String)("Failed to remove application: " + e.getMessage()), (Object[])new Object[0]);
            }
        }
    }

    public void applicationStopped(ApplicationInfo appInfo) {
    }
}

